/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.sourcefeature;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLDeclaration;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.core.resolver.shared.OptionalResolutionAction;
import org.eclipse.tycho.extras.sourcefeature.SourceFeatureMojo;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.p2.facade.internal.AttachedArtifact;
import org.eclipse.tycho.p2.metadata.DependencyMetadataGenerator;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.IDependencyMetadata;
import org.eclipse.tycho.p2.resolver.P2MetadataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=P2MetadataProvider.class, hint="org.eclipse.tycho.extras.sourcefeature.SourceFeatureP2MetadataProvider")
public class SourceFeatureP2MetadataProvider
implements P2MetadataProvider,
Initializable {
    @Requirement
    private Logger log;
    @Requirement
    private EquinoxServiceFactory equinox;
    private DependencyMetadataGenerator generator;

    public Map<String, IDependencyMetadata> getDependencyMetadata(MavenSession session, MavenProject project, List<TargetEnvironment> environments, OptionalResolutionAction optionalAction) {
        if (!"eclipse-feature".equals(project.getPackaging())) {
            return null;
        }
        Plugin plugin = project.getPlugin("org.eclipse.tycho.extras:tycho-source-feature-plugin");
        if (plugin != null) {
            if (plugin.getConfiguration() != null && ((Xpp3Dom)plugin.getConfiguration()).getChild("skip") != null && Boolean.valueOf(((Xpp3Dom)plugin.getConfiguration()).getChild("skip").getValue()).booleanValue()) {
                return null;
            }
            try {
                File sourceFeatureBasedir = SourceFeatureMojo.getSourcesFeatureOutputDir(project);
                Feature feature = Feature.read((File)new File(project.getBasedir(), "feature.xml"));
                Document document = new Document();
                document.setRootNode(new Element("feature"));
                document.setXmlDeclaration(new XMLDeclaration("1.0", "UTF-8"));
                Feature sourceFeature = new Feature(document);
                sourceFeature.setId(feature.getId() + ".source");
                sourceFeature.setVersion(feature.getVersion());
                FeatureRef binaryRef = new FeatureRef("includes");
                binaryRef.setId(feature.getId());
                binaryRef.setVersion(feature.getVersion());
                sourceFeature.addFeatureRef(binaryRef);
                Feature.write((Feature)sourceFeature, (File)new File(sourceFeatureBasedir, "feature.xml"));
                String classifier = "sources-feature";
                AttachedArtifact artifact = new AttachedArtifact(project, sourceFeatureBasedir, classifier);
                return Collections.singletonMap(classifier, this.generator.generateMetadata((IArtifactFacade)artifact, null, OptionalResolutionAction.REQUIRE));
            }
            catch (IOException e) {
                this.log.error("Could not create sources feature.xml", (Throwable)e);
            }
        }
        return null;
    }

    public void initialize() throws InitializationException {
        this.generator = (DependencyMetadataGenerator)this.equinox.getService(DependencyMetadataGenerator.class, "(role-hint=dependency-only)");
    }
}

