/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.docbundle;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.extras.docbundle.DocletArtifactsResolver;
import org.eclipse.tycho.extras.docbundle.JavadocOptions;
import org.eclipse.tycho.extras.docbundle.JavadocRunner;
import org.eclipse.tycho.extras.docbundle.TocOptions;
import org.eclipse.tycho.extras.docbundle.TocWriter;

@Mojo(name="javadoc", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=false)
public class JavadocMojo
extends AbstractMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/reference/api", required=true)
    private File outputDirectory;
    @Parameter(property="basedir", required=true, readonly=true)
    private File basedir;
    @Parameter(property="project.build.directory", required=true)
    private File buildDirectory;
    @Parameter(property="cleanFirst", defaultValue="true")
    private boolean cleanFirst;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="reactorProjects", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(property="scopes", defaultValue="compile,provided")
    private Set<String> scopes = new HashSet<String>();
    @Parameter(property="sourceTypes", defaultValue="eclipse-plugin")
    private Set<String> sourceTypes = new HashSet<String>();
    @Parameter(property="javadocOptions")
    private JavadocOptions javadocOptions = new JavadocOptions();
    @Parameter(property="tocOptions")
    private TocOptions tocOptions = new TocOptions();
    @Parameter(property="skipTocGen", defaultValue="false")
    private boolean skipTocGen = false;
    @Parameter(property="tocFile", defaultValue="${project.build.directory}/tocjavadoc.xml")
    private File tocFile;
    @Parameter(property="project.build.sourceEncoding", readonly=true)
    private String projectBuildSourceEncoding;
    @Component
    private BundleReader bundleReader;
    @Component
    private DocletArtifactsResolver docletArtifactsResolver;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;

    public void setTocOptions(TocOptions tocOptions) {
        this.tocOptions = tocOptions;
    }

    public void setSourceTypes(Set<String> sourceTypes) {
        this.sourceTypes = sourceTypes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public void setJavadocOptions(JavadocOptions javadocOptions) {
        this.javadocOptions = javadocOptions;
    }

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Scopes: " + this.scopes));
        this.getLog().info((CharSequence)("Output directory: " + this.outputDirectory));
        this.getLog().info((CharSequence)("BaseDir: " + this.basedir));
        if (this.cleanFirst) {
            this.getLog().info((CharSequence)"Cleaning up first");
            this.cleanUp();
        }
        if (this.javadocOptions.getEncoding() == null) {
            this.javadocOptions.setEncoding(this.projectBuildSourceEncoding);
        }
        JavadocRunner runner = new JavadocRunner();
        runner.setLog(this.getLog());
        runner.setOutput(this.outputDirectory);
        runner.setBuildDirectory(this.buildDirectory);
        runner.setToolchainManager(this.toolchainManager);
        runner.setSession(this.session);
        runner.setDocletArtifactsResolver(this.docletArtifactsResolver);
        GatherManifestVisitor gmv = new GatherManifestVisitor();
        this.visitProjects(this.session.getCurrentProject().getDependencies(), this.scopes, gmv);
        GatherSourcesVisitor gsv = new GatherSourcesVisitor();
        this.visitProjects(this.session.getCurrentProject().getDependencies(), this.scopes, gsv);
        this.getLog().info((CharSequence)String.format("%s source folders", gsv.getSourceFolders().size()));
        for (File file : gsv.getSourceFolders()) {
            this.getLog().info((CharSequence)("Source folder: " + file));
        }
        GatherClasspathVisitor gcv = new GatherClasspathVisitor();
        this.visitProjects(this.session.getCurrentProject().getDependencies(), this.scopes, gcv);
        Set<String> cp = gcv.getClassPath();
        this.getLog().info((CharSequence)String.format("%s classpath deps", cp.size()));
        for (String ele : cp) {
            this.getLog().info((CharSequence)("CP: " + ele));
        }
        runner.setBundleReader(this.bundleReader);
        runner.setOptions(this.javadocOptions);
        runner.setManifestFiles(gmv.getManifestFiles());
        runner.setSourceFolders(gsv.getSourceFolders());
        runner.setClassPath(cp);
        TocWriter tocWriter = new TocWriter();
        tocWriter.setOptions(this.tocOptions);
        tocWriter.setJavadocDir(this.outputDirectory);
        tocWriter.setBasedir(this.basedir);
        tocWriter.setLog(this.getLog());
        try {
            runner.run();
            if (!this.skipTocGen) {
                tocWriter.writeTo(this.tocFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to run javadoc", e);
        }
    }

    private void cleanUp() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            return;
        }
        try {
            FileUtils.deleteDirectory((File)this.outputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clean output directory", (Exception)e);
        }
    }

    private void visitProjects(List<?> dependencies, Set<String> scopes, ProjectVisitor visitor) throws MojoExecutionException {
        for (Dependency dep : dependencies) {
            this.getLog().debug((CharSequence)("Dependency: " + dep + " / scope=" + dep.getScope()));
            String scope = dep.getScope();
            if (!scopes.contains(scope)) continue;
            this.visitDeps(dep, visitor, scopes);
        }
    }

    private void visitDeps(Dependency dep, ProjectVisitor visitor, Set<String> scopes) throws MojoExecutionException {
        MavenProject project = this.findProject(dep.getGroupId(), dep.getArtifactId());
        if (project == null) {
            this.getLog().info((CharSequence)String.format("Did not find project %s in reactor", dep));
            return;
        }
        this.getLog().debug((CharSequence)("Adding sources from: " + project));
        visitor.visit(project);
        this.getLog().debug((CharSequence)("Scanning dependencies: " + project.getDependencies().size()));
        this.visitProjects(project.getDependencies(), scopes, visitor);
        this.getLog().debug((CharSequence)("Done processing: " + project));
    }

    private MavenProject findProject(String groupId, String artifactId) {
        this.getLog().debug((CharSequence)String.format("findProject - groupId: %s, artifactId: %s", groupId, artifactId));
        for (MavenProject p : this.reactorProjects) {
            if (!p.getGroupId().equals(groupId) || !p.getArtifactId().equals(artifactId)) continue;
            return p;
        }
        return null;
    }

    private class GatherClasspathVisitor
    implements ProjectVisitor {
        private final Set<String> classPath = new HashSet<String>();

        private GatherClasspathVisitor() {
        }

        private BundleProject getBundleProject(MavenProject project) throws MojoExecutionException {
            TychoProject projectType = JavadocMojo.this.projectTypes.get(project.getPackaging());
            if (!(projectType instanceof BundleProject)) {
                return null;
            }
            return (BundleProject)projectType;
        }

        @Override
        public void visit(MavenProject project) throws MojoExecutionException {
            BundleProject bp = this.getBundleProject(project);
            if (bp != null) {
                for (ClasspathEntry cpe : bp.getClasspath(project)) {
                    cpe.getLocations().forEach(location -> this.classPath.add(location.getAbsolutePath()));
                }
            }
        }

        public Set<String> getClassPath() {
            return this.classPath;
        }
    }

    private class GatherManifestVisitor
    implements ProjectVisitor {
        private final Set<File> manifestFiles = new HashSet<File>();

        private GatherManifestVisitor() {
        }

        @Override
        public void visit(MavenProject project) {
            if (JavadocMojo.this.sourceTypes.contains(project.getPackaging())) {
                this.manifestFiles.add(new File(project.getBasedir(), "META-INF/MANIFEST.MF"));
            }
        }

        public Set<File> getManifestFiles() {
            return this.manifestFiles;
        }
    }

    private class GatherSourcesVisitor
    implements ProjectVisitor {
        private final Set<File> sourceFolders = new HashSet<File>();

        private GatherSourcesVisitor() {
        }

        @Override
        public void visit(MavenProject project) {
            if (JavadocMojo.this.sourceTypes.contains(project.getPackaging())) {
                for (String root : project.getCompileSourceRoots()) {
                    JavadocMojo.this.getLog().debug((CharSequence)("\tAdding source root: " + root));
                    File rootFile = new File(root);
                    if (!rootFile.isDirectory()) continue;
                    this.sourceFolders.add(rootFile);
                }
            }
        }

        public Set<File> getSourceFolders() {
            return this.sourceFolders;
        }
    }

    private static interface ProjectVisitor {
        public void visit(MavenProject var1) throws MojoExecutionException;
    }
}

