/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.name.Named;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.plexus.ClassRealmUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RealmFilter<T>
implements Iterable<BeanEntry<Named, T>> {
    final Iterable<BeanEntry<Named, T>> beans;

    RealmFilter(Iterable<BeanEntry<Named, T>> beans) {
        this.beans = beans;
    }

    @Override
    public Iterator<BeanEntry<Named, T>> iterator() {
        Set<String> realmNames = ClassRealmUtils.visibleRealmNames(ClassRealmUtils.contextRealm());
        if (null != realmNames && realmNames.size() > 0) {
            return new FilteredItr(realmNames);
        }
        return this.beans.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class FilteredItr
    implements Iterator<BeanEntry<Named, T>> {
        private final Iterator<BeanEntry<Named, T>> itr;
        private final Set<String> realmNames;
        private BeanEntry<Named, T> nextBean;

        public FilteredItr(Set<String> realmNames) {
            this.itr = RealmFilter.this.beans.iterator();
            this.realmNames = realmNames;
        }

        @Override
        public boolean hasNext() {
            if (null != this.nextBean) {
                return true;
            }
            while (this.itr.hasNext()) {
                this.nextBean = this.itr.next();
                String source = this.nextBean.getSource().toString();
                if (source.startsWith("ClassRealm") && !this.realmNames.contains(source)) continue;
                return true;
            }
            this.nextBean = null;
            return false;
        }

        @Override
        public BeanEntry<Named, T> next() {
            if (this.hasNext()) {
                BeanEntry bean = this.nextBean;
                this.nextBean = null;
                return bean;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

