/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.BeanHelper;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectWithFieldsConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return !Map.class.isAssignableFrom(type) && !Collection.class.isAssignableFrom(type) && !Dictionary.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator);
        if (type.isInstance(value)) {
            return value;
        }
        try {
            Class<?> implType = this.getClassForImplementationHint(type, configuration, loader);
            if (null == value && implType.isInterface() && configuration.getChildCount() == 0) {
                return null;
            }
            Object bean = this.instantiateObject(implType);
            if (null == value) {
                this.processConfiguration(lookup, bean, loader, configuration, evaluator, listener);
            } else {
                new BeanHelper(lookup, loader, evaluator, listener).setDefault(bean, value, configuration);
            }
            return bean;
        }
        catch (ComponentConfigurationException e) {
            if (null == e.getFailedConfiguration()) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
    }

    public void processConfiguration(ConverterLookup lookup, Object bean, ClassLoader loader, PlexusConfiguration configuration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        this.processConfiguration(lookup, bean, loader, configuration, evaluator, null);
    }

    public void processConfiguration(ConverterLookup lookup, Object bean, ClassLoader loader, PlexusConfiguration configuration, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        BeanHelper helper = new BeanHelper(lookup, loader, evaluator, listener);
        int size = configuration.getChildCount();
        for (int i = 0; i < size; ++i) {
            Class<?> implType;
            PlexusConfiguration element = configuration.getChild(i);
            String propertyName = this.fromXML(element.getName());
            try {
                implType = this.getClassForImplementationHint(null, element, loader);
            }
            catch (ComponentConfigurationException e) {
                implType = null;
            }
            helper.setProperty(bean, propertyName, implType, element);
        }
    }
}

