/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDODataFactory;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;

public class SDODataFactoryDelegate
implements SDODataFactory {
    private HelperContext aHelperContext;

    public SDODataFactoryDelegate(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    @Override
    public DataObject create(String uri, String typeName) {
        Type sdoType = this.getHelperContext().getTypeHelper().getType(uri, typeName);
        if (sdoType != null) {
            return this.create(sdoType);
        }
        throw new IllegalArgumentException((Throwable)SDOException.typeNotFound((String)uri, (String)typeName));
    }

    @Override
    public DataObject create(Class interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationWithNullInputParameter((String)"create", (String)"interfaceClass"));
        }
        Type type = this.getHelperContext().getTypeHelper().getType(interfaceClass);
        if (type != null) {
            return this.create(type);
        }
        SDOXMLHelper xmlHelper = (SDOXMLHelper)this.getHelperContext().getXMLHelper();
        ClassLoader contextLoader = xmlHelper.getLoader();
        ClassLoader interfaceLoader = interfaceClass.getClassLoader();
        boolean loadersAreRelated = false;
        ArrayList<SDOClassLoader> visitedLoaders = new ArrayList<SDOClassLoader>();
        while (contextLoader != null && !loadersAreRelated && !visitedLoaders.contains(contextLoader)) {
            ClassLoader parentLoader;
            visitedLoaders.add((SDOClassLoader)contextLoader);
            if (contextLoader == interfaceLoader) {
                loadersAreRelated = true;
            }
            if (contextLoader == (parentLoader = contextLoader.getParent())) break;
            contextLoader = parentLoader;
        }
        throw new IllegalArgumentException((Throwable)SDOException.typeNotFoundForInterface((String)interfaceClass.getName(), (boolean)loadersAreRelated));
    }

    @Override
    public DataObject create(Type type) {
        if (type == null) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationWithNullInputParameter((String)"create", (String)"type"));
        }
        SDOType sdoType = (SDOType)type;
        if (sdoType.isAbstract()) {
            throw new IllegalArgumentException((Throwable)SDOException.errorCreatingDataObjectForType((String)sdoType.getURI(), (String)sdoType.getName()));
        }
        if (sdoType.isDataType()) {
            SDOTypeHelper sth = (SDOTypeHelper)this.getHelperContext().getTypeHelper();
            sdoType = (SDOType)sth.getWrappersHashMap().get(sdoType.getQName());
        }
        try {
            Class implClass = sdoType.getImplClass();
            if (implClass != null) {
                SDODataObject theDataObject = (SDODataObject)implClass.newInstance();
                theDataObject._setType(sdoType);
                theDataObject._setHelperContext(this.getHelperContext());
                return theDataObject;
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException((Throwable)SDOException.errorCreatingDataObjectForClass((Exception)e, (String)sdoType.getInstanceClassName(), (String)sdoType.getURI(), (String)sdoType.getName()));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException((Throwable)SDOException.errorCreatingDataObjectForClass((Exception)e, (String)sdoType.getInstanceClassName(), (String)sdoType.getURI(), (String)sdoType.getName()));
        }
        SDODataObject dataObject = new SDODataObject();
        dataObject._setType(sdoType);
        dataObject._setHelperContext(this.getHelperContext());
        return dataObject;
    }

    @Override
    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    @Override
    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

