/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.util.List;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.sequenced.Setting;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSequence;
import org.eclipse.persistence.sdo.SDOType;

public class SDOEqualityHelper
implements EqualityHelper {
    private HelperContext aHelperContext;

    public SDOEqualityHelper() {
    }

    public SDOEqualityHelper(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    @Override
    public boolean equalShallow(DataObject dataObject1, DataObject dataObject2) {
        return this.compareDataObjects(dataObject1, dataObject2, false);
    }

    @Override
    public boolean equal(DataObject dataObject1, DataObject dataObject2) {
        return this.compareDataObjects(dataObject1, dataObject2, true);
    }

    private boolean compareDataObjects(DataObject dataObject1, DataObject dataObject2, boolean isDeep) {
        if (null == dataObject1) {
            return dataObject2 == null;
        }
        if (null == dataObject2) {
            return false;
        }
        if (dataObject1.getType() != dataObject2.getType()) {
            return false;
        }
        if (dataObject1.getType().isSequenced() && !this.compareSequences((SDOSequence)dataObject1.getSequence(), (SDOSequence)dataObject2.getSequence(), isDeep)) {
            return false;
        }
        if (!this.compare(dataObject1, dataObject2, isDeep, dataObject1.getType().getProperties())) {
            return false;
        }
        List properties_1 = ((SDODataObject)dataObject1)._getOpenContentProperties();
        List properties_2 = ((SDODataObject)dataObject2)._getOpenContentProperties();
        if (properties_1.size() != properties_2.size() || !properties_1.containsAll(properties_2)) {
            return false;
        }
        if (!this.compare(dataObject1, dataObject2, isDeep, properties_1)) {
            return false;
        }
        List attrProperties_1 = ((SDODataObject)dataObject1)._getOpenContentPropertiesAttributes();
        List attrProperties_2 = ((SDODataObject)dataObject2)._getOpenContentPropertiesAttributes();
        if (attrProperties_1.size() != attrProperties_2.size() || !attrProperties_1.containsAll(attrProperties_2)) {
            return false;
        }
        return this.compare(dataObject1, dataObject2, isDeep, attrProperties_1);
    }

    private boolean compareSequences(SDOSequence aSequence, SDOSequence aSequenceCopy, boolean isDeep) {
        if (null == aSequence && null == aSequenceCopy) {
            return true;
        }
        if (null == aSequence || null == aSequenceCopy) {
            return false;
        }
        if (isDeep && aSequence.size() != aSequenceCopy.size()) {
            return false;
        }
        List<Setting> originalSettingsList = aSequence.getSettings();
        List<Setting> copySettingsList = aSequenceCopy.getSettings();
        if (null == originalSettingsList || null == copySettingsList) {
            return false;
        }
        SDOProperty originalProperty = null;
        SDOProperty copyProperty = null;
        if (isDeep) {
            int size = aSequence.size();
            for (int index = 0; index < size; ++index) {
                originalProperty = aSequence.getProperty(originalSettingsList.get(index));
                copyProperty = aSequenceCopy.getProperty(copySettingsList.get(index));
                if (null == originalProperty && null != copyProperty || null != originalProperty && null == copyProperty) {
                    return false;
                }
                if (!this.arePropertiesEqual(originalProperty, copyProperty)) {
                    return false;
                }
                Object originalValue = aSequence.getValue(index);
                Object copyValue = aSequenceCopy.getValue(index);
                if (null == originalProperty || originalProperty.getType().isDataType()) {
                    if (null == originalValue && null != copyValue || null != originalValue && null == copyValue) {
                        return false;
                    }
                    if (null == originalValue || originalValue.equals(copyValue)) continue;
                    return false;
                }
                if (!isDeep) continue;
                if (null != originalValue && null != copyValue) {
                    if (originalValue instanceof DataObject && copyValue instanceof DataObject) {
                        if (this.equal((DataObject)originalValue, (DataObject)copyValue)) continue;
                        return false;
                    }
                    if (originalValue instanceof XMLRoot && copyValue instanceof XMLRoot) {
                        XMLRoot originalXMLRoot = (XMLRoot)originalValue;
                        XMLRoot copyXMLRoot = (XMLRoot)copyValue;
                        if (!originalXMLRoot.getLocalName().equals(copyXMLRoot.getLocalName())) {
                            return false;
                        }
                        if (!originalXMLRoot.getNamespaceURI().equals(copyXMLRoot.getNamespaceURI())) {
                            return false;
                        }
                        Object originalUnwrappedValue = originalXMLRoot.getObject();
                        Object copyUnwrappedValue = copyXMLRoot.getObject();
                        if (!(originalUnwrappedValue instanceof DataObject) || !(copyUnwrappedValue instanceof DataObject) || this.equal((DataObject)originalUnwrappedValue, (DataObject)copyUnwrappedValue)) continue;
                        return false;
                    }
                    return false;
                }
                if ((null != originalValue || null == copyValue) && (null != copyValue || null == originalValue)) continue;
                return false;
            }
        } else {
            int cpyIdx = 0;
            for (int idx = 0; idx < aSequence.getSettings().size(); ++idx) {
                SDOProperty nextProperty = aSequence.getProperty(idx);
                if (nextProperty != null && !nextProperty.getType().isDataType()) continue;
                Object nextValue = aSequence.getValue(idx);
                boolean locatedSetting = false;
                while (cpyIdx < aSequenceCopy.getSettings().size()) {
                    SDOProperty nextCopyProperty = aSequenceCopy.getProperty(cpyIdx);
                    if (nextCopyProperty == null || nextCopyProperty.getType().isDataType()) {
                        Object nextCopyValue = aSequenceCopy.getValue(cpyIdx);
                        if (nextValue == nextCopyValue && this.arePropertiesEqual(nextProperty, nextCopyProperty)) {
                            locatedSetting = true;
                        }
                        ++cpyIdx;
                        break;
                    }
                    ++cpyIdx;
                }
                if (locatedSetting) continue;
                return false;
            }
            if (this.getIndexOfNextDataTypeSetting(aSequenceCopy, cpyIdx) != -1) {
                return false;
            }
        }
        return true;
    }

    private int getIndexOfNextDataTypeSetting(SDOSequence aSequence, int index) {
        List<Setting> settings = aSequence.getSettings();
        for (int i = index; i < settings.size(); ++i) {
            SDOProperty nextProperty = aSequence.getProperty(i);
            if (nextProperty != null && !nextProperty.getType().isDataType()) continue;
            return i;
        }
        return -1;
    }

    private boolean arePropertiesEqual(Property prop1, Property prop2) {
        if (null == prop1 && null != prop2 || null != prop1 && null == prop2) {
            return false;
        }
        return prop1.equals(prop2);
    }

    private boolean compare(DataObject dataObject1, DataObject dataObject2, boolean isDeep, List properties) {
        for (SDOProperty p : properties) {
            if (this.compareProperty(dataObject1, dataObject2, isDeep, p)) continue;
            return false;
        }
        return true;
    }

    private boolean compareProperty(DataObject dataObject1, DataObject dataObject2, boolean isDeep, SDOProperty p) {
        if (p.isMany()) {
            return this.compareManyProperty(dataObject1, dataObject2, isDeep, p);
        }
        if (p.getType().isDataType() && !p.getType().isChangeSummaryType()) {
            boolean isSet1 = dataObject1.isSet(p);
            boolean isSet2 = dataObject2.isSet(p);
            if (!isSet1 && !isSet2) {
                return true;
            }
            if (isSet1 && isSet2) {
                Object aProperty1 = dataObject1.get(p);
                Object aProperty2 = dataObject2.get(p);
                if (null == aProperty1) {
                    return aProperty2 == null;
                }
                if (null == aProperty2) {
                    return false;
                }
                return aProperty1.equals(aProperty2);
            }
            return false;
        }
        if (isDeep && !p.getType().isChangeSummaryType()) {
            if (!dataObject1.isSet(p) && !dataObject2.isSet(p)) {
                return true;
            }
            if (!p.getType().isDataType()) {
                if (null == p.getOpposite()) {
                    return this.compareDataObjects(dataObject1.getDataObject(p), dataObject2.getDataObject(p), isDeep);
                }
                return this.compareDataObjects(dataObject1.getDataObject(p), dataObject2.getDataObject(p), false);
            }
            return false;
        }
        return true;
    }

    private boolean compareManyProperty(DataObject dataObject1, DataObject dataObject2, boolean isDeep, Property p) {
        List l1 = dataObject1.getList(p);
        List l2 = dataObject2.getList(p);
        if (((SDOType)p.getType()).isDataType()) {
            if (dataObject1.isSet(p) != dataObject2.isSet(p)) {
                return false;
            }
            if (l1.size() != l2.size()) {
                return false;
            }
            for (int i = 0; i < l1.size(); ++i) {
                Object o2;
                Object o1 = l1.get(i);
                if (o1.equals(o2 = l2.get(i))) continue;
                return false;
            }
            return true;
        }
        if (isDeep) {
            if (dataObject1.isSet(p) != dataObject2.isSet(p)) {
                return false;
            }
            if (l1.size() != l2.size()) {
                return false;
            }
            int size = l1.size();
            for (int i = 0; i < size; ++i) {
                DataObject o1_l1 = (DataObject)l1.get(i);
                DataObject o2_l2 = (DataObject)l2.get(i);
                if (!this.isADataObjectInList(o1_l1, l2)) {
                    return false;
                }
                if (this.isADataObjectInList(o2_l2, l1)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isADataObjectInList(DataObject dataObject1, List objects) {
        for (DataObject dataObject2 : objects) {
            if (!this.compareDataObjects(dataObject1, dataObject2, true)) continue;
            return true;
        }
        return false;
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

