/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.HelperContext;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.EclipseLinkASMClassWriter;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;

public class DynamicClassWriter {
    private static final String START_PROPERTY_INDEX = "START_PROPERTY_INDEX";
    private static final String END_PROPERTY_INDEX = "END_PROPERTY_INDEX";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String LIST = "List";
    private static final String WRITE_REPLACE = "writeReplace";
    private Class parentClass;
    private String typeImplClassDescriptor;
    private SDOType type;
    private Integer startPropertyIndex;
    private HelperContext aHelperContext;

    public DynamicClassWriter(String className, SDOType type, HelperContext aContext) {
        this.aHelperContext = aContext;
        this.parentClass = SDODataObject.class;
        this.typeImplClassDescriptor = className.replace('.', '/');
        this.type = type;
        this.initializeParentClass();
        if (type.isSubType()) {
            try {
                Field parentEndPropertyIndexField = PrivilegedAccessHelper.getField((Class)this.parentClass, (String)END_PROPERTY_INDEX, (boolean)true);
                Integer parentEndPropertyIndex = (Integer)PrivilegedAccessHelper.getValueFromField((Field)parentEndPropertyIndexField, (Object)this.parentClass);
                this.startPropertyIndex = parentEndPropertyIndex + 1;
            }
            catch (NoSuchFieldException e) {
                this.startPropertyIndex = 0;
            }
            catch (IllegalAccessException e) {
                this.startPropertyIndex = 0;
            }
        } else {
            this.startPropertyIndex = 0;
        }
    }

    private void initializeParentClass() {
        if (this.type.isSubType()) {
            SDOType parentSDOType = (SDOType)this.type.getBaseTypes().get(0);
            String parentClassName = parentSDOType.getInstanceClassName() + "Impl";
            try {
                this.parentClass = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader().loadClass(parentClassName, parentSDOType);
            }
            catch (Exception e) {
                this.parentClass = null;
            }
            if (this.parentClass == null) {
                this.parentClass = SDODataObject.class;
            }
        } else {
            this.parentClass = SDODataObject.class;
        }
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public byte[] createClass() {
        EclipseLinkASMClassWriter cw = new EclipseLinkASMClassWriter();
        if (null == this.type.getInstanceClass()) {
            cw.visit(33, this.typeImplClassDescriptor, null, Type.getType((Class)this.parentClass).getInternalName(), null);
        } else {
            String[] interfaces = new String[]{this.type.getInstanceClassName().replace('.', '/')};
            cw.visit(33, this.typeImplClassDescriptor, null, Type.getType((Class)this.parentClass).getInternalName(), interfaces);
            this.addPropertyIndices((ClassWriter)cw);
            for (Object object : this.type.getDeclaredProperties()) {
                SDOProperty sdoProperty = (SDOProperty)object;
                this.addPropertyGetMethod((ClassWriter)cw, sdoProperty);
                this.addPropertySetMethod((ClassWriter)cw, sdoProperty);
            }
        }
        this.addConstructors((ClassWriter)cw);
        this.addWriteReplace((ClassWriter)cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void addPropertyIndices(ClassWriter cw) {
        cw.visitField(25, START_PROPERTY_INDEX, "I", null, (Object)this.startPropertyIndex).visitEnd();
        int declaredPropsSize = this.type.getDeclaredProperties().size();
        Integer endPropertyIndex = declaredPropsSize > 0 ? Integer.valueOf(this.startPropertyIndex + declaredPropsSize - 2) : Integer.valueOf(this.startPropertyIndex - 1);
        cw.visitField(25, END_PROPERTY_INDEX, "I", null, (Object)endPropertyIndex).visitEnd();
    }

    private void addConstructors(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, new String[]{Type.getInternalName(Serializable.class)});
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getType((Class)this.parentClass).getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void addPropertyGetMethod(ClassWriter cw, SDOProperty property) {
        String returnType = SDOUtil.getJavaTypeForProperty(property);
        String outerGetMethodName = SDOUtil.getMethodName(property.getName(), returnType);
        if (property.getType() == SDOConstants.SDO_BOOLEAN || property.getType() == SDOConstants.SDO_BOOLEANOBJECT) {
            String booleanGetterName = SDOUtil.getBooleanGetMethodName(property.getName(), returnType);
            this.addPropertyGetMethodInternal(cw, property, booleanGetterName, returnType);
        }
        this.addPropertyGetMethodInternal(cw, property, outerGetMethodName, returnType);
    }

    private void addPropertyGetMethodInternal(ClassWriter cw, SDOProperty property, String outerGetMethodName, String returnType) {
        Object propertyInstanceClassDescriptor = property.isMany() ? Type.getDescriptor(List.class) : (property.getType().isDataType() ? Type.getDescriptor((Class)property.getType().getInstanceClass()) : "L" + returnType.replace('.', '/') + ";");
        MethodVisitor mv = cw.visitMethod(1, outerGetMethodName, "()" + (String)propertyInstanceClassDescriptor, null, null);
        mv.visitVarInsn(25, 0);
        mv.visitIntInsn(16, this.startPropertyIndex + property.getIndexInType());
        String builtIn = SDOUtil.getBuiltInType(returnType);
        if (null != builtIn) {
            if (property.getType().isDataType() && !builtIn.equals(LIST)) {
                mv.visitMethodInsn(182, this.typeImplClassDescriptor, GET + builtIn, "(I)" + (String)propertyInstanceClassDescriptor, false);
                int iReturnOpcode = Type.getType((Class)property.getType().getInstanceClass()).getOpcode(172);
                mv.visitInsn(iReturnOpcode);
            } else {
                mv.visitMethodInsn(182, this.typeImplClassDescriptor, GET, "(I)Ljava/lang/Object;", false);
                mv.visitInsn(176);
            }
        } else {
            mv.visitMethodInsn(182, this.typeImplClassDescriptor, GET, "(I)Ljava/lang/Object;", false);
            mv.visitInsn(176);
        }
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private void addPropertySetMethod(ClassWriter cw, SDOProperty property) {
        String returnType = SDOUtil.getJavaTypeForProperty(property);
        String outerSetMethodName = SDOUtil.setMethodName(property.getName());
        Object propertyInstanceClassDescriptor = property.isMany() ? Type.getDescriptor(List.class) : (property.getType().isDataType() ? Type.getDescriptor((Class)property.getType().getInstanceClass()) : "L" + returnType.replace('.', '/') + ";");
        MethodVisitor mv = cw.visitMethod(1, outerSetMethodName, "(" + (String)propertyInstanceClassDescriptor + ")V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitIntInsn(16, this.startPropertyIndex + property.getIndexInType());
        String builtIn = SDOUtil.getBuiltInType(returnType);
        int iLoadOpcode = 25;
        if (null != builtIn) {
            if (property.getType().isDataType() && !builtIn.equals(LIST)) {
                iLoadOpcode = Type.getType((Class)property.getType().getInstanceClass()).getOpcode(21);
                mv.visitVarInsn(iLoadOpcode, 1);
                mv.visitMethodInsn(182, this.typeImplClassDescriptor, SET + builtIn, "(I" + (String)propertyInstanceClassDescriptor + ")V", false);
            } else {
                mv.visitVarInsn(iLoadOpcode, 1);
                mv.visitMethodInsn(182, this.typeImplClassDescriptor, SET, "(ILjava/lang/Object;)V", false);
            }
        } else {
            mv.visitVarInsn(iLoadOpcode, 1);
            mv.visitMethodInsn(182, this.typeImplClassDescriptor, SET, "(ILjava/lang/Object;)V", false);
        }
        mv.visitInsn(177);
        if (iLoadOpcode == 24 || iLoadOpcode == 22) {
            mv.visitMaxs(4, 3);
        } else {
            mv.visitMaxs(3, 2);
        }
        mv.visitEnd();
    }

    private void addWriteReplace(ClassWriter cw) {
        Method method;
        try {
            method = this.parentClass.getDeclaredMethod(WRITE_REPLACE, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        MethodVisitor mv = cw.visitMethod(4, method.getName(), Type.getMethodDescriptor((Method)method), null, new String[]{Type.getInternalName(ObjectStreamException.class)});
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName((Class)this.parentClass), method.getName(), Type.getMethodDescriptor((Method)method), false);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }
}

