/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.pgsql;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.persistence.PersistenceException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.json.JsonPlatform;
import org.eclipse.persistence.platform.database.PostgreSQL10Platform;
import org.postgresql.util.PGobject;

public class PostgreSQL10JsonPlatform
extends JsonPlatform
implements PostgreSQL10Platform.PostgreSQL10JsonExtension {
    private static final String JSON_DEFAULT_TYPE = "JSONB";

    public void updateClassTypes(Map<String, Class<?>> classTypeMapping) {
        classTypeMapping.put(JSON_DEFAULT_TYPE, JsonValue.class);
    }

    public void updateFieldTypes(Hashtable<Class<?>, FieldTypeDefinition> fieldTypeMapping) {
        fieldTypeMapping.put(JsonObject.class, new FieldTypeDefinition(JSON_DEFAULT_TYPE));
        fieldTypeMapping.put(JsonArray.class, new FieldTypeDefinition(JSON_DEFAULT_TYPE));
        fieldTypeMapping.put(JsonValue.class, new FieldTypeDefinition(JSON_DEFAULT_TYPE));
    }

    public <T> T convertJsonValueToDataValue(JsonValue jsonValue) throws PersistenceException {
        if (jsonValue == null) {
            return null;
        }
        try {
            PGobject pgObject = new PGobject();
            pgObject.setType(JSON_DEFAULT_TYPE);
            pgObject.setValue((String)super.convertJsonValueToDataValue(jsonValue));
            return (T)pgObject;
        }
        catch (SQLException e) {
            throw new PersistenceException(ExceptionLocalization.buildMessage((String)"json_pgsql_jsonvalue_to_database_type"), (Throwable)e);
        }
    }

    public <T> T getJsonDataFromResultSet(ResultSet resultSet, int columnNumber, Class<T> type) throws SQLException {
        Object rawData = resultSet.getObject(columnNumber);
        if (rawData instanceof PGobject) {
            return type.cast(((PGobject)rawData).getValue());
        }
        if (rawData instanceof String) {
            return type.cast(rawData);
        }
        throw new PersistenceException(ExceptionLocalization.buildMessage((String)"json_pgsql_unknown_type"));
    }

    public boolean isPgObjectInstance(Object parameter) {
        return parameter instanceof PGobject;
    }
}

