/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoDatabaseConnection;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoInteractionSpec;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoListRecord;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoOperation;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoRecord;

public class MongoDatabaseInteraction
implements Interaction {
    protected MongoDatabaseConnection connection;

    public MongoDatabaseInteraction(MongoDatabaseConnection connection) {
        this.connection = connection;
    }

    public void clearWarnings() {
    }

    public void close() {
    }

    public boolean execute(InteractionSpec spec, Record input, Record output) throws ResourceException {
        if (!(spec instanceof MongoInteractionSpec)) {
            throw EISException.invalidInteractionSpecType();
        }
        if (!(input instanceof MongoRecord) || !(output instanceof MongoRecord)) {
            throw EISException.invalidRecordType();
        }
        MongoInteractionSpec mongoSpec = (MongoInteractionSpec)spec;
        MongoRecord record = (MongoRecord)input;
        MongoRecord translationRecord = (MongoRecord)output;
        MongoOperation operation = mongoSpec.getOperation();
        String collectionName = mongoSpec.getCollection();
        if (operation == null) {
            throw new ResourceException("Mongo operation must be set");
        }
        if (collectionName == null) {
            throw new ResourceException("DB Collection name must be set");
        }
        try {
            MongoCollection collection = this.connection.getDB().getCollection(collectionName);
            BasicDBObject object = this.buildDBObject(record);
            BasicDBObject translation = this.buildDBObject(translationRecord);
            if (operation == MongoOperation.UPDATE) {
                Document update = new Document("$set", (Object)object);
                UpdateOptions options = new UpdateOptions().upsert(mongoSpec.isUpsert());
                UpdateResult result = mongoSpec.isMulti() ? collection.updateMany((Bson)translation, (Bson)update, options) : collection.updateOne((Bson)translation, (Bson)update, options);
                return result.getModifiedCount() > 0L;
            }
            throw new ResourceException("Invalid operation: " + (Object)((Object)operation));
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(exception.toString());
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Record execute(InteractionSpec spec, Record record) throws ResourceException {
        if (!(spec instanceof MongoInteractionSpec)) {
            throw EISException.invalidInteractionSpecType();
        }
        if (!(record instanceof MongoRecord)) {
            throw EISException.invalidRecordType();
        }
        MongoInteractionSpec mongoSpec = (MongoInteractionSpec)spec;
        MongoRecord input = (MongoRecord)record;
        MongoOperation operation = mongoSpec.getOperation();
        String collectionName = mongoSpec.getCollection();
        if (operation == null) {
            ResourceException resourceException = new ResourceException("Mongo operation must be set");
            throw resourceException;
        }
        if (operation == MongoOperation.EVAL) {
            Document commandDocument = new Document("$eval", (Object)mongoSpec.getCode());
            Document result = this.connection.getDB().runCommand((Bson)commandDocument);
            return this.buildRecordFromDBObject((Document)result.get((Object)"retval"));
        }
        if (collectionName == null) {
            ResourceException resourceException = new ResourceException("DB Collection name must be set");
            throw resourceException;
        }
        try {
            MongoCollection collection = this.connection.getDB().getCollection(collectionName);
            mongoSpec.getOptions();
            if (mongoSpec.getReadPreference() != null) {
                collection = collection.withReadPreference(mongoSpec.getReadPreference());
            }
            if (mongoSpec.getWriteConcern() != null) {
                collection = collection.withWriteConcern(mongoSpec.getWriteConcern());
            }
            if (operation == MongoOperation.INSERT) {
                Document object = this.buildDocument(input);
                collection.insertOne((Object)object);
                return null;
            }
            if (operation == MongoOperation.REMOVE) {
                Document object = this.buildDocument(input);
                collection.deleteOne((Bson)object);
                return null;
            }
            if (operation != MongoOperation.FIND) throw new ResourceException("Invalid operation: " + (Object)((Object)operation));
            BasicDBObject sort = null;
            if (input.containsKey("$sort")) {
                sort = this.buildDBObject((MongoRecord)input.get("$sort"));
                input.remove("$sort");
            }
            if (input.containsKey("$select")) {
                this.buildDBObject((MongoRecord)input.get("$select"));
                input.remove("$select");
            }
            BasicDBObject object = this.buildDBObject(input);
            FindIterable iterable = collection.find((Bson)object);
            if (sort != null) {
                iterable.sort((Bson)sort);
            }
            try (MongoCursor cursor = iterable.iterator();){
                if (mongoSpec.getSkip() > 0) {
                    iterable.skip(mongoSpec.getSkip());
                }
                if (mongoSpec.getLimit() != 0) {
                    iterable.limit(mongoSpec.getLimit());
                }
                if (mongoSpec.getBatchSize() != 0) {
                    iterable.batchSize(mongoSpec.getBatchSize());
                }
                if (!cursor.hasNext()) {
                    return null;
                }
                MongoListRecord results = new MongoListRecord();
                while (true) {
                    if (!cursor.hasNext()) {
                        MongoListRecord mongoListRecord = results;
                        return mongoListRecord;
                    }
                    Document result = (Document)cursor.next();
                    results.add(this.buildRecordFromDBObject(result));
                }
            }
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(exception.toString());
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
    }

    public BasicDBObject buildDBObject(MongoRecord record) {
        BasicDBObject object = new BasicDBObject();
        for (Map.Entry entry : record.entrySet()) {
            if (entry.getValue() instanceof MongoRecord) {
                object.put((Object)((String)entry.getKey()), (Object)this.buildDBObject((MongoRecord)entry.getValue()));
                continue;
            }
            object.put((Object)((String)entry.getKey()), entry.getValue());
        }
        return object;
    }

    public Document buildDocument(MongoRecord record) {
        Document object = new Document();
        for (Map.Entry entry : record.entrySet()) {
            if (entry.getValue() instanceof MongoRecord) {
                object.put((String)entry.getKey(), (Object)this.buildDBObject((MongoRecord)entry.getValue()));
                continue;
            }
            object.put((String)entry.getKey(), entry.getValue());
        }
        return object;
    }

    public MongoRecord buildRecordFromDBObject(Document object) {
        MongoRecord record = new MongoRecord();
        for (Map.Entry entry : object.entrySet()) {
            if (entry.getValue() instanceof BasicDBList) {
                ArrayList<MongoRecord> values = new ArrayList<MongoRecord>();
                for (Object value : (BasicDBList)entry.getValue()) {
                    if (value instanceof Document) {
                        values.add(this.buildRecordFromDBObject((Document)value));
                        continue;
                    }
                    values.add((MongoRecord)value);
                }
                record.put(entry.getKey(), values);
                continue;
            }
            if (entry.getValue() instanceof Document) {
                MongoRecord nestedRecord = this.buildRecordFromDBObject((Document)entry.getValue());
                record.put(entry.getKey(), nestedRecord);
                continue;
            }
            record.put(entry.getKey(), entry.getValue());
        }
        return record;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }
}

