/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import jakarta.xml.bind.Unmarshaller;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.exceptions.XMLMarshalException;

public class JAXBUnmarshalListener
implements XMLUnmarshalListener {
    private Unmarshaller.Listener listener;
    private Map classBasedUnmarshalEvents;
    private Unmarshaller unmarshaller;

    public JAXBUnmarshalListener(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void setListener(Unmarshaller.Listener jaxbListener) {
        this.listener = jaxbListener;
    }

    public Unmarshaller.Listener getListener() {
        return this.listener;
    }

    public void beforeUnmarshal(Object target, Object parent) {
        UnmarshalCallback callback;
        if (this.classBasedUnmarshalEvents != null && (callback = (UnmarshalCallback)this.classBasedUnmarshalEvents.get(target.getClass().getName())) != null && callback.getBeforeUnmarshalCallback() != null) {
            PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod((Method)callback.getBeforeUnmarshalCallback(), (Object)target, (Object[])new Object[]{this.unmarshaller, parent}), ex -> XMLMarshalException.unmarshalException((Exception)ex));
        }
        if (this.listener != null) {
            this.listener.beforeUnmarshal(target, parent);
        }
    }

    public void afterUnmarshal(Object target, Object parent) {
        UnmarshalCallback callback;
        if (this.classBasedUnmarshalEvents != null && (callback = (UnmarshalCallback)this.classBasedUnmarshalEvents.get(target.getClass().getName())) != null && callback.getAfterUnmarshalCallback() != null) {
            PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod((Method)callback.getAfterUnmarshalCallback(), (Object)target, (Object[])new Object[]{this.unmarshaller, parent}), ex -> XMLMarshalException.unmarshalException((Exception)ex));
        }
        if (this.listener != null) {
            this.listener.afterUnmarshal(target, parent);
        }
    }

    public void setClassBasedUnmarshalEvents(Map events) {
        this.classBasedUnmarshalEvents = events;
    }
}

