/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.eclipse.persistence.internal.jaxb.cache.ComputableTask;
import org.eclipse.persistence.internal.jaxb.cache.LowLevelProcessor;

public class Memoizer<A, V>
implements LowLevelProcessor<A, V> {
    private final ConcurrentMap<MemoizerKey, Future<V>> cache = new ConcurrentHashMap<MemoizerKey, Future<V>>();
    private final KeyStorage keyStorage = new KeyStorage();

    /*
     * Loose catch block
     */
    @Override
    public V compute(final ComputableTask<A, V> c, final A taskArg) throws InterruptedException {
        MemoizerKey key = this.keyStorage.get(c, taskArg);
        while (true) {
            Callable evaluation;
            FutureTask ft;
            FutureTask f;
            if ((f = (FutureTask)this.cache.get(key)) == null && (f = (Future)this.cache.putIfAbsent(key, ft = new FutureTask(evaluation = new Callable<V>(){

                @Override
                public V call() throws InterruptedException {
                    return c.compute(taskArg);
                }
            }))) == null) {
                f = ft;
                ft.run();
            }
            try {
                return f.get();
            }
            catch (CancellationException e) {
                this.cache.remove(key, f);
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void forget(ComputableTask<A, V> task, A key) {
        this.cache.remove(new MemoizerKey(task, key));
    }

    public void forgetAll() {
        this.cache.clear();
    }

    private class KeyStorage {
        Map<MemoizerKey, MemoizerKey> map = new ConcurrentHashMap<MemoizerKey, MemoizerKey>();

        private KeyStorage() {
        }

        public MemoizerKey get(ComputableTask<A, V> c, A taskArg) {
            MemoizerKey certificate = new MemoizerKey(c, taskArg);
            MemoizerKey key = this.map.putIfAbsent(certificate, certificate);
            return key == null ? certificate : key;
        }
    }

    private class MemoizerKey {
        private final ComputableTask<A, V> task;
        private final A key;

        private MemoizerKey(ComputableTask<A, V> task, A key) {
            this.task = task;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemoizerKey cacheKey = (MemoizerKey)o;
            if (!Objects.equals(this.key, cacheKey.key)) {
                return false;
            }
            return Objects.equals(this.task, cacheKey.task);
        }

        public int hashCode() {
            int result = this.task != null ? this.task.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }
    }
}

