/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import jakarta.xml.bind.Marshaller;
import java.lang.reflect.Method;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class MarshalCallback {
    private Class<?> domainClass;
    private String domainClassName;
    private Method beforeMarshalCallback;
    private Method afterMarshalCallback;
    private boolean hasBeforeMarshalCallback = false;
    private boolean hasAfterMarshalCallback = false;

    public Method getAfterMarshalCallback() {
        return this.afterMarshalCallback;
    }

    public Method getBeforeMarshalCallback() {
        return this.beforeMarshalCallback;
    }

    public Class<?> getDomainClass() {
        return this.domainClass;
    }

    public void initialize(ClassLoader loader) {
        try {
            this.domainClass = (Class)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName((String)this.domainClassName, (boolean)true, (ClassLoader)loader));
        }
        catch (ClassNotFoundException ex) {
            return;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed initialization of %s class", this.domainClassName), ex);
        }
        Class[] params = new Class[]{Marshaller.class};
        if (this.hasBeforeMarshalCallback) {
            try {
                Method beforeMarshal = (Method)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(this.domainClass, (String)"beforeMarshal", (Class[])params, (boolean)false));
                this.setBeforeMarshalCallback(beforeMarshal);
            }
            catch (NoSuchMethodException beforeMarshal) {
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Failed initialization of beforeMarshal method of %s class", this.domainClassName), ex);
            }
        }
        if (this.hasAfterMarshalCallback) {
            try {
                Method afterMarshal = (Method)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(this.domainClass, (String)"afterMarshal", (Class[])params, (boolean)false));
                this.setAfterMarshalCallback(afterMarshal);
            }
            catch (NoSuchMethodException afterMarshal) {
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Failed initialization of afterMarshal method of %s class", this.domainClassName), ex);
            }
        }
    }

    public void setAfterMarshalCallback(Method method) {
        this.afterMarshalCallback = method;
    }

    public void setHasAfterMarshalCallback() {
        this.hasAfterMarshalCallback = true;
    }

    public void setBeforeMarshalCallback(Method method) {
        this.beforeMarshalCallback = method;
    }

    public void setHasBeforeMarshalCallback() {
        this.hasBeforeMarshalCallback = true;
    }

    public void setDomainClass(Class<?> clazz) {
        this.domainClass = clazz;
        this.setDomainClassName(clazz.getName());
    }

    public void setDomainClassName(String className) {
        this.domainClassName = className;
    }
}

