/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaClassInstanceOf;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaConstructorImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaFieldImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaMethodImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaPackageImpl;

public class XJCJavaClassImpl
implements JavaClass {
    private JDefinedClass xjcClass;
    private JCodeModel jCodeModel;
    private JavaModel javaModel;
    private boolean isArray;
    private boolean isPrimitive;
    private JavaClass arg;
    private DynamicClassLoader dynamicClassLoader;
    private static final Map<String, JPrimitiveType> jPrimitiveTypes = new HashMap<String, JPrimitiveType>();

    public XJCJavaClassImpl(JDefinedClass jDefinedClass, JCodeModel codeModel, DynamicClassLoader loader) {
        this(jDefinedClass, codeModel, loader, false, false);
    }

    public XJCJavaClassImpl(JDefinedClass jDefinedClass, JCodeModel codeModel, DynamicClassLoader loader, boolean isArray, boolean isPrimitive) {
        this.xjcClass = jDefinedClass;
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = loader;
        this.isArray = isArray;
        this.isPrimitive = isPrimitive;
    }

    public void setActualTypeArgument(JavaClass javaClass) {
        this.arg = javaClass;
    }

    @Override
    public Collection<JavaClass> getActualTypeArguments() {
        JTypeVar[] typeParams = this.xjcClass.typeParams();
        if (null == typeParams || 0 == typeParams.length) {
            if (this.arg != null) {
                ArrayList<JavaClass> theList = new ArrayList<JavaClass>(1);
                theList.add(this.arg);
                return theList;
            }
            return new ArrayList<JavaClass>(0);
        }
        try {
            JavaClass boundClass;
            ArrayList<JavaClass> typeArguments = new ArrayList<JavaClass>(1);
            JTypeVar var = typeParams[typeParams.length - 1];
            JClass xjcBoundClass = var.bound();
            JClass basis = xjcBoundClass.erasure();
            if (basis != null) {
                boundClass = this.javaModel.getClass(basis.fullName());
            } else if (this.javaModel != null) {
                boundClass = this.javaModel.getClass(xjcBoundClass.fullName());
            } else {
                JDefinedClass c = this.jCodeModel._getClass(xjcBoundClass.fullName());
                boundClass = new XJCJavaClassImpl(c, this.jCodeModel, this.dynamicClassLoader);
            }
            typeArguments.add(boundClass);
            return typeArguments;
        }
        catch (Exception e) {
            return new ArrayList<JavaClass>(0);
        }
    }

    @Override
    public JavaClass getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return this.javaModel.getClass(this.xjcClass.fullName());
    }

    @Override
    public JavaConstructor getConstructor(JavaClass[] parameterTypes) {
        JType[] xjcParameterTypes = new JType[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaClass pType = parameterTypes[i];
            String className = pType.getQualifiedName();
            Object xjcType = null;
            xjcType = pType.isPrimitive() ? (JType)jPrimitiveTypes.get(className) : this.jCodeModel._getClass(className);
            xjcParameterTypes[i] = xjcType;
        }
        JMethod constructor = this.xjcClass.getConstructor(xjcParameterTypes);
        return new XJCJavaConstructorImpl(constructor, this.jCodeModel, this.dynamicClassLoader, this);
    }

    @Override
    public Collection<JavaConstructor> getConstructors() {
        ArrayList<JavaConstructor> constructors = new ArrayList<JavaConstructor>();
        Iterator it = this.xjcClass.constructors();
        while (it.hasNext()) {
            constructors.add(new XJCJavaConstructorImpl((JMethod)it.next(), this.jCodeModel, this.dynamicClassLoader, this));
        }
        return constructors;
    }

    @Override
    public Collection<JavaClass> getDeclaredClasses() {
        ArrayList<JavaClass> declaredClasses = new ArrayList<JavaClass>();
        Iterator it = this.xjcClass.classes();
        while (it.hasNext()) {
            XJCJavaClassImpl dc = this.javaModel != null ? (XJCJavaClassImpl)this.javaModel.getClass(((JDefinedClass)it.next()).fullName()) : new XJCJavaClassImpl((JDefinedClass)it.next(), this.jCodeModel, this.dynamicClassLoader);
            declaredClasses.add(dc);
        }
        return declaredClasses;
    }

    @Override
    public JavaConstructor getDeclaredConstructor(JavaClass[] parameterTypes) {
        return this.getConstructor(parameterTypes);
    }

    @Override
    public Collection<JavaConstructor> getDeclaredConstructors() {
        return this.getConstructors();
    }

    @Override
    public JavaField getDeclaredField(String fieldName) {
        JFieldVar xjcField = (JFieldVar)this.xjcClass.fields().get(fieldName);
        return new XJCJavaFieldImpl(xjcField, this.jCodeModel, this.dynamicClassLoader, this);
    }

    @Override
    public Collection<JavaField> getDeclaredFields() {
        Collection xjcFields = this.xjcClass.fields().values();
        ArrayList<JavaField> fields = new ArrayList<JavaField>(xjcFields.size());
        for (JFieldVar jField : xjcFields) {
            fields.add(new XJCJavaFieldImpl(jField, this.jCodeModel, this.dynamicClassLoader, this));
        }
        return fields;
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaClass[] args) {
        return this.getMethod(name, args);
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods() {
        return this.getMethods();
    }

    @Override
    public JavaMethod getMethod(String name, JavaClass[] args) {
        Collection xjcMethods = this.xjcClass.methods();
        for (JMethod xjcMethod : xjcMethods) {
            JType[] params = xjcMethod.listParamTypes();
            boolean argsAreEqual = this.argsAreEqual(args, params);
            if (!xjcMethod.name().equals(name) || !argsAreEqual) continue;
            return new XJCJavaMethodImpl(xjcMethod, this.jCodeModel, this.dynamicClassLoader, this);
        }
        return null;
    }

    private boolean argsAreEqual(JavaClass[] elinkArgs, JType[] xjcArgs) {
        if (elinkArgs == null && xjcArgs == null) {
            return true;
        }
        if (elinkArgs != null && xjcArgs == null) {
            return false;
        }
        if (elinkArgs == null && xjcArgs != null) {
            return false;
        }
        if (elinkArgs.length != xjcArgs.length) {
            return false;
        }
        for (int i = 0; i < elinkArgs.length; ++i) {
            JavaClass elinkClass = elinkArgs[i];
            JType xjcClass = xjcArgs[i];
            if (elinkClass.getQualifiedName().equals(xjcClass.fullName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<JavaMethod> getMethods() {
        Collection xjcMethods = this.xjcClass.methods();
        ArrayList<JavaMethod> elinkMethods = new ArrayList<JavaMethod>(xjcMethods.size());
        for (JMethod xjcMethod : xjcMethods) {
            elinkMethods.add(new XJCJavaMethodImpl(xjcMethod, this.jCodeModel, this.dynamicClassLoader, this));
        }
        return elinkMethods;
    }

    @Override
    public int getModifiers() {
        return this.xjcClass.mods().getValue();
    }

    @Override
    public String getName() {
        return this.getQualifiedName();
    }

    @Override
    public JavaPackage getPackage() {
        return new XJCJavaPackageImpl(this.xjcClass.getPackage(), this.dynamicClassLoader);
    }

    @Override
    public String getPackageName() {
        return this.xjcClass._package().name();
    }

    @Override
    public String getQualifiedName() {
        if (this.isArray) {
            if (this.isPrimitive) {
                return this.getPrimitiveArrayNameFor(this.xjcClass.fullName());
            }
            return "[L" + this.xjcClass.fullName();
        }
        return this.xjcClass.fullName();
    }

    private String getPrimitiveArrayNameFor(String fullName) {
        Class componentClass = ConversionManager.getPrimitiveClass((String)fullName);
        if (componentClass != null) {
            if (componentClass == ClassConstants.PBYTE) {
                return ClassConstants.APBYTE.getName();
            }
            if (componentClass == ClassConstants.PCHAR) {
                return ClassConstants.APCHAR.getName();
            }
            if (componentClass == ClassConstants.PBOOLEAN) {
                return boolean[].class.getName();
            }
            if (componentClass == ClassConstants.PDOUBLE) {
                return double[].class.getName();
            }
            if (componentClass == ClassConstants.PFLOAT) {
                return float[].class.getName();
            }
            if (componentClass == ClassConstants.PINT) {
                return int[].class.getName();
            }
            if (componentClass == ClassConstants.PLONG) {
                return long[].class.getName();
            }
            if (componentClass == ClassConstants.PSHORT) {
                return short[].class.getName();
            }
        }
        return fullName;
    }

    @Override
    public String getRawName() {
        if (this.isArray) {
            return this.xjcClass.fullName() + "[]";
        }
        return this.xjcClass.fullName();
    }

    @Override
    public JavaClass getSuperclass() {
        try {
            JClass superClass = this.xjcClass.superClass();
            if (superClass == null) {
                return null;
            }
            if (superClass instanceof JDefinedClass) {
                if (this.javaModel != null) {
                    return this.javaModel.getClass(superClass.fullName());
                }
                return new XJCJavaClassImpl((JDefinedClass)superClass, this.jCodeModel, this.dynamicClassLoader);
            }
            if (this.javaModel != null) {
                return this.javaModel.getClass(superClass.fullName());
            }
            return new XJCJavaClassImpl((JDefinedClass)superClass, this.jCodeModel, this.dynamicClassLoader);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Type[] getGenericInterfaces() {
        return new Type[0];
    }

    @Override
    public Type getGenericSuperclass() {
        return null;
    }

    @Override
    public boolean hasActualTypeArguments() {
        return this.xjcClass.typeParams().length > 0;
    }

    @Override
    public boolean isAbstract() {
        return this.xjcClass.isAbstract();
    }

    @Override
    public boolean isAnnotation() {
        return this.xjcClass.isAnnotationTypeDeclaration();
    }

    @Override
    public boolean isArray() {
        if (this.isArray) {
            return true;
        }
        return this.xjcClass.isArray();
    }

    @Override
    public boolean isAssignableFrom(JavaClass javaClass) {
        if (javaClass == null) {
            return false;
        }
        XJCJavaClassImpl javaClassImpl = (XJCJavaClassImpl)javaClass;
        JDefinedClass someClass = javaClassImpl.xjcClass;
        return this.xjcClass.isAssignableFrom((JClass)someClass);
    }

    @Override
    public boolean isEnum() {
        return this.xjcClass.getClassType().equals(ClassType.ENUM);
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public boolean isInterface() {
        return this.xjcClass.isInterface();
    }

    @Override
    public boolean isMemberClass() {
        return this.xjcClass.outer() != null;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        throw new UnsupportedOperationException("isSynthetic");
    }

    @Override
    public JavaClassInstanceOf instanceOf() {
        return JavaClassInstanceOf.XJC_JAVA_CLASS_IMPL;
    }

    @Override
    public JavaAnnotation getAnnotation(JavaClass aClass) {
        if (aClass != null) {
            Collection annotations = this.xjcClass.annotations();
            for (JAnnotationUse annotationUse : annotations) {
                String annotationClass;
                XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
                String myAnnotationClass = xjcAnnotation.getJavaAnnotationClass().getCanonicalName();
                if (!myAnnotationClass.equals(annotationClass = aClass.getQualifiedName())) continue;
                return xjcAnnotation;
            }
            return null;
        }
        return null;
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>();
        Collection annotations = this.xjcClass.annotations();
        for (JAnnotationUse annotationUse : annotations) {
            XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
            annotationsList.add(xjcAnnotation);
        }
        return annotationsList;
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        return this.getAnnotation(arg0);
    }

    @Override
    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public JavaModel getJavaModel() {
        return this.javaModel;
    }

    public void setJavaModel(JavaModel javaModel) {
        this.javaModel = javaModel;
    }

    static {
        JCodeModel tempCodeModel = new JCodeModel();
        jPrimitiveTypes.put("java.lang.Boolean", tempCodeModel.BOOLEAN);
        jPrimitiveTypes.put("java.lang.Byte", tempCodeModel.BYTE);
        jPrimitiveTypes.put("java.lang.Character", tempCodeModel.CHAR);
        jPrimitiveTypes.put("java.lang.Double", tempCodeModel.DOUBLE);
        jPrimitiveTypes.put("java.lang.Float", tempCodeModel.FLOAT);
        jPrimitiveTypes.put("java.lang.Integer", tempCodeModel.INT);
        jPrimitiveTypes.put("java.lang.Long", tempCodeModel.LONG);
        jPrimitiveTypes.put("java.lang.Short", tempCodeModel.SHORT);
    }
}

