/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.jaxb.DefaultXMLNameTransformer;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessOrder;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethods;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLNameTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfo {
    private XMLDescriptor descriptor;
    private String javaClassName;
    private ComplexType complexType;
    private boolean hasRootElement;
    private String elementRefsPropertyName;
    private Schema schema;
    private SimpleType simpleType;
    private ArrayList<String> propOrder;
    private String classNamespace;
    private String schemaTypeName;
    private TypeDefParticle compositor;
    private ArrayList<String> propertyNames = new ArrayList();
    private ArrayList<Property> propertyList;
    private HashMap<String, Property> properties = new HashMap();
    private HashMap<String, Property> originalProperties = new HashMap();
    private Map<String, List<Property>> additionalProperties;
    private Property idProperty;
    private HashMap<String, JavaClass> packageLevelAdaptersByClass;
    private String objectFactoryClassName;
    private String factoryMethodName;
    private String[] factoryMethodParamTypes;
    private Property xmlValueProperty;
    private String classExtractorName;
    private Map<Object, Object> userProperties;
    private List<Property> xmlKeyProperties;
    private List<Property> predicateProperties;
    private boolean isMixed;
    private boolean isTransient;
    private boolean isPreBuilt = false;
    private boolean isPostBuilt = false;
    private boolean isSetXmlTransient = false;
    private List<String> xmlSeeAlso;
    private XmlRootElement xmlRootElement;
    private XmlType xmlType;
    private XmlAccessType xmlAccessType;
    private XmlAccessOrder xmlAccessOrder;
    private XmlJavaTypeAdapter xmlJavaTypeAdapter;
    private String xmlCustomizer;
    private XmlVirtualAccessMethods xmlExtensible;
    private String anyAttributePropertyName;
    private String anyElementPropertyName;
    private boolean isBinaryDataInlined;
    private String xmlDiscriminatorNode;
    private String xmlDiscriminatorValue;
    private static String EMPTY_STRING = "";
    private XMLNameTransformer xmlNameTransformer;
    private JavaClass javaClass;
    public static XMLNameTransformer DEFAULT_NAME_TRANSFORMER = new DefaultXMLNameTransformer();

    public TypeInfo(Helper helper, JavaClass javaClass) {
        this.propertyList = new ArrayList();
        this.xmlNameTransformer = DEFAULT_NAME_TRANSFORMER;
        this.javaClass = javaClass;
    }

    public XMLDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(XMLDescriptor desc) {
        this.descriptor = desc;
    }

    public ComplexType getComplexType() {
        return this.complexType;
    }

    public void setComplexType(ComplexType type) {
        this.complexType = type;
    }

    public SimpleType getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(SimpleType type) {
        this.simpleType = type;
    }

    public String[] getPropOrder() {
        if (this.propOrder == null) {
            return new String[0];
        }
        return this.propOrder.toArray(new String[this.propOrder.size()]);
    }

    public boolean isSetPropOrder() {
        return this.propOrder != null;
    }

    public void setPropOrder(String[] order) {
        if (order == null) {
            this.propOrder = null;
        } else if (order.length == 0) {
            this.propOrder = new ArrayList();
        } else {
            this.propOrder = new ArrayList(order.length);
            for (String next : order) {
                this.propOrder.add(next);
            }
        }
    }

    public String getClassNamespace() {
        return this.classNamespace;
    }

    public void setClassNamespace(String namespace) {
        this.classNamespace = namespace;
    }

    public boolean isComplexType() {
        return this.complexType != null;
    }

    public boolean isMixed() {
        return this.isMixed;
    }

    public void setMixed(boolean isMixed) {
        this.isMixed = isMixed;
    }

    public TypeDefParticle getCompositor() {
        return this.compositor;
    }

    public void setCompositor(TypeDefParticle particle) {
        this.compositor = particle;
    }

    public ArrayList<String> getPropertyNames() {
        return this.propertyNames;
    }

    public Property getIDProperty() {
        return this.idProperty;
    }

    public HashMap<String, Property> getProperties() {
        return this.properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addProperty(String name, Property property) {
        if (this.originalProperties.get(name) != null) {
            Property existingProperty = this.originalProperties.get(name);
            if (existingProperty.isTransient() && property.isTransient()) {
                if (this.getXmlAccessType().equals((Object)XmlAccessType.FIELD)) {
                    if (property.isMethodProperty()) return;
                    this.propertyList.remove(existingProperty);
                    this.propertyNames.remove(name);
                } else {
                    if (!property.isMethodProperty()) return;
                    this.propertyList.remove(existingProperty);
                    this.propertyNames.remove(name);
                }
            } else if (existingProperty.isTransient() || existingProperty.isSuperClassProperty()) {
                this.propertyList.remove(existingProperty);
                this.propertyNames.remove(name);
            } else {
                if (!property.isTransient()) throw JAXBException.duplicatePropertyName((String)name, (String)this.getJavaClassName());
                return;
            }
        }
        this.originalProperties.put(name, property);
        this.properties.put(name, property);
        this.propertyNames.add(name);
        this.propertyList.add(property);
    }

    public void setIDProperty(Property idProperty) {
        this.idProperty = idProperty;
    }

    public void setProperties(ArrayList<Property> properties) {
        if (properties != null) {
            for (int i = 0; i < properties.size(); ++i) {
                Property next = properties.get(i);
                this.addProperty(next.getPropertyName(), next);
            }
            if (!this.isTransient()) {
                List<String> propOrderList = Arrays.asList(this.getPropOrder());
                ArrayList<Property> propsList = this.getPropertyList();
                for (int i = 0; i < propsList.size(); ++i) {
                    Property p = propsList.get(i);
                    if (!p.isTransient() || !propOrderList.contains(p.getPropertyName())) continue;
                    throw JAXBException.transientInProporder((String)p.getPropertyName());
                }
            }
        }
    }

    public void orderProperties() {
        if (!this.isSetXmlAccessOrder()) {
            return;
        }
        if (this.xmlAccessOrder == XmlAccessOrder.ALPHABETICAL && this.propertyNames != null) {
            Collections.sort(this.propertyNames);
        }
    }

    public boolean isEnumerationType() {
        return false;
    }

    public boolean isIDSet() {
        return this.idProperty != null;
    }

    public ArrayList<Property> getPropertyList() {
        return this.propertyList;
    }

    public String getSchemaTypeName() {
        return this.schemaTypeName;
    }

    public void setSchemaTypeName(String typeName) {
        this.schemaTypeName = typeName;
    }

    public void setSchema(Schema theSchema) {
        this.schema = theSchema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public JavaClass getPackageLevelAdapterClass(JavaClass boundType) {
        if (this.hasPackageLevelAdaptersByClass()) {
            return this.getPackageLevelAdaptersByClass().get(boundType.getQualifiedName());
        }
        return null;
    }

    public boolean isAnonymousComplexType() {
        return this.schemaTypeName == null || this.schemaTypeName.equals("");
    }

    public JavaClass getPackageLevelAdapterClass(String boundTypeName) {
        if (this.hasPackageLevelAdaptersByClass()) {
            return this.getPackageLevelAdaptersByClass().get(boundTypeName);
        }
        return null;
    }

    public HashMap<String, JavaClass> getPackageLevelAdaptersByClass() {
        if (!this.hasPackageLevelAdaptersByClass()) {
            this.packageLevelAdaptersByClass = new HashMap();
        }
        return this.packageLevelAdaptersByClass;
    }

    boolean hasPackageLevelAdaptersByClass() {
        return null != this.packageLevelAdaptersByClass;
    }

    public void addPackageLevelAdapterClass(JavaClass adapterClass, JavaClass boundType) {
        this.getPackageLevelAdaptersByClass().put(boundType.getQualifiedName(), adapterClass);
    }

    public boolean hasRootElement() {
        return this.hasRootElement;
    }

    public void setHasRootElement(boolean hasRoot) {
        this.hasRootElement = hasRoot;
    }

    public boolean hasElementRefs() {
        return this.elementRefsPropertyName != null;
    }

    public String getElementRefsPropName() {
        return this.elementRefsPropertyName;
    }

    public void setElementRefsPropertyName(String propName) {
        this.elementRefsPropertyName = propName;
    }

    public String getObjectFactoryClassName() {
        return this.objectFactoryClassName;
    }

    public void setObjectFactoryClassName(String factoryClass) {
        this.objectFactoryClassName = factoryClass;
    }

    public String getFactoryMethodName() {
        return this.factoryMethodName;
    }

    public void setFactoryMethodName(String factoryMethod) {
        this.factoryMethodName = factoryMethod;
    }

    public String[] getFactoryMethodParamTypes() {
        return this.factoryMethodParamTypes;
    }

    public void setFactoryMethodParamTypes(String[] paramTypes) {
        this.factoryMethodParamTypes = paramTypes;
    }

    public boolean isSetXmlValueProperty() {
        return this.xmlValueProperty != null;
    }

    public Property getXmlValueProperty() {
        return this.xmlValueProperty;
    }

    public void setXmlValueProperty(Property xmlValueProperty) {
        this.xmlValueProperty = xmlValueProperty;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public List<Property> getNonTransientPropertiesInPropOrder() {
        ArrayList<Property> propertiesInOrder = new ArrayList<Property>();
        String[] propOrder = this.getPropOrder();
        if (propOrder.length == 0 || propOrder[0].equals(EMPTY_STRING)) {
            ArrayList<String> propertyNames = this.getPropertyNames();
            for (int i = 0; i < propertyNames.size(); ++i) {
                this.addPropertyToList(propertiesInOrder, propertyNames.get(i), null);
            }
        } else {
            int i;
            ArrayList<String> propertyNamesCopy = new ArrayList<String>(this.getPropertyNames());
            for (i = 0; i < propOrder.length; ++i) {
                this.addPropertyToList(propertiesInOrder, propOrder[i], propertyNamesCopy);
            }
            for (i = 0; i < propertyNamesCopy.size(); ++i) {
                this.addPropertyToList(propertiesInOrder, propertyNamesCopy.get(i), null);
            }
        }
        return propertiesInOrder;
    }

    private void addPropertyToList(List<Property> propertiesInOrder, String propertyName, ArrayList<String> propertyNamesCopy) {
        Property next = this.getProperties().get(propertyName);
        if (next != null && !next.isTransient()) {
            List<Property> addProps;
            if (propertyNamesCopy != null) {
                propertyNamesCopy.remove(propertyName);
            }
            propertiesInOrder.add(next);
            if (this.hasAdditionalProperties() && (addProps = this.getAdditionalProperties().get(propertyName)) != null) {
                for (Property addProp : addProps) {
                    if (addProp.isTransient()) continue;
                    propertiesInOrder.add(addProp);
                }
            }
        }
    }

    public boolean isSetXmlTransient() {
        return this.isSetXmlTransient;
    }

    public void setXmlTransient(boolean isTransient) {
        this.isSetXmlTransient = true;
        this.setTransient(isTransient);
    }

    public boolean isSetXmlSeeAlso() {
        return this.xmlSeeAlso != null;
    }

    public List<String> getXmlSeeAlso() {
        return this.xmlSeeAlso;
    }

    public void setXmlSeeAlso(List<String> xmlSeeAlso) {
        this.xmlSeeAlso = xmlSeeAlso;
    }

    public boolean isSetXmlRootElement() {
        return this.xmlRootElement != null;
    }

    public XmlRootElement getXmlRootElement() {
        return this.xmlRootElement;
    }

    public void setXmlRootElement(XmlRootElement xmlRootElement) {
        this.xmlRootElement = xmlRootElement;
    }

    public boolean isSetXmlType() {
        return this.xmlType != null;
    }

    public XmlType getXmlType() {
        return this.xmlType;
    }

    public void setXmlType(XmlType xmlType) {
        this.xmlType = xmlType;
    }

    public boolean isSetXmlAccessType() {
        return this.xmlAccessType != null;
    }

    public XmlAccessType getXmlAccessType() {
        return this.xmlAccessType;
    }

    public void setXmlAccessType(XmlAccessType xmlAccessType) {
        this.xmlAccessType = xmlAccessType;
    }

    public boolean isSetXmlAccessOrder() {
        return this.xmlAccessOrder != null;
    }

    public XmlAccessOrder getXmlAccessOrder() {
        return this.xmlAccessOrder;
    }

    public void setXmlAccessOrder(XmlAccessOrder xmlAccessOrder) {
        this.xmlAccessOrder = xmlAccessOrder;
    }

    public boolean isPreBuilt() {
        return this.isPreBuilt;
    }

    public void setPreBuilt(boolean isPreBuilt) {
        this.isPreBuilt = isPreBuilt;
    }

    public boolean isPostBuilt() {
        return this.isPostBuilt;
    }

    public void setPostBuilt(boolean isPostBuilt) {
        this.isPostBuilt = isPostBuilt;
    }

    public boolean isSetXmlJavaTypeAdapter() {
        return this.getXmlJavaTypeAdapter() != null;
    }

    public XmlJavaTypeAdapter getXmlJavaTypeAdapter() {
        return this.xmlJavaTypeAdapter;
    }

    public void setXmlJavaTypeAdapter(XmlJavaTypeAdapter xmlJavaTypeAdapter) {
        this.xmlJavaTypeAdapter = xmlJavaTypeAdapter;
    }

    public String getXmlCustomizer() {
        return this.xmlCustomizer;
    }

    public void setXmlCustomizer(String xmlCustomizerClassName) {
        this.xmlCustomizer = xmlCustomizerClassName;
    }

    public boolean isSetAnyElementPropertyName() {
        return this.getAnyElementPropertyName() != null;
    }

    public String getAnyElementPropertyName() {
        return this.anyElementPropertyName;
    }

    public void setAnyElementPropertyName(String anyElementPropertyName) {
        this.anyElementPropertyName = anyElementPropertyName;
    }

    public boolean isSetAnyAttributePropertyName() {
        return this.getAnyAttributePropertyName() != null;
    }

    public String getAnyAttributePropertyName() {
        return this.anyAttributePropertyName;
    }

    public void setAnyAttributePropertyName(String anyAttributePropertyName) {
        this.anyAttributePropertyName = anyAttributePropertyName;
    }

    public boolean isBinaryDataToBeInlined() {
        return this.isBinaryDataInlined;
    }

    public void setInlineBinaryData(boolean isBinaryDataInlined) {
        this.isBinaryDataInlined = isBinaryDataInlined;
    }

    public boolean isSetClassExtractorName() {
        return this.classExtractorName != null;
    }

    public String getClassExtractorName() {
        return this.classExtractorName;
    }

    public void setClassExtractorName(String classExtractorName) {
        this.classExtractorName = classExtractorName;
    }

    public Map<Object, Object> getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(Map<Object, Object> userProperties) {
        this.userProperties = userProperties;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    public String getXmlDiscriminatorNode() {
        return this.xmlDiscriminatorNode;
    }

    public void setXmlDiscriminatorNode(String xmlDiscriminatorNode) {
        this.xmlDiscriminatorNode = xmlDiscriminatorNode;
    }

    public boolean isSetXmlDiscriminatorNode() {
        return this.xmlDiscriminatorNode != null;
    }

    public String getXmlDiscriminatorValue() {
        return this.xmlDiscriminatorValue;
    }

    public void setXmlDiscriminatorValue(String xmlDiscriminatorValue) {
        this.xmlDiscriminatorValue = xmlDiscriminatorValue;
    }

    public boolean isSetXmlDiscriminatorValue() {
        return this.xmlDiscriminatorValue != null;
    }

    public void addXmlKeyProperty(Property xmlKeyProp) {
        if (this.xmlKeyProperties == null) {
            this.xmlKeyProperties = new ArrayList<Property>();
        }
        this.xmlKeyProperties.add(xmlKeyProp);
    }

    public List<Property> getXmlKeyProperties() {
        return this.xmlKeyProperties;
    }

    public boolean hasXmlKeyProperties() {
        return this.xmlKeyProperties != null;
    }

    public Map<String, List<Property>> getAdditionalProperties() {
        if (!this.hasAdditionalProperties()) {
            this.additionalProperties = new HashMap<String, List<Property>>();
        }
        return this.additionalProperties;
    }

    boolean hasAdditionalProperties() {
        return null != this.additionalProperties;
    }

    public HashMap<String, Property> getOriginalProperties() {
        return this.originalProperties;
    }

    public XmlVirtualAccessMethods getXmlVirtualAccessMethods() {
        return this.xmlExtensible;
    }

    public void setXmlVirtualAccessMethods(XmlVirtualAccessMethods xmlExtensible) {
        this.xmlExtensible = xmlExtensible;
    }

    public XMLNameTransformer getXmlNameTransformer() {
        return this.xmlNameTransformer;
    }

    public void setXmlNameTransformer(XMLNameTransformer xmlNameTransformer) {
        this.xmlNameTransformer = xmlNameTransformer;
    }

    public List<Property> getPredicateProperties() {
        if (this.predicateProperties == null) {
            this.predicateProperties = new ArrayList<Property>();
        }
        return this.predicateProperties;
    }

    public boolean hasPredicateProperty(Property property) {
        if (this.predicateProperties != null) {
            for (Property next : this.predicateProperties) {
                if (!next.getXmlPath().equals(property.getXmlPath())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPredicateProperties() {
        return this.predicateProperties != null && this.predicateProperties.size() > 0;
    }

    void postInitialize() {
        this.originalProperties = null;
    }

    public JavaClass getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(JavaClass javaClass) {
        this.javaClass = javaClass;
    }
}

