/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.service;

import jakarta.annotation.PreDestroy;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.persistence.jpa.rs.DataStorage;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactory;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactoryProvider;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSExceptionMapper;
import org.eclipse.persistence.jpa.rs.resources.EntityResource;
import org.eclipse.persistence.jpa.rs.resources.MetadataResource;
import org.eclipse.persistence.jpa.rs.resources.PersistenceResource;
import org.eclipse.persistence.jpa.rs.resources.PersistenceUnitResource;
import org.eclipse.persistence.jpa.rs.resources.QueryResource;
import org.eclipse.persistence.jpa.rs.resources.SingleResultQueryResource;

@ApplicationPath(value="/persistence/")
public class JPARSApplication
extends Application {
    private final Set<Class<?>> classes = Set.of(PersistenceResource.class, PersistenceUnitResource.class, EntityResource.class, SingleResultQueryResource.class, QueryResource.class, MetadataResource.class, JPARSExceptionMapper.class);

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    @PreDestroy
    public void preDestroy() {
        DataStorage.destroy();
        ServiceLoader<PersistenceContextFactoryProvider> persistenceContextFactoryProviderLoader = ServiceLoader.load(PersistenceContextFactoryProvider.class, Thread.currentThread().getContextClassLoader());
        for (PersistenceContextFactoryProvider persistenceContextFactoryProvider : persistenceContextFactoryProviderLoader) {
            PersistenceContextFactory persistenceContextFactory = persistenceContextFactoryProvider.getPersistenceContextFactory(null);
            if (persistenceContextFactory == null) continue;
            persistenceContextFactory.close();
        }
    }
}

