/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.ClassWriter;
import org.eclipse.persistence.asm.MethodVisitor;
import org.eclipse.persistence.asm.Opcodes;
import org.eclipse.persistence.asm.Type;
import org.eclipse.persistence.dynamic.DynamicClassWriter;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;

public class MetadataDynamicClassWriter
extends DynamicClassWriter {
    private static final String LDYNAMIC_ENTITY = "Lorg/eclipse/persistence/dynamic/DynamicEntity;";
    private static final String SET = "set";
    private static final String LJAVA_LANG_OBJECT = "Ljava/lang/Object;";
    private static final String LJAVA_LANG_STRING = "Ljava/lang/String;";
    private static final String DYNAMIC_EXCEPTION = "org/eclipse/persistence/exceptions/DynamicException";
    private static final String GET = "get";
    private MetadataDescriptor descriptor;

    public MetadataDynamicClassWriter(MetadataDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public MetadataDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void addMethods(ClassWriter cw, String parentClassType) {
        for (MappingAccessor accessor : this.getDescriptor().getMappingAccessors()) {
            String propertyName = this.propertyName(accessor.getAttributeName());
            Type returnType = this.getAsmType(accessor);
            MethodVisitor mv = cw.visitMethod(Opcodes.valueInt((String)"ACC_PUBLIC"), GET + propertyName, "()" + returnType.getDescriptor(), null, new String[]{DYNAMIC_EXCEPTION});
            mv.visitCode();
            mv.visitVarInsn(Opcodes.valueInt((String)"ALOAD"), 0);
            mv.visitLdcInsn((Object)accessor.getAttributeName());
            mv.visitMethodInsn(Opcodes.valueInt((String)"INVOKESPECIAL"), parentClassType, GET, "(Ljava/lang/String;)Ljava/lang/Object;", false);
            mv.visitTypeInsn(Opcodes.valueInt((String)"CHECKCAST"), returnType.getInternalName());
            mv.visitInsn(Opcodes.valueInt((String)"ARETURN"));
            mv.visitMaxs(2, 1);
            mv.visitEnd();
            mv = cw.visitMethod(Opcodes.valueInt((String)"ACC_PUBLIC"), SET + propertyName, "(" + returnType.getDescriptor() + ")V", null, new String[]{DYNAMIC_EXCEPTION});
            mv.visitCode();
            mv.visitVarInsn(Opcodes.valueInt((String)"ALOAD"), 0);
            mv.visitLdcInsn((Object)"id");
            mv.visitVarInsn(Opcodes.valueInt((String)"ALOAD"), 1);
            mv.visitMethodInsn(Opcodes.valueInt((String)"INVOKESPECIAL"), parentClassType, SET, "(Ljava/lang/String;Ljava/lang/Object;)Lorg/eclipse/persistence/dynamic/DynamicEntity;", false);
            mv.visitInsn(Opcodes.valueInt((String)"POP"));
            mv.visitInsn(Opcodes.valueInt((String)"RETURN"));
            mv.visitMaxs(3, 2);
            mv.visitEnd();
        }
    }

    private Type getAsmType(MappingAccessor accessor) {
        String attributeType = accessor.getFullyQualifiedClassName(accessor.getAttributeType());
        Class<?> primClass = accessor.getPrimitiveClassForName(attributeType);
        if (primClass != null) {
            Type asmType = ASMFactory.createType(primClass);
            int asmTypeSort = asmType.getSort();
            if (asmTypeSort == Type.BOOLEAN) {
                return Type.getType((Class)ClassConstants.BOOLEAN);
            }
            if (asmTypeSort == Type.BYTE) {
                return Type.getType((Class)ClassConstants.BYTE);
            }
            if (asmTypeSort == Type.CHAR) {
                return Type.getType((Class)ClassConstants.CHAR);
            }
            if (asmTypeSort == Type.DOUBLE) {
                return Type.getType((Class)ClassConstants.DOUBLE);
            }
            if (asmTypeSort == Type.FLOAT) {
                return Type.getType((Class)ClassConstants.FLOAT);
            }
            if (asmTypeSort == Type.INT) {
                return Type.getType((Class)ClassConstants.INTEGER);
            }
            if (asmTypeSort == Type.LONG) {
                return Type.getType((Class)ClassConstants.LONG);
            }
            if (asmTypeSort == Type.SHORT) {
                return Type.getType((Class)ClassConstants.SHORT);
            }
        }
        return Type.getType((String)("L" + attributeType.replace(".", "/") + ";"));
    }

    private String propertyName(String attributeName) {
        char[] string = attributeName.toCharArray();
        string[0] = Character.toUpperCase(string[0]);
        return new String(string);
    }
}

