/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import org.eclipse.persistence.dynamic.DynamicClassWriter;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;

public class MetadataDynamicClassWriter
extends DynamicClassWriter {
    private static final String LDYNAMIC_ENTITY = "Lorg/eclipse/persistence/dynamic/DynamicEntity;";
    private static final String SET = "set";
    private static final String LJAVA_LANG_OBJECT = "Ljava/lang/Object;";
    private static final String LJAVA_LANG_STRING = "Ljava/lang/String;";
    private static final String DYNAMIC_EXCEPTION = "org/eclipse/persistence/exceptions/DynamicException";
    private static final String GET = "get";
    private MetadataDescriptor descriptor;

    public MetadataDynamicClassWriter(MetadataDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public MetadataDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void addMethods(ClassWriter cw, String parentClassType) {
        for (MappingAccessor accessor : this.getDescriptor().getMappingAccessors()) {
            String propertyName = this.propertyName(accessor.getAttributeName());
            Type returnType = this.getAsmType(accessor);
            MethodVisitor mv = cw.visitMethod(1, GET + propertyName, "()" + returnType.getDescriptor(), null, new String[]{DYNAMIC_EXCEPTION});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)accessor.getAttributeName());
            mv.visitMethodInsn(183, parentClassType, GET, "(Ljava/lang/String;)Ljava/lang/Object;", false);
            mv.visitTypeInsn(192, returnType.getInternalName());
            mv.visitInsn(176);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
            mv = cw.visitMethod(1, SET + propertyName, "(" + returnType.getDescriptor() + ")V", null, new String[]{DYNAMIC_EXCEPTION});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)"id");
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, parentClassType, SET, "(Ljava/lang/String;Ljava/lang/Object;)Lorg/eclipse/persistence/dynamic/DynamicEntity;", false);
            mv.visitInsn(87);
            mv.visitInsn(177);
            mv.visitMaxs(3, 2);
            mv.visitEnd();
        }
    }

    private Type getAsmType(MappingAccessor accessor) {
        String attributeType = accessor.getFullyQualifiedClassName(accessor.getAttributeType());
        Class<?> primClass = accessor.getPrimitiveClassForName(attributeType);
        if (primClass != null) {
            Type asmType = Type.getType(primClass);
            switch (asmType.getSort()) {
                case 1: {
                    return Type.getType((Class)ClassConstants.BOOLEAN);
                }
                case 3: {
                    return Type.getType((Class)ClassConstants.BYTE);
                }
                case 2: {
                    return Type.getType((Class)ClassConstants.CHAR);
                }
                case 8: {
                    return Type.getType((Class)ClassConstants.DOUBLE);
                }
                case 6: {
                    return Type.getType((Class)ClassConstants.FLOAT);
                }
                case 5: {
                    return Type.getType((Class)ClassConstants.INTEGER);
                }
                case 7: {
                    return Type.getType((Class)ClassConstants.LONG);
                }
                case 4: {
                    return Type.getType((Class)ClassConstants.SHORT);
                }
            }
        }
        return Type.getType((String)("L" + attributeType.replace(".", "/") + ";"));
    }

    private String propertyName(String attributeName) {
        char[] string = attributeName.toCharArray();
        string[0] = Character.toUpperCase(string[0]);
        return new String(string);
    }
}

