/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.weaving.jpa;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.persistence.exceptions.StaticWeaveException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveProcessor;

public class StaticWeave {
    private String[] argv;
    private String source;
    private String persistenceinfopath;
    private String persistenceXmlLocation;
    private String target;
    private int loglevel = 8;
    private Writer logWriter;
    private PrintStream vout = System.out;
    private String[] classpaths;

    public static void main(String[] argv) {
        StaticWeave staticweaver = new StaticWeave(argv);
        try {
            staticweaver.processCommandLine();
            staticweaver.start();
        }
        catch (Exception e) {
            throw StaticWeaveException.exceptionPerformWeaving((Exception)e, (Object)argv);
        }
    }

    public StaticWeave(String[] argv) {
        this.argv = argv;
    }

    public void start() throws Exception {
        StaticWeaveProcessor staticWeaverProcessor = new StaticWeaveProcessor(this.source, this.target);
        if (this.persistenceinfopath != null) {
            staticWeaverProcessor.setPersistenceInfo(this.persistenceinfopath);
        }
        if (this.persistenceXmlLocation != null) {
            staticWeaverProcessor.setPersistenceXMLLocation(this.persistenceXmlLocation);
        }
        if (this.classpaths != null) {
            staticWeaverProcessor.setClassLoader(this.getClassLoader());
        }
        if (this.logWriter != null) {
            staticWeaverProcessor.setLog(this.logWriter);
        }
        staticWeaverProcessor.setLogLevel(this.loglevel);
        staticWeaverProcessor.performWeaving();
    }

    void processCommandLine() throws Exception {
        if (this.argv.length < 2 || this.argv.length > 12) {
            this.printUsage();
            System.exit(1);
        }
        for (int i = 0; i < this.argv.length; ++i) {
            if (this.argv[i].equalsIgnoreCase("-classpath")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                this.classpaths = this.argv[i + 1].split(File.pathSeparator);
                ++i;
                continue;
            }
            if (this.argv[i].equalsIgnoreCase("-persistenceinfo")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                this.persistenceinfopath = this.argv[i + 1];
                ++i;
                continue;
            }
            if (this.argv[i].equalsIgnoreCase("-persistencexml")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                this.persistenceXmlLocation = this.argv[i + 1];
                ++i;
                continue;
            }
            if (this.argv[i].equalsIgnoreCase("-log")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                this.logWriter = new FileWriter(this.argv[i + 1]);
                ++i;
                continue;
            }
            if (this.argv[i].equalsIgnoreCase("-loglevel")) {
                if (i + 1 >= this.argv.length) {
                    this.printUsage();
                    System.exit(1);
                }
                if (this.argv[i + 1].equalsIgnoreCase("OFF") || this.argv[i + 1].equalsIgnoreCase("SEVERE") || this.argv[i + 1].equalsIgnoreCase("WARNING") || this.argv[i + 1].equalsIgnoreCase("INFO") || this.argv[i + 1].equalsIgnoreCase("CONFIG") || this.argv[i + 1].equalsIgnoreCase("FINE") || this.argv[i + 1].equalsIgnoreCase("FINER") || this.argv[i + 1].equalsIgnoreCase("FINEST") || this.argv[i + 1].equalsIgnoreCase("ALL")) {
                    this.loglevel = AbstractSessionLog.translateStringToLoggingLevel((String)this.argv[i + 1].toUpperCase());
                } else {
                    this.printUsage();
                    System.exit(1);
                }
                ++i;
                continue;
            }
            if (this.source != null) {
                this.printUsage();
                System.exit(1);
            }
            if (this.target != null) {
                this.printUsage();
                System.exit(1);
            }
            this.source = this.argv[i];
            if (i + 1 >= this.argv.length) {
                this.printUsage();
                System.exit(1);
            }
            if (++i >= this.argv.length) {
                this.printUsage();
                System.exit(1);
            }
            this.target = this.argv[i];
            ++i;
        }
        if (this.source == null) {
            this.printUsage();
            throw StaticWeaveException.missingSource();
        }
        if (this.target == null) {
            this.printUsage();
            throw StaticWeaveException.missingTarget();
        }
    }

    private void printUsage() {
        PrintStream o = this.vout;
        String messageString = ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_1of19");
        messageString = messageString + Helper.cr() + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_2of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_3of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_4of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_5of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_6of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_7of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_8of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_9of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_10of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_11of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_12of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_13of19");
        messageString = messageString + Helper.cr() + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_14of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_15of19");
        messageString = messageString + Helper.cr() + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_16of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_17of19");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_18of19");
        messageString = messageString + Helper.cr() + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage((String)"staticweave_commandline_help_message_19of19");
        messageString = messageString + Helper.cr() + Helper.cr();
        o.println(messageString);
    }

    private ClassLoader getClassLoader() throws MalformedURLException {
        if (this.classpaths != null) {
            URL[] urls = new URL[this.classpaths.length];
            for (int i = 0; i < this.classpaths.length; ++i) {
                urls[i] = new File(this.classpaths[i]).toURL();
            }
            return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        return null;
    }
}

