/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CompoundSelection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.ArgumentListFunctionExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicCollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicMapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicSetJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.ConstructorSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaDeleteImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaUpdateImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.JoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.ListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.MapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.OrderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.PathImpl;
import org.eclipse.persistence.internal.jpa.querydef.PredicateImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SetJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.jpa.JpaCriteriaBuilder;
import org.eclipse.persistence.queries.ReportQuery;

public class CriteriaBuilderImpl
implements JpaCriteriaBuilder,
Serializable {
    public static final String CONCAT = "concat";
    public static final String SIZE = "size";
    protected Metamodel metamodel;

    public CriteriaBuilderImpl(Metamodel metamodel) {
        this.metamodel = metamodel;
    }

    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this.metamodel, AbstractQueryImpl.ResultType.UNKNOWN, ClassConstants.OBJECT, this);
    }

    public <T> CriteriaQuery<T> createQuery(Class<T> resultClass) {
        if (resultClass == null) {
            return this.createQuery();
        }
        if (resultClass.equals(Tuple.class)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.AOBJECT)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.isArray()) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.OBJECT)) {
            return this.createQuery();
        }
        if (resultClass.isPrimitive() || resultClass.equals(ClassConstants.STRING) || BasicTypeHelperImpl.getInstance().isWrapperClass(resultClass) || BasicTypeHelperImpl.getInstance().isDateClass(resultClass)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OTHER, resultClass, this);
        }
        TypeImpl<T> type = ((MetamodelImpl)this.metamodel).getType(resultClass);
        if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.ENTITY, resultClass, this);
        }
        return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.CONSTRUCTOR, resultClass, this);
    }

    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, Tuple.class, this);
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> result, Selection<?> ... selections) {
        return new ConstructorSelectionImpl(result, selections);
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return new CompoundSelectionImpl(Tuple.class, selections, true);
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return new CompoundSelectionImpl(ClassConstants.AOBJECT, selections, true);
    }

    public Order asc(jakarta.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new OrderImpl(x);
    }

    public Order desc(jakarta.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        OrderImpl order = new OrderImpl(x, false);
        return order;
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<Double> avg(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ((InternalSelection)x).getCurrentNode().average(), this.buildList(x), "AVG");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> max(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().maximum(), this.buildList(x), "MAX");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> min(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().minimum(), this.buildList(x), "MIN");
    }

    public <X extends Comparable<? super X>> jakarta.persistence.criteria.Expression<X> greatest(jakarta.persistence.criteria.Expression<X> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().maximum());
    }

    public <X extends Comparable<? super X>> jakarta.persistence.criteria.Expression<X> least(jakarta.persistence.criteria.Expression<X> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().minimum());
    }

    public jakarta.persistence.criteria.Expression<Long> count(jakarta.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)x).getCurrentNode().count(), this.buildList(x), "COUNT");
    }

    public jakarta.persistence.criteria.Expression<Long> countDistinct(jakarta.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)x).getCurrentNode().distinct().count(), this.buildList(x), "COUNT");
    }

    public Predicate exists(Subquery<?> subquery) {
        return new CompoundExpressionImpl(this.metamodel, ExpressionOperator.getOperator((Integer)86).expressionFor(((SubQueryImpl)subquery).getCurrentNode()), this.buildList(new jakarta.persistence.criteria.Expression[]{subquery}), "exists");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> all(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().all(((InternalSelection)subquery).getCurrentNode()), this.buildList(new jakarta.persistence.criteria.Expression[]{subquery}), "all");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> some(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().some(((InternalSelection)subquery).getCurrentNode()), this.buildList(new jakarta.persistence.criteria.Expression[]{subquery}), "some");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> any(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().any(((InternalSelection)subquery).getCurrentNode()), this.buildList(new jakarta.persistence.criteria.Expression[]{subquery}), "any");
    }

    public Predicate and(jakarta.persistence.criteria.Expression<Boolean> x, jakarta.persistence.criteria.Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)x).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)y).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isJunction()) {
            if (((PredicateImpl)yp).getJunctionValue().booleanValue()) {
                return xp;
            }
            return yp;
        }
        if (xp.isJunction()) {
            if (((PredicateImpl)xp).getJunctionValue().booleanValue()) {
                return yp;
            }
            return xp;
        }
        Expression currentNode = xp.getCurrentNode().and(yp.getCurrentNode());
        xp.setParentNode(currentNode);
        yp.setParentNode(currentNode);
        return new PredicateImpl(this.metamodel, currentNode, this.buildList(xp, yp), Predicate.BooleanOperator.AND);
    }

    public Predicate or(jakarta.persistence.criteria.Expression<Boolean> x, jakarta.persistence.criteria.Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)x).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)y).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isJunction()) {
            if (((PredicateImpl)yp).getJunctionValue().booleanValue()) {
                return yp;
            }
            return xp;
        }
        if (xp.isJunction()) {
            if (((PredicateImpl)xp).getJunctionValue().booleanValue()) {
                return xp;
            }
            return yp;
        }
        Expression parentNode = xp.getCurrentNode().or(yp.getCurrentNode());
        xp.setParentNode(parentNode);
        yp.setParentNode(parentNode);
        return new PredicateImpl(this.metamodel, parentNode, this.buildList(xp, yp), Predicate.BooleanOperator.OR);
    }

    public Predicate and(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.conjunction();
        }
        Predicate a = restrictions[0];
        for (int i = 1; i < max; ++i) {
            a = this.and((jakarta.persistence.criteria.Expression<Boolean>)a, (jakarta.persistence.criteria.Expression<Boolean>)restrictions[i]);
        }
        return a;
    }

    public Predicate or(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.disjunction();
        }
        Predicate a = restrictions[0];
        for (int i = 1; i < max; ++i) {
            a = this.or((jakarta.persistence.criteria.Expression<Boolean>)a, (jakarta.persistence.criteria.Expression<Boolean>)restrictions[i]);
        }
        return a;
    }

    public Predicate not(jakarta.persistence.criteria.Expression<Boolean> restriction) {
        if (((InternalExpression)restriction).isPredicate()) {
            return ((Predicate)restriction).not();
        }
        Expression parentNode = null;
        List<jakarta.persistence.criteria.Expression<?>> compoundExpressions = null;
        String name = "not";
        if (((InternalExpression)restriction).isCompoundExpression() && ((CompoundExpressionImpl)restriction).getOperation().equals("exists")) {
            FunctionExpression exp = (FunctionExpression)((InternalSelection)restriction).getCurrentNode();
            SubSelectExpression sub = (SubSelectExpression)exp.getChildren().get(0);
            parentNode = ExpressionOperator.getOperator((Integer)88).expressionFor((Expression)sub);
            name = "notExists";
            compoundExpressions = ((CompoundExpressionImpl)restriction).getChildExpressions();
        } else {
            parentNode = ((InternalSelection)restriction).getCurrentNode().not();
            compoundExpressions = this.buildList(restriction);
        }
        CompoundExpressionImpl expr = new CompoundExpressionImpl(this.metamodel, parentNode, compoundExpressions, name);
        expr.setIsNegated(true);
        return expr;
    }

    public Predicate conjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.AND);
    }

    public Predicate disjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.OR);
    }

    public Predicate isTrue(jakarta.persistence.criteria.Expression<Boolean> x) {
        if (((InternalExpression)x).isPredicate()) {
            if (((InternalSelection)x).getCurrentNode() == null) {
                return (Predicate)x;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"PREDICATE_PASSED_TO_EVALUATION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().equal(true), list, "equals");
    }

    public Predicate isFalse(jakarta.persistence.criteria.Expression<Boolean> x) {
        if (((InternalExpression)x).isPredicate()) {
            if (((InternalSelection)x).getCurrentNode() == null) {
                if (((Predicate)x).getOperator() == Predicate.BooleanOperator.AND) {
                    return (Predicate)x;
                }
                return this.conjunction();
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"PREDICATE_PASSED_TO_EVALUATION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().equal(false), this.buildList(x), "equals");
    }

    public Predicate isNull(jakarta.persistence.criteria.Expression<?> x) {
        return new PredicateImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().isNull(), new ArrayList(), Predicate.BooleanOperator.AND);
    }

    public Predicate isNotNull(jakarta.persistence.criteria.Expression<?> x) {
        return new PredicateImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().notNull(), new ArrayList(), Predicate.BooleanOperator.AND);
    }

    public Predicate equal(jakarta.persistence.criteria.Expression<?> x, jakarta.persistence.criteria.Expression<?> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().equal(((InternalSelection)y).getCurrentNode()), list, "equals");
    }

    public Predicate notEqual(jakarta.persistence.criteria.Expression<?> x, jakarta.persistence.criteria.Expression<?> y) {
        if (((InternalSelection)x).getCurrentNode() == null || ((InternalSelection)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().notEqual(((InternalSelection)y).getCurrentNode()), list, "not equal");
    }

    public Predicate equal(jakarta.persistence.criteria.Expression<?> x, Object y) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y instanceof ParameterExpression) {
            return this.equal(x, (jakarta.persistence.criteria.Expression<?>)((ParameterExpression)y));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.internalLiteral(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().equal(y), list, "equal");
    }

    public Predicate notEqual(jakarta.persistence.criteria.Expression<?> x, Object y) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y instanceof ParameterExpression) {
            return this.notEqual(x, (jakarta.persistence.criteria.Expression<?>)((ParameterExpression)y));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.internalLiteral(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().notEqual(y), list, "not equal");
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (((InternalSelection)x).getCurrentNode() == null || ((InternalSelection)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().greaterThan(((InternalSelection)y).getCurrentNode()), list, "greaterThan");
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (((InternalSelection)x).getCurrentNode() == null || ((InternalSelection)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().lessThan(((InternalSelection)y).getCurrentNode()), this.buildList(x, y), "lessThan");
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThanEqual(((ExpressionImpl)y).getCurrentNode()), list, "greaterThanEqual");
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)y).getCurrentNode()), list, "lessThanEqual");
    }

    public <Y extends Comparable<? super Y>> Predicate between(jakarta.persistence.criteria.Expression<? extends Y> v, jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        ArrayList list = new ArrayList();
        list.add(v);
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)v).getCurrentNode().between(((ExpressionImpl)x).getCurrentNode(), ((ExpressionImpl)y).getCurrentNode()), list, "between");
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(expressionY);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThan(((ExpressionImpl)expressionY).getCurrentNode()), list, "greaterThan");
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(expressionY);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThan(((ExpressionImpl)expressionY).getCurrentNode()), list, "lessThan");
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(expressionY);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), list, "greaterThanEqual");
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        jakarta.persistence.criteria.Expression<Y> expressionY = this.internalLiteral(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(expressionY);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), list, "lessThanEqual");
    }

    public <Y extends Comparable<? super Y>> Predicate between(jakarta.persistence.criteria.Expression<? extends Y> v, Y x, Y y) {
        ArrayList list = new ArrayList();
        list.add(v);
        list.add(this.internalLiteral(x));
        list.add(this.internalLiteral(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)v).getCurrentNode().between(x, y), list, "between");
    }

    protected List<jakarta.persistence.criteria.Expression<?>> buildList(jakarta.persistence.criteria.Expression<?> ... expressions) {
        ArrayList list = new ArrayList();
        for (jakarta.persistence.criteria.Expression<?> exp : expressions) {
            list.add(exp);
        }
        return list;
    }

    public Predicate gt(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().greaterThan(((InternalSelection)y).getCurrentNode()), list, "gt");
    }

    public Predicate lt(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().lessThan(((InternalSelection)y).getCurrentNode()), this.buildList(x, y), "lessThan");
    }

    public Predicate ge(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().greaterThanEqual(((InternalSelection)y).getCurrentNode()), list, "ge");
    }

    public Predicate le(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().lessThanEqual(((InternalSelection)y).getCurrentNode()), list, "le");
    }

    public Predicate gt(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.internalLiteral(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().greaterThan((Object)y), list, "gt");
    }

    public Predicate lt(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().lessThan((Object)y), this.buildList(x, this.internalLiteral(y)), "lt");
    }

    public Predicate ge(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.internalLiteral(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().greaterThanEqual((Object)y), list, "ge");
    }

    public Predicate le(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().lessThanEqual((Object)y), this.buildList(x, this.internalLiteral(y)), "le");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> neg(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, ClassConstants.INTEGER, ExpressionMath.negate((Expression)((InternalSelection)x).getCurrentNode()), this.buildList(x), "neg");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> abs(jakarta.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.abs((Expression)((InternalSelection)x).getCurrentNode()), this.buildList(x), "ABS");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(jakarta.persistence.criteria.Expression<? extends N> x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion((Object)x.getJavaType(), (Object)y.getJavaType()), ExpressionMath.add((Expression)((InternalSelection)x).getCurrentNode(), (Object)((InternalSelection)y).getCurrentNode()), this.buildList(x, y), "sum");
    }

    public jakarta.persistence.criteria.Expression<Long> sumAsLong(jakarta.persistence.criteria.Expression<Integer> x) {
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)x).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    public jakarta.persistence.criteria.Expression<Double> sumAsDouble(jakarta.persistence.criteria.Expression<Float> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ((InternalSelection)x).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> prod(jakarta.persistence.criteria.Expression<? extends N> x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion((Object)x.getJavaType(), (Object)y.getJavaType()), ExpressionMath.multiply((Expression)((InternalSelection)x).getCurrentNode(), (Object)((InternalSelection)y).getCurrentNode()), this.buildList(x, y), "prod");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> diff(jakarta.persistence.criteria.Expression<? extends N> x, jakarta.persistence.criteria.Expression<? extends N> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.subtract((Expression)((InternalSelection)x).getCurrentNode(), (Object)((InternalSelection)y).getCurrentNode()), list, "diff");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(jakarta.persistence.criteria.Expression<? extends N> x, N y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion((Object)x.getJavaType(), y.getClass()), ExpressionMath.add((Expression)((InternalSelection)x).getCurrentNode(), y), this.buildList(x, this.internalLiteral(y)), "sum");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> prod(jakarta.persistence.criteria.Expression<? extends N> x, N y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion((Object)x.getJavaType(), y.getClass()), ExpressionMath.multiply((Expression)((InternalSelection)x).getCurrentNode(), y), this.buildList(x, this.internalLiteral(y)), "prod");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> diff(jakarta.persistence.criteria.Expression<? extends N> x, N y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.internalLiteral(y));
        return new FunctionExpressionImpl(this.metamodel, y.getClass(), ExpressionMath.subtract((Expression)((InternalSelection)x).getCurrentNode(), y), list, "diff");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> sum(N x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getClass(), (Object)y.getJavaType()), ExpressionMath.add((Expression)new ConstantExpression(x, ((InternalSelection)y).getCurrentNode()), (Object)((InternalSelection)y).getCurrentNode()), this.buildList(this.internalLiteral(x), y), "sum");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> prod(N x, jakarta.persistence.criteria.Expression<? extends N> y) {
        return new FunctionExpressionImpl(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion(x.getClass(), (Object)y.getJavaType()), ExpressionMath.multiply((Expression)new ConstantExpression(x, ((InternalSelection)y).getCurrentNode()), (Object)((InternalSelection)y).getCurrentNode()), this.buildList(this.internalLiteral(x), y), "prod");
    }

    public <N extends Number> jakarta.persistence.criteria.Expression<N> diff(N x, jakarta.persistence.criteria.Expression<? extends N> y) {
        ArrayList list = new ArrayList();
        ExpressionImpl literal = (ExpressionImpl)this.internalLiteral(x);
        list.add(literal);
        list.add(y);
        return new FunctionExpressionImpl(this.metamodel, literal.getJavaType(), ExpressionMath.subtract((Expression)literal.getCurrentNode(), (Object)((InternalSelection)y).getCurrentNode()), list, "diff");
    }

    public jakarta.persistence.criteria.Expression<Number> quot(jakarta.persistence.criteria.Expression<? extends Number> x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion((Object)x.getJavaType(), y.getClass()), ExpressionMath.divide((Expression)((InternalSelection)x).getCurrentNode(), (Object)((InternalSelection)y).getCurrentNode()), this.buildList(x, y), "quot");
    }

    public jakarta.persistence.criteria.Expression<Number> quot(jakarta.persistence.criteria.Expression<? extends Number> x, Number y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, (Class)BasicTypeHelperImpl.getInstance().extendedBinaryNumericPromotion((Object)x.getJavaType(), y.getClass()), ExpressionMath.divide((Expression)((InternalSelection)x).getCurrentNode(), (Object)y), this.buildList(x, this.internalLiteral(y)), "quot");
    }

    public jakarta.persistence.criteria.Expression<Number> quot(Number x, jakarta.persistence.criteria.Expression<? extends Number> y) {
        return new FunctionExpressionImpl<Number>(this.metamodel, ClassConstants.NUMBER, ExpressionMath.divide((Expression)new ConstantExpression((Object)x, ((InternalSelection)y).getCurrentNode()), (Object)((InternalSelection)y).getCurrentNode()), this.buildList(this.internalLiteral(x), y), "quot");
    }

    public jakarta.persistence.criteria.Expression<Integer> mod(jakarta.persistence.criteria.Expression<Integer> x, jakarta.persistence.criteria.Expression<Integer> y) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod((Expression)((InternalSelection)x).getCurrentNode(), (Object)((InternalSelection)y).getCurrentNode()), this.buildList(x, y), "mod");
    }

    public jakarta.persistence.criteria.Expression<Integer> mod(jakarta.persistence.criteria.Expression<Integer> x, Integer y) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod((Expression)((InternalSelection)x).getCurrentNode(), (Object)y), this.buildList(x, this.internalLiteral(y)), "mod");
    }

    public jakarta.persistence.criteria.Expression<Integer> mod(Integer x, jakarta.persistence.criteria.Expression<Integer> y) {
        jakarta.persistence.criteria.Expression<Integer> xExp = this.internalLiteral(x);
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ExpressionMath.mod((Expression)((InternalSelection)xExp).getCurrentNode(), (Object)((InternalSelection)y).getCurrentNode()), this.buildList(xExp, y), "mod");
    }

    public jakarta.persistence.criteria.Expression<Double> sqrt(jakarta.persistence.criteria.Expression<? extends Number> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ExpressionMath.sqrt((Expression)((InternalSelection)x).getCurrentNode()), this.buildList(x), "sqrt");
    }

    public jakarta.persistence.criteria.Expression<Long> toLong(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<Integer> toInteger(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<Float> toFloat(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<Double> toDouble(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<BigDecimal> toBigDecimal(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<BigInteger> toBigInteger(jakarta.persistence.criteria.Expression<? extends Number> number) {
        return number;
    }

    public jakarta.persistence.criteria.Expression<String> toString(jakarta.persistence.criteria.Expression<Character> character) {
        ExpressionImpl impl = (ExpressionImpl)character;
        return impl;
    }

    public <T> jakarta.persistence.criteria.Expression<T> literal(T value) {
        if (value == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"jpa_criteriaapi_null_literal_value", (Object[])new Object[0]));
        }
        return new ExpressionImpl(this.metamodel, value.getClass(), (Expression)new ConstantExpression(value, (Expression)new ExpressionBuilder()), value);
    }

    public <T> jakarta.persistence.criteria.Expression<T> nullLiteral(Class<T> resultClass) {
        return new ExpressionImpl<T>(this.metamodel, resultClass, (Expression)new ConstantExpression(null, (Expression)new ExpressionBuilder()), null);
    }

    protected <T> jakarta.persistence.criteria.Expression<T> internalLiteral(T value) {
        return new ExpressionImpl(this.metamodel, value == null ? null : value.getClass(), (Expression)new ConstantExpression(value, (Expression)new ExpressionBuilder()), value);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass, name);
    }

    public <C extends Collection<?>> Predicate isEmpty(jakarta.persistence.criteria.Expression<C> collection) {
        if (((InternalExpression)collection).isLiteral()) {
            if (((Collection)((ConstantExpression)((InternalSelection)collection).getCurrentNode()).getValue()).isEmpty()) {
                return this.conjunction();
            }
            return this.disjunction();
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)collection).getCurrentNode().size(ClassConstants.INTEGER).equal(0), this.buildList(collection), "isEmpty");
    }

    public <C extends Collection<?>> Predicate isNotEmpty(jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)collection).getCurrentNode().size(ClassConstants.INTEGER).equal(0).not(), this.buildList(collection), "isNotEmpty");
    }

    public <C extends Collection<?>> jakarta.persistence.criteria.Expression<Integer> size(C collection) {
        return this.internalLiteral(collection.size());
    }

    public <C extends Collection<?>> jakarta.persistence.criteria.Expression<Integer> size(jakarta.persistence.criteria.Expression<C> collection) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)collection).getCurrentNode().size(ClassConstants.INTEGER), this.buildList(collection), SIZE);
    }

    public <E, C extends Collection<E>> Predicate isMember(E elem, jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)collection).getCurrentNode().equal(elem), this.buildList(collection, this.internalLiteral(elem)), "isMember");
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E elem, jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)collection).getCurrentNode().notEqual(elem), this.buildList(collection, this.internalLiteral(elem)), "isMember");
    }

    public <E, C extends Collection<E>> Predicate isMember(jakarta.persistence.criteria.Expression<E> elem, jakarta.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)collection).getCurrentNode().equal(((InternalSelection)elem).getCurrentNode()), this.buildList(collection, elem), "isMember");
    }

    public <E, C extends Collection<E>> Predicate isNotMember(jakarta.persistence.criteria.Expression<E> elem, jakarta.persistence.criteria.Expression<C> collection) {
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(((ExpressionImpl)elem).getJavaType());
        ExpressionBuilder elemBuilder = new ExpressionBuilder();
        Expression collectionExp = ((InternalSelection)collection).getCurrentNode();
        Expression elemExp = ((InternalSelection)elem).getCurrentNode();
        subQuery.setExpressionBuilder(elemBuilder);
        subQuery.setShouldRetrieveFirstPrimaryKey(true);
        subQuery.setSelectionCriteria(elemBuilder.equal(collectionExp).and(collectionExp.equal(elemExp)));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)elem).getCurrentNode().notExists(subQuery), this.buildList(elem, collection), "isNotMemeber");
    }

    public <V, M extends Map<?, V>> jakarta.persistence.criteria.Expression<Collection<V>> values(M map) {
        return this.internalLiteral(map.values());
    }

    public <K, M extends Map<K, ?>> jakarta.persistence.criteria.Expression<Set<K>> keys(M map) {
        return this.internalLiteral(map.keySet());
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x, pattern);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().like(((InternalSelection)pattern).getCurrentNode()), list, "like");
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x, pattern, escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().like(((InternalSelection)pattern).getCurrentNode(), ((InternalSelection)escapeChar).getCurrentNode()), list, "like");
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return this.like(x, pattern, this.internalLiteral(Character.valueOf(escapeChar)));
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, String pattern) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x, this.internalLiteral(pattern));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().like(pattern), list, "like");
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, String pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        return this.like(x, this.internalLiteral(pattern), escapeChar);
    }

    public Predicate like(jakarta.persistence.criteria.Expression<String> x, String pattern, char escapeChar) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x, this.internalLiteral(pattern), this.internalLiteral(Character.valueOf(escapeChar)));
        String escapeString = String.valueOf(escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().like(pattern, escapeString), list, "like");
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x, pattern);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().notLike(((InternalSelection)pattern).getCurrentNode()), list, "notLike");
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x, pattern, escapeChar);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().notLike(((InternalSelection)pattern).getCurrentNode(), ((InternalSelection)escapeChar).getCurrentNode()), list, "like");
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return this.notLike(x, pattern, this.internalLiteral(Character.valueOf(escapeChar)));
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, String pattern) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.internalLiteral(pattern));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().notLike(pattern), list, "notLike");
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, String pattern, jakarta.persistence.criteria.Expression<Character> escapeChar) {
        return this.notLike(x, this.internalLiteral(pattern), escapeChar);
    }

    public Predicate notLike(jakarta.persistence.criteria.Expression<String> x, String pattern, char escapeChar) {
        return this.notLike(x, this.internalLiteral(pattern), this.internalLiteral(Character.valueOf(escapeChar)));
    }

    public jakarta.persistence.criteria.Expression<String> concat(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        Expression xNode = ((InternalSelection)x).getCurrentNode();
        Expression yNode = ((InternalSelection)y).getCurrentNode();
        if (xNode.isParameterExpression() && yNode.isParameterExpression()) {
            ((org.eclipse.persistence.internal.expressions.ParameterExpression)xNode).setType((Object)ClassConstants.STRING);
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, xNode.concat((Object)yNode), list, CONCAT);
    }

    public jakarta.persistence.criteria.Expression<String> concat(jakarta.persistence.criteria.Expression<String> x, String y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.internalLiteral(y));
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().concat((Object)y), list, CONCAT);
    }

    public jakarta.persistence.criteria.Expression<String> concat(String x, jakarta.persistence.criteria.Expression<String> y) {
        ArrayList list = new ArrayList();
        ExpressionImpl literal = (ExpressionImpl)this.internalLiteral(x);
        list.add(literal);
        list.add(y);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, literal.getCurrentNode().concat((Object)((InternalSelection)y).getCurrentNode()), list, CONCAT);
    }

    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<Integer> from) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().substring((Object)((InternalSelection)from).getCurrentNode()), this.buildList(x, from), "subString");
    }

    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, int from) {
        return this.substring(x, this.internalLiteral(from));
    }

    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<Integer> from, jakarta.persistence.criteria.Expression<Integer> len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().substring((Object)((InternalSelection)from).getCurrentNode(), (Object)((InternalSelection)len).getCurrentNode()), this.buildList(x, from, len), "subString");
    }

    public jakarta.persistence.criteria.Expression<String> substring(jakarta.persistence.criteria.Expression<String> x, int from, int len) {
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().substring(from, len), this.buildList(x, this.internalLiteral(from), this.internalLiteral(len)), "subString");
    }

    public jakarta.persistence.criteria.Expression<String> trim(jakarta.persistence.criteria.Expression<String> x) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().trim(), list, "trim");
    }

    public jakarta.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, jakarta.persistence.criteria.Expression<String> x) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x);
        if (ts == CriteriaBuilder.Trimspec.LEADING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().leftTrim(), list, "leftTrim");
        }
        if (ts == CriteriaBuilder.Trimspec.TRAILING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().rightTrim(), list, "rightTrim");
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().rightTrim().leftTrim(), list, "bothTrim");
    }

    public jakarta.persistence.criteria.Expression<String> trim(jakarta.persistence.criteria.Expression<Character> t, jakarta.persistence.criteria.Expression<String> x) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x, t);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().trim((Object)((InternalSelection)t).getCurrentNode()), list, "trim");
    }

    public jakarta.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, jakarta.persistence.criteria.Expression<Character> t, jakarta.persistence.criteria.Expression<String> x) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x, t);
        if (ts == CriteriaBuilder.Trimspec.LEADING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().leftTrim((Object)((InternalSelection)t).getCurrentNode()), list, "leftTrim");
        }
        if (ts == CriteriaBuilder.Trimspec.TRAILING) {
            return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().rightTrim((Object)((InternalSelection)t).getCurrentNode()), list, "rightTrim");
        }
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().rightTrim((Object)((InternalSelection)t).getCurrentNode()).leftTrim((Object)((InternalSelection)t).getCurrentNode()), list, "bothTrim");
    }

    public jakarta.persistence.criteria.Expression<String> trim(char t, jakarta.persistence.criteria.Expression<String> x) {
        return this.trim(this.internalLiteral(Character.valueOf(t)), x);
    }

    public jakarta.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec ts, char t, jakarta.persistence.criteria.Expression<String> x) {
        return this.trim(ts, this.internalLiteral(Character.valueOf(t)), x);
    }

    public jakarta.persistence.criteria.Expression<String> lower(jakarta.persistence.criteria.Expression<String> x) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().toLowerCase(), list, "lower");
    }

    public jakarta.persistence.criteria.Expression<String> upper(jakarta.persistence.criteria.Expression<String> x) {
        List<jakarta.persistence.criteria.Expression<?>> list = this.buildList(x);
        return new FunctionExpressionImpl<String>(this.metamodel, ClassConstants.STRING, ((InternalSelection)x).getCurrentNode().toUpperCase(), list, "upper");
    }

    public jakarta.persistence.criteria.Expression<Integer> length(jakarta.persistence.criteria.Expression<String> x) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)x).getCurrentNode().length(), this.buildList(x), "length");
    }

    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)x).getCurrentNode().locate((Object)((InternalSelection)pattern).getCurrentNode()), this.buildList(x, pattern), "locate");
    }

    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, jakarta.persistence.criteria.Expression<String> pattern, jakarta.persistence.criteria.Expression<Integer> from) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)x).getCurrentNode().locate((Object)((InternalSelection)pattern).getCurrentNode(), (Object)((InternalSelection)from).getCurrentNode()), this.buildList(x, pattern, from), "locate");
    }

    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, String pattern) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)x).getCurrentNode().locate((Object)pattern), this.buildList(x, this.internalLiteral(pattern)), "locate");
    }

    public jakarta.persistence.criteria.Expression<Integer> locate(jakarta.persistence.criteria.Expression<String> x, String pattern, int from) {
        return new FunctionExpressionImpl<Integer>(this.metamodel, ClassConstants.INTEGER, ((InternalSelection)x).getCurrentNode().locate(pattern, from), this.buildList(x, this.internalLiteral(pattern), this.internalLiteral(from)), "locate");
    }

    public jakarta.persistence.criteria.Expression<Date> currentDate() {
        return new ExpressionImpl<Date>(this.metamodel, ClassConstants.SQLDATE, new ExpressionBuilder().currentDateDate());
    }

    public jakarta.persistence.criteria.Expression<Timestamp> currentTimestamp() {
        return new ExpressionImpl<Timestamp>(this.metamodel, ClassConstants.TIMESTAMP, new ExpressionBuilder().currentTimeStamp());
    }

    public jakarta.persistence.criteria.Expression<Time> currentTime() {
        return new ExpressionImpl<Time>(this.metamodel, ClassConstants.TIME, new ExpressionBuilder().currentTime());
    }

    public <T> CriteriaBuilder.In<T> in(jakarta.persistence.criteria.Expression<? extends T> expression) {
        ArrayList<jakarta.persistence.criteria.Expression<? extends T>> list = new ArrayList<jakarta.persistence.criteria.Expression<? extends T>>();
        list.add(expression);
        return new InImpl(this.metamodel, (ExpressionImpl)expression, new ArrayList(), list);
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> coalesce(jakarta.persistence.criteria.Expression<? extends Y> x, jakarta.persistence.criteria.Expression<? extends Y> y) {
        ArgumentListFunctionExpression coalesce = ((InternalSelection)x).getCurrentNode().coalesce();
        coalesce.addChild(((InternalSelection)x).getCurrentNode());
        coalesce.addChild(((InternalSelection)y).getCurrentNode());
        return new CoalesceImpl(this.metamodel, x.getJavaType(), (Expression)coalesce, this.buildList(x, y), "coalesce");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> coalesce(jakarta.persistence.criteria.Expression<? extends Y> x, Y y) {
        ArgumentListFunctionExpression coalesce = ((InternalSelection)x).getCurrentNode().coalesce();
        coalesce.addChild(((InternalSelection)x).getCurrentNode());
        coalesce.addChild(((InternalSelection)y).getCurrentNode());
        return new CoalesceImpl(this.metamodel, x.getJavaType(), (Expression)coalesce, this.buildList(x, this.internalLiteral(y)), "coalesce");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> nullif(jakarta.persistence.criteria.Expression<Y> x, jakarta.persistence.criteria.Expression<?> y) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().nullIf((Object)((InternalSelection)y).getCurrentNode()), this.buildList(x, y), "nullIf");
    }

    public <Y> jakarta.persistence.criteria.Expression<Y> nullif(jakarta.persistence.criteria.Expression<Y> x, Y y) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().nullIf(y), this.buildList(x, this.internalLiteral(y)), "nullIf");
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        ArgumentListFunctionExpression coalesce = new ExpressionBuilder().coalesce();
        return new CoalesceImpl<Object>(this.metamodel, Object.class, (Expression)coalesce, new ArrayList());
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(jakarta.persistence.criteria.Expression<? extends C> expression) {
        ArgumentListFunctionExpression caseStatement = new ExpressionBuilder().caseStatement();
        return new SimpleCaseImpl<C, Object>(this.metamodel, Object.class, (FunctionExpression)caseStatement, new ArrayList(), expression);
    }

    public <R> CriteriaBuilder.Case<R> selectCase() {
        ArgumentListFunctionExpression caseStatement = new ExpressionBuilder().caseConditionStatement();
        return new CaseImpl<Object>(this.metamodel, Object.class, (Expression)caseStatement, (List<jakarta.persistence.criteria.Expression<?>>)new ArrayList());
    }

    public <T> jakarta.persistence.criteria.Expression<T> function(String name, Class<T> type, jakarta.persistence.criteria.Expression<?> ... args) {
        if (args != null && args.length > 0) {
            ArrayList<Expression> params = new ArrayList<Expression>();
            for (int index = 1; index < args.length; ++index) {
                jakarta.persistence.criteria.Expression<?> x = args[index];
                params.add(((InternalSelection)x).getCurrentNode());
            }
            return new FunctionExpressionImpl<T>(this.metamodel, type, ((InternalSelection)args[0]).getCurrentNode().getFunctionWithArguments(name, params), this.buildList(args), name);
        }
        return new FunctionExpressionImpl<T>(this.metamodel, type, new ExpressionBuilder().getFunction(name), new ArrayList(0), name);
    }

    @Override
    public <T> jakarta.persistence.criteria.Expression<T> fromExpression(Expression expression, Class<T> type) {
        return new FunctionExpressionImpl<T>(this.metamodel, type, expression, new ArrayList(0));
    }

    @Override
    public jakarta.persistence.criteria.Expression fromExpression(Expression expression) {
        return new FunctionExpressionImpl<Object>(this.metamodel, Object.class, expression, new ArrayList(0));
    }

    @Override
    public Expression toExpression(jakarta.persistence.criteria.Expression expression) {
        return ((SelectionImpl)expression).getCurrentNode();
    }

    public <T> CriteriaDelete<T> createCriteriaDelete(Class<T> targetEntity) {
        TypeImpl<T> type;
        if (targetEntity != null && (type = ((MetamodelImpl)this.metamodel).getType(targetEntity)) != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaDeleteImpl<T>(this.metamodel, this, targetEntity);
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_bean_class", (Object[])new Object[]{targetEntity}));
    }

    public <T> CriteriaUpdate<T> createCriteriaUpdate(Class<T> targetEntity) {
        TypeImpl<T> type;
        if (targetEntity != null && (type = ((MetamodelImpl)this.metamodel).getType(targetEntity)) != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaUpdateImpl<T>(this.metamodel, this, targetEntity);
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"unknown_bean_class", (Object[])new Object[]{targetEntity}));
    }

    public <X, T, V extends T> Join<X, V> treat(Join<X, T> join, Class<V> type) {
        JoinImpl parentJoin = (JoinImpl)join;
        JoinImpl joinImpl = new JoinImpl(parentJoin, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        joinImpl.isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    public <X, T, E extends T> CollectionJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        CollectionJoinImpl parentJoin = (CollectionJoinImpl)join;
        CollectionJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicCollectionJoinImpl ? new BasicCollectionJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new CollectionJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    public <X, T, E extends T> SetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        SetJoinImpl parentJoin = (SetJoinImpl)join;
        SetJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicSetJoinImpl ? new BasicSetJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new SetJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    public <X, T, E extends T> ListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        ListJoinImpl parentJoin = (ListJoinImpl)join;
        ListJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicListJoinImpl ? new BasicListJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new ListJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    public <X, K, T, V extends T> MapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        MapJoinImpl parentJoin = (MapJoinImpl)join;
        MapJoinImpl joinImpl = null;
        joinImpl = join instanceof BasicMapJoinImpl ? new BasicMapJoinImpl(parentJoin, this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType()) : new MapJoinImpl(join, this.metamodel.managedType(type), this.metamodel, type, parentJoin.currentNode.treat(type), parentJoin.getModel(), parentJoin.getJoinType());
        parentJoin.joins.add(joinImpl);
        ((FromImpl)joinImpl).isJoin = parentJoin.isJoin;
        parentJoin.isJoin = false;
        return joinImpl;
    }

    public <X, T extends X> Path<T> treat(Path<X> path, Class<T> type) {
        PathImpl parentPath = (PathImpl)path;
        PathImpl newPath = (PathImpl)parentPath.clone();
        newPath.currentNode = newPath.currentNode.treat(type);
        newPath.pathParent = parentPath;
        newPath.javaType = type;
        newPath.modelArtifact = this.metamodel.managedType(type);
        return newPath;
    }

    public <X, T extends X> Root<T> treat(Root<X> root, Class<T> type) {
        RootImpl parentRoot = (RootImpl)root;
        EntityType entity = this.metamodel.entity(type);
        return new RootImpl<T>((ManagedType)entity, this.metamodel, type, parentRoot.currentNode.treat(type), (Bindable)entity);
    }

    public static class SimpleCaseImpl<C, R>
    extends FunctionExpressionImpl<R>
    implements CriteriaBuilder.SimpleCase<C, R> {
        private jakarta.persistence.criteria.Expression<C> expression;

        protected <T> SimpleCaseImpl(Metamodel metamodel, Class<R> resultClass, FunctionExpression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, jakarta.persistence.criteria.Expression<C> expression) {
            super(metamodel, resultClass, (Expression)expressionNode, compoundExpressions);
            this.expression = expression;
            expressionNode.addChild(((InternalSelection)expression).getCurrentNode());
        }

        protected <T> SimpleCaseImpl(Metamodel metamodel, Class<R> resultClass, FunctionExpression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, String operator, jakarta.persistence.criteria.Expression<C> expression) {
            super(metamodel, resultClass, (Expression)expressionNode, compoundExpressions, operator);
            this.expression = expression;
            expressionNode.addChild(((InternalSelection)expression).getCurrentNode());
        }

        public jakarta.persistence.criteria.Expression<C> getExpression() {
            return this.expression;
        }

        public CriteriaBuilder.SimpleCase<C, R> when(C condition, R result) {
            Expression conditionExp = Expression.from(condition, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = Expression.from(result, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        public CriteriaBuilder.SimpleCase<C, R> when(C condition, jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = Expression.from(condition, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = ((InternalSelection)result).getCurrentNode();
            resultExp = Expression.from((Object)resultExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        public jakarta.persistence.criteria.Expression<R> otherwise(R result) {
            Expression resultExp = Expression.from(result, (Expression)new ExpressionBuilder());
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }

        public jakarta.persistence.criteria.Expression<R> otherwise(jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression resultExp = ((InternalSelection)result).getCurrentNode();
            resultExp = Expression.from((Object)resultExp, (Expression)this.currentNode);
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }
    }

    public static class CaseImpl<R>
    extends FunctionExpressionImpl<R>
    implements CriteriaBuilder.Case<R> {
        protected <T> CaseImpl(Metamodel metamodel, Class<R> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions) {
            super(metamodel, resultClass, expressionNode, compoundExpressions);
        }

        protected <T> CaseImpl(Metamodel metamodel, Class<R> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, String operator) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
        }

        public CriteriaBuilder.Case<R> when(jakarta.persistence.criteria.Expression<Boolean> condition, R result) {
            Expression conditionExp = ((InternalSelection)condition).getCurrentNode();
            conditionExp = Expression.from((Object)conditionExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = Expression.from(result, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        public CriteriaBuilder.Case<R> when(jakarta.persistence.criteria.Expression<Boolean> condition, jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression conditionExp = ((InternalSelection)condition).getCurrentNode();
            conditionExp = Expression.from((Object)conditionExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(conditionExp);
            Expression resultExp = ((InternalSelection)result).getCurrentNode();
            resultExp = Expression.from((Object)resultExp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(resultExp);
            return this;
        }

        public jakarta.persistence.criteria.Expression<R> otherwise(R result) {
            Expression resultExp = Expression.from(result, (Expression)new ExpressionBuilder());
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }

        public jakarta.persistence.criteria.Expression<R> otherwise(jakarta.persistence.criteria.Expression<? extends R> result) {
            Expression resultExp = ((InternalSelection)result).getCurrentNode();
            resultExp = Expression.from((Object)resultExp, (Expression)this.currentNode);
            ((ArgumentListFunctionExpression)this.currentNode).addRightMostChild(resultExp);
            return this;
        }
    }

    public static class CoalesceImpl<X>
    extends FunctionExpressionImpl<X>
    implements CriteriaBuilder.Coalesce<X> {
        protected <T> CoalesceImpl(Metamodel metamodel, Class<X> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions) {
            super(metamodel, resultClass, expressionNode, compoundExpressions);
        }

        protected <T> CoalesceImpl(Metamodel metamodel, Class<X> resultClass, Expression expressionNode, List<jakarta.persistence.criteria.Expression<?>> compoundExpressions, String operator) {
            super(metamodel, resultClass, expressionNode, compoundExpressions, operator);
        }

        public CriteriaBuilder.Coalesce<X> value(X value) {
            Expression exp = Expression.from(value, (Expression)new ExpressionBuilder());
            ((FunctionExpression)this.currentNode).addChild(exp);
            return this;
        }

        public CriteriaBuilder.Coalesce<X> value(jakarta.persistence.criteria.Expression<? extends X> value) {
            Expression exp = ((InternalSelection)value).getCurrentNode();
            exp = Expression.from((Object)exp, (Expression)this.currentNode);
            ((FunctionExpression)this.currentNode).addChild(exp);
            return this;
        }
    }
}

