/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityListener
extends DescriptorEventAdapter {
    public static final String POST_BUILD = "postBuild";
    public static final String POST_CLONE = "postClone";
    public static final String POST_DELETE = "postDelete";
    public static final String POST_INSERT = "postInsert";
    public static final String POST_REFRESH = "postRefresh";
    public static final String POST_UPDATE = "postUpdate";
    public static final String PRE_PERSIST = "prePersist";
    public static final String PRE_REMOVE = "preRemove";
    public static final String PRE_UPDATE_WITH_CHANGES = "preUpdateWithChanges";
    private Object m_listener;
    private Class m_entityClass;
    private Hashtable<String, List<Method>> m_methods;
    private Hashtable<String, Hashtable<Integer, Boolean>> m_overriddenEvents;
    private static Hashtable<Integer, String> m_eventStrings;

    protected EntityListener(Class entityClass) {
        this.m_entityClass = entityClass;
        this.m_methods = new Hashtable();
        this.m_overriddenEvents = new Hashtable();
        if (m_eventStrings == null) {
            m_eventStrings = new Hashtable();
            m_eventStrings.put(8, POST_BUILD);
            m_eventStrings.put(10, POST_CLONE);
            m_eventStrings.put(3, POST_DELETE);
            m_eventStrings.put(5, POST_INSERT);
            m_eventStrings.put(9, POST_REFRESH);
            m_eventStrings.put(7, POST_UPDATE);
            m_eventStrings.put(15, PRE_PERSIST);
            m_eventStrings.put(16, PRE_REMOVE);
            m_eventStrings.put(17, PRE_UPDATE_WITH_CHANGES);
        }
    }

    public EntityListener(Object listener, Class entityClass) {
        this(entityClass);
        this.m_listener = listener;
    }

    public void addEventMethod(String event, Method method) {
        if (this.m_methods.containsKey(event)) {
            Method lastEventMethod = this.getLastEventMethod(event);
            if (lastEventMethod.getDeclaringClass().equals(method.getDeclaringClass())) {
                throw ValidationException.multipleLifecycleCallbackMethodsForSameLifecycleEvent((Object)this.getListenerClass(), (Method)method, (Method)lastEventMethod);
            }
            this.validateMethod(method);
            this.m_methods.get(event).add(method);
        } else {
            this.validateMethod(method);
            ArrayList<Method> methods = new ArrayList<Method>();
            methods.add(method);
            this.m_methods.put(event, methods);
        }
    }

    public Class getEntityClass() {
        return this.m_entityClass;
    }

    protected List<Method> getEventMethods(int eventCode) {
        String eventString = m_eventStrings.get(eventCode);
        if (eventString != null) {
            return this.getEventMethods(eventString);
        }
        return null;
    }

    protected List<Method> getEventMethods(String event) {
        return this.m_methods.get(event);
    }

    protected Method getLastEventMethod(String event) {
        List<Method> methods = this.m_methods.get(event);
        return methods.get(methods.size() - 1);
    }

    public Class getListenerClass() {
        return this.m_listener.getClass();
    }

    public boolean hasCallbackMethods() {
        return this.m_methods.size() > 0;
    }

    protected boolean hasEventMethods(int eventCode) {
        return this.getEventMethods(eventCode) != null;
    }

    protected boolean hasEventMethods(String event) {
        return this.getEventMethods(event) != null;
    }

    protected boolean hasOverriddenEventMethod(List<Method> eventMethods, Method eventMethod) {
        if (eventMethods != null) {
            for (Method method : eventMethods) {
                if (!method.getName().equals(eventMethod.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasOverriddenEventMethod(Method eventMethod, int eventCode) {
        return this.hasOverriddenEventMethod(this.getEventMethods(eventCode), eventMethod);
    }

    protected boolean hasOverriddenEventMethod(Method eventMethod, String eventCode) {
        return this.hasOverriddenEventMethod(this.getEventMethods(eventCode), eventMethod);
    }

    void invokeMethod(Method method, Object onObject, Object[] objectList, DescriptorEvent event) {
        block10: {
            if (method != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(method, onObject, objectList));
                            break block10;
                        }
                        catch (PrivilegedActionException exception) {
                            Exception throwableException = exception.getException();
                            if (throwableException instanceof IllegalAccessException) {
                                throw ValidationException.invalidCallbackMethod(onObject.getClass(), (String)method.toString());
                            }
                            Throwable cause = throwableException.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw (Error)cause;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod((Method)method, (Object)onObject, (Object[])objectList);
                }
                catch (IllegalAccessException exception) {
                    throw ValidationException.invalidCallbackMethod(onObject.getClass(), (String)method.toString());
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw (Error)cause;
                }
            }
        }
    }

    void invokeMethod(String event, DescriptorEvent descriptorEvent) {
        List<Method> eventMethods = this.getEventMethods(event);
        if (eventMethods != null) {
            for (Method method : eventMethods) {
                Object[] objectList = new Object[]{descriptorEvent.getSource()};
                this.invokeMethod(method, this.m_listener, objectList, descriptorEvent);
            }
        }
    }

    public boolean isOverriddenEvent(DescriptorEvent event, Vector eventManagers) {
        int eventCode = event.getEventCode();
        String forSubclass = event.getDescriptor().getJavaClassName();
        Hashtable<Integer, Boolean> subClassMap = this.m_overriddenEvents.get(forSubclass);
        if (subClassMap == null) {
            subClassMap = new Hashtable();
        }
        if (!subClassMap.containsKey(eventCode)) {
            boolean hasOverrides = false;
            if (this.hasEventMethods(eventCode)) {
                List<Method> eventMethods = this.getEventMethods(eventCode);
                for (Method eventMethod : eventMethods) {
                    DescriptorEventManager eventManager;
                    EntityListener childListener;
                    Iterator i$ = eventManagers.iterator();
                    while (i$.hasNext() && (childListener = (EntityListener)(eventManager = (DescriptorEventManager)i$.next()).getEntityEventListener()) != this) {
                        if (!childListener.hasOverriddenEventMethod(eventMethod, eventCode)) continue;
                        hasOverrides = true;
                        break;
                    }
                    if (!hasOverrides) continue;
                    break;
                }
            }
            subClassMap.put(eventCode, hasOverrides);
            this.m_overriddenEvents.put(forSubclass, subClassMap);
        }
        return subClassMap.get(eventCode);
    }

    public void postBuild(DescriptorEvent event) {
        this.invokeMethod(POST_BUILD, event);
    }

    public void postClone(DescriptorEvent event) {
        this.invokeMethod(POST_CLONE, event);
    }

    public void postDelete(DescriptorEvent event) {
        this.invokeMethod(POST_DELETE, event);
    }

    public void postInsert(DescriptorEvent event) {
        this.invokeMethod(POST_INSERT, event);
    }

    public void postRefresh(DescriptorEvent event) {
        this.invokeMethod(POST_REFRESH, event);
    }

    public void postUpdate(DescriptorEvent event) {
        this.invokeMethod(POST_UPDATE, event);
    }

    public void prePersist(DescriptorEvent event) {
        this.invokeMethod(PRE_PERSIST, event);
    }

    public void preRemove(DescriptorEvent event) {
        this.invokeMethod(PRE_REMOVE, event);
    }

    public void preUpdateWithChanges(DescriptorEvent event) {
        this.invokeMethod(PRE_UPDATE_WITH_CHANGES, event);
    }

    public void setPostBuildMethod(Method method) {
        this.addEventMethod(POST_BUILD, method);
    }

    public void setPostCloneMethod(Method method) {
        this.addEventMethod(POST_CLONE, method);
    }

    public void setPostDeleteMethod(Method method) {
        this.addEventMethod(POST_DELETE, method);
    }

    public void setPostInsertMethod(Method method) {
        this.addEventMethod(POST_INSERT, method);
    }

    public void setPostRefreshMethod(Method method) {
        this.addEventMethod(POST_REFRESH, method);
    }

    public void setPostUpdateMethod(Method method) {
        this.addEventMethod(POST_UPDATE, method);
    }

    public void setPrePersistMethod(Method method) {
        this.addEventMethod(PRE_PERSIST, method);
    }

    public void setPreRemoveMethod(Method method) {
        this.addEventMethod(PRE_REMOVE, method);
    }

    public void setPreUpdateWithChangesMethod(Method method) {
        this.addEventMethod(PRE_UPDATE_WITH_CHANGES, method);
    }

    public String toString() {
        return this.getEntityClass().getName();
    }

    protected void validateMethod(Method method) {
        int numberOfParameters = method.getParameterTypes().length;
        if (numberOfParameters != 1 || !method.getParameterTypes()[0].isAssignableFrom(this.m_entityClass)) {
            Class<?> parameterClass = numberOfParameters == 0 ? null : method.getParameterTypes()[0];
            throw ValidationException.invalidEntityListenerCallbackMethodArguments((Object)this.m_entityClass, parameterClass, this.m_listener.getClass(), (String)method.getName());
        }
        this.validateMethodModifiers(method);
    }

    protected void validateMethodModifiers(Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
            throw ValidationException.invalidCallbackMethodModifier((Object)this.getListenerClass(), (String)method.getName());
        }
    }
}

