/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.Map;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedPLSQLStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredFunctionCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class NamedPLSQLStoredFunctionQueryMetadata
extends NamedPLSQLStoredProcedureQueryMetadata {
    private PLSQLParameterMetadata returnParameter;

    public NamedPLSQLStoredFunctionQueryMetadata() {
        super("<named-plsql-stored-function-query>");
    }

    public NamedPLSQLStoredFunctionQueryMetadata(MetadataAnnotation namedStoredProcedureQuery, MetadataAccessor accessor) {
        super(namedStoredProcedureQuery, accessor);
        this.returnParameter = new PLSQLParameterMetadata((MetadataAnnotation)namedStoredProcedureQuery.getAttribute("returnParameter"), accessor);
        this.setProcedureName((String)namedStoredProcedureQuery.getAttribute("functionName"));
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedPLSQLStoredFunctionQueryMetadata) {
            NamedPLSQLStoredFunctionQueryMetadata query = (NamedPLSQLStoredFunctionQueryMetadata)objectToCompare;
            return this.valuesMatch(this.returnParameter, query.getReturnParameter());
        }
        return false;
    }

    public PLSQLParameterMetadata getReturnParameter() {
        return this.returnParameter;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.returnParameter, accessibleObject);
    }

    public void process(AbstractSession session, ClassLoader loader, MetadataProject project) {
        PLSQLStoredFunctionCall call = new PLSQLStoredFunctionCall();
        for (PLSQLParameterMetadata parameter : this.getParameters()) {
            parameter.process((PLSQLStoredProcedureCall)call, project, false);
        }
        if (this.getReturnParameter() != null) {
            this.getReturnParameter().process((PLSQLStoredProcedureCall)call, project, true);
        }
        call.setProcedureName(this.getProcedureName());
        Map<String, Object> hints = this.processQueryHints(session);
        if (this.getResultClass().isVoid()) {
            if (this.hasResultSetMapping(session)) {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(this.getResultSetMapping(), (StoredProcedureCall)call, hints, loader, session));
            } else {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery((StoredProcedureCall)call, hints, loader, session));
            }
        } else {
            session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(MetadataHelper.getClassForName(this.getResultClass().getName(), loader), (StoredProcedureCall)call, hints, loader, session));
        }
    }

    public void setReturnParameter(PLSQLParameterMetadata returnParameter) {
        this.returnParameter = returnParameter;
    }
}

