/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.mappings;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CascadeMetadata
extends ORMetadata {
    private Boolean m_cascadeAll;
    private Boolean m_cascadePersist;
    private Boolean m_cascadeMerge;
    private Boolean m_cascadeRemove;
    private Boolean m_cascadeRefresh;
    private List<String> m_types;

    public CascadeMetadata() {
        super("<cascade>");
    }

    public CascadeMetadata(Object[] cascadeTypes, MetadataAccessor accessor) {
        super(null, accessor);
        this.m_types = new ArrayList<String>();
        for (Object cascadeType : cascadeTypes) {
            this.m_types.add((String)cascadeType);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof CascadeMetadata) {
            CascadeMetadata accessMethods = (CascadeMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_cascadeAll, accessMethods.getCascadeAll())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadePersist, accessMethods.getCascadePersist())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadeMerge, accessMethods.getCascadeMerge())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadeRemove, accessMethods.getCascadeRemove())) {
                return false;
            }
            return this.valuesMatch(this.m_cascadeRefresh, accessMethods.getCascadeRefresh());
        }
        return false;
    }

    public Boolean getCascadeAll() {
        return this.m_cascadeAll;
    }

    public Boolean getCascadeMerge() {
        return this.m_cascadeMerge;
    }

    public Boolean getCascadePersist() {
        return this.m_cascadePersist;
    }

    public Boolean getCascadeRefresh() {
        return this.m_cascadeRefresh;
    }

    public Boolean getCascadeRemove() {
        return this.m_cascadeRemove;
    }

    public List<String> getTypes() {
        if (this.m_types == null) {
            this.m_types = new ArrayList<String>();
            if (this.isCascadeAll()) {
                this.m_types.add(CascadeType.ALL.name());
            }
            if (this.isCascadePersist()) {
                this.m_types.add(CascadeType.PERSIST.name());
            }
            if (this.isCascadeMerge()) {
                this.m_types.add(CascadeType.MERGE.name());
            }
            if (this.isCascadeRemove()) {
                this.m_types.add(CascadeType.REMOVE.name());
            }
            if (this.isCascadeRefresh()) {
                this.m_types.add(CascadeType.REFRESH.name());
            }
        }
        return this.m_types;
    }

    public boolean isCascadeAll() {
        return this.m_cascadeAll != null && this.m_cascadeAll != false;
    }

    public boolean isCascadeMerge() {
        return this.m_cascadeMerge != null && this.m_cascadeMerge != false;
    }

    public boolean isCascadePersist() {
        return this.m_cascadePersist != null && this.m_cascadePersist != false;
    }

    public boolean isCascadeRefresh() {
        return this.m_cascadeRefresh != null && this.m_cascadeRefresh != false;
    }

    public boolean isCascadeRemove() {
        return this.m_cascadeRemove != null && this.m_cascadeRemove != false;
    }

    public void setCascadeAll(Boolean cascadeAll) {
        this.m_cascadeAll = cascadeAll;
    }

    public void setCascadeMerge(Boolean cascadeMerge) {
        this.m_cascadeMerge = cascadeMerge;
    }

    public void setCascadePersist(Boolean cascadePersist) {
        this.m_cascadePersist = cascadePersist;
    }

    public void setCascadeRefresh(Boolean cascadeRefresh) {
        this.m_cascadeRefresh = cascadeRefresh;
    }

    public void setCascadeRemove(Boolean cascadeRemove) {
        this.m_cascadeRemove = cascadeRemove;
    }
}

