/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithmeticFactorStateObject
extends AbstractStateObject {
    private boolean plusSign;
    private StateObject stateObject;
    public static final String ARITHMETIC_SIGN_PROPERTY = "arithmeticSign";
    public static final String STATE_OBJECT_PROPERTY = "stateObject";

    public ArithmeticFactorStateObject(StateObject parent) {
        super(parent);
    }

    public ArithmeticFactorStateObject(StateObject parent, boolean plusSign, StateObject stateObject) {
        super(parent);
        this.plusSign = plusSign;
        this.stateObject = this.parent(stateObject);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.stateObject != null) {
            children.add(this.stateObject);
        }
    }

    public void addMinus() {
        if (this.plusSign) {
            this.setArithmeticSign(false);
        }
    }

    public void addPlus() {
        if (!this.plusSign) {
            this.setArithmeticSign(true);
        }
    }

    public String getArithmeticSign() {
        return this.plusSign ? "+" : "-";
    }

    @Override
    public ArithmeticFactor getExpression() {
        return (ArithmeticFactor)super.getExpression();
    }

    public StateObject getStateObject() {
        return this.stateObject;
    }

    public boolean hasMinusSign() {
        return !this.plusSign;
    }

    public boolean hasPlusSign() {
        return this.plusSign;
    }

    public boolean hasStateObject() {
        return this.stateObject != null;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            ArithmeticFactorStateObject arithmeticFactor = (ArithmeticFactorStateObject)stateObject;
            return this.plusSign == arithmeticFactor.plusSign && this.areEquivalent(stateObject, arithmeticFactor.stateObject);
        }
        return false;
    }

    public void parse(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "arithmetic_factor");
        this.setStateObject((StateObject)stateObject);
    }

    public void setArithmeticSign(boolean plusSign) {
        boolean oldPlusSign = plusSign;
        this.plusSign = !oldPlusSign;
        this.firePropertyChanged(ARITHMETIC_SIGN_PROPERTY, oldPlusSign, plusSign);
    }

    public void setExpression(ArithmeticFactor expression) {
        super.setExpression(expression);
    }

    public void setStateObject(StateObject stateObject) {
        StateObject oldStateObject = this.stateObject;
        this.stateObject = this.parent(stateObject);
        this.firePropertyChanged(STATE_OBJECT_PROPERTY, oldStateObject, stateObject);
    }

    public void toggleArithmeticSign() {
        this.setArithmeticSign(!this.plusSign);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        writer.append(this.getArithmeticSign());
        if (this.stateObject != null) {
            writer.append(' ');
            this.stateObject.toString(writer);
        }
    }
}

