/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.coordination.jgroups;

import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.coordination.broadcast.BroadcastRemoteConnection;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.serializers.Serializer;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;

public class JGroupsRemoteConnection
extends BroadcastRemoteConnection {
    private static final long serialVersionUID = -2285543305296840902L;
    protected transient JChannel channel;
    protected boolean isLocal;

    public JGroupsRemoteConnection(RemoteCommandManager rcm, JChannel channel, boolean isLocalConnectionBeingCreated) {
        super(rcm);
        this.channel = channel;
        this.isLocal = isLocalConnectionBeingCreated;
        rcm.logDebug("creating_broadcast_connection", this.getInfo());
        try {
            if (isLocalConnectionBeingCreated) {
                this.channel.setReceiver((Receiver)new ReceiverAdapter(){

                    public void receive(Message message) {
                        JGroupsRemoteConnection.this.onMessage(message);
                    }
                });
                rcm.logDebug("broadcast_connection_created", this.getInfo());
            }
        }
        catch (RuntimeException ex) {
            rcm.logDebug("failed_to_create_broadcast_connection", this.getInfo());
            this.close();
            throw ex;
        }
    }

    public JGroupsRemoteConnection(RemoteCommandManager rcm) {
        super(rcm);
        this.isLocal = true;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    protected Object executeCommandInternal(Object command) throws Exception {
        Message message = null;
        message = command instanceof byte[] ? new Message(null, (byte[])command) : new Message(null, command);
        Object[] debugInfo = null;
        if (this.rcm.shouldLogDebugMessage()) {
            debugInfo = this.logDebugBeforePublish(null);
        }
        this.channel.send(message);
        if (debugInfo != null) {
            this.logDebugAfterPublish(debugInfo, null);
        }
        return null;
    }

    public void onMessage(Message message) {
        String messageId = "";
        if (this.rcm.shouldLogDebugMessage()) {
            this.logDebugOnReceiveMessage(null);
            this.logDebugMessage(message);
        }
        Object object = null;
        try {
            Serializer serializer = this.rcm.getSerializer();
            object = serializer != null ? serializer.deserialize((Object)message.getBuffer(), (Session)((AbstractSession)this.rcm.getCommandProcessor())) : message.getObject();
        }
        catch (Exception exception) {
            this.failDeserializeMessage(null, exception);
            return;
        }
        this.processReceivedObject(object, messageId);
    }

    protected boolean areAllResourcesFreedOnClose() {
        return !this.isLocal();
    }

    protected void closeInternal() {
        if (this.areAllResourcesFreedOnClose() && this.channel != null) {
            this.channel.close();
        }
    }

    protected String logDebugMessage(Message message) {
        Object[] args = new Object[]{this.channel.getName()};
        this.rcm.logDebugWithoutLevelCheck("retreived_remote_message_from_jgroup_channel", args);
        return this.channel.getName();
    }

    protected void createDisplayString() {
        this.displayString = String.valueOf(Helper.getShortClassName((Object)((Object)this))) + "[" + this.serviceId.toString() + "]";
    }

    protected boolean shouldCheckServiceId() {
        return false;
    }
}

