/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.mappings.EISCompositeCollectionMapping;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Attribute;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Descriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkTemplate;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Query;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.jpa.rs.util.list.QueryList;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class AbstractPersistenceUnitResource
extends AbstractResource {
    private static final String CLASS_NAME = AbstractPersistenceUnitResource.class.getName();

    protected Response getDescriptorMetadataInternal(String version, String persistenceUnit, String descriptorAlias, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "getDescriptorMetadataInternal", new Object[]{"GET", version, persistenceUnit, descriptorAlias, uriInfo.getRequestUri().toASCIIString()});
        String result = null;
        try {
            URI baseURI = uriInfo.getBaseUri();
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, baseURI, version, null);
            ClassDescriptor descriptor = context.getServerSession().getDescriptorForAlias(descriptorAlias);
            if (descriptor == null) {
                JPARSLogger.error(context.getSessionLog(), "jpars_could_not_find_entity_type", new Object[]{descriptorAlias, persistenceUnit});
                throw JPARSException.classOrClassDescriptorCouldNotBeFoundForEntity(descriptorAlias, persistenceUnit);
            }
            String mediaType = StreamingOutputMarshaller.mediaType(headers.getAcceptableMediaTypes()).toString();
            Descriptor returnDescriptor = this.buildDescriptor(context, persistenceUnit, descriptor, baseURI.toString());
            result = this.marshallMetadata(returnDescriptor, mediaType);
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, headers.getAcceptableMediaTypes())).build();
    }

    protected Response getQueriesMetadataInternal(String version, String persistenceUnit, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "getQueriesMetadataInternal", new Object[]{"GET", version, persistenceUnit, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            ArrayList<Query> queries = new ArrayList<Query>();
            this.addQueries(queries, context, null);
            String mediaType = StreamingOutputMarshaller.mediaType(headers.getAcceptableMediaTypes()).toString();
            QueryList queryList = new QueryList();
            queryList.setList(queries);
            String result = null;
            result = mediaType.equals("application/json") ? this.marshallMetadata(queryList.getList(), mediaType) : this.marshallMetadata(queryList, mediaType);
            return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    protected Response getQueryMetadataInternal(String version, String persistenceUnit, String queryName, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "getQueryMetadataInternal", new Object[]{"GET", version, persistenceUnit, queryName, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            ArrayList<Query> returnQueries = new ArrayList<Query>();
            Map queries = context.getServerSession().getQueries();
            if (queries.get(queryName) != null) {
                for (DatabaseQuery query : (List)queries.get(queryName)) {
                    returnQueries.add(this.getQuery(query, context));
                }
            }
            String mediaType = StreamingOutputMarshaller.mediaType(headers.getAcceptableMediaTypes()).toString();
            QueryList queryList = new QueryList();
            queryList.setList(returnQueries);
            String result = null;
            result = mediaType.equals("application/json") ? this.marshallMetadata(queryList.getList(), mediaType) : this.marshallMetadata(queryList, mediaType);
            return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    protected Response getTypesInternal(String version, String persistenceUnit, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "getTypesInternal", new Object[]{"GET", version, persistenceUnit, uriInfo.getRequestUri().toASCIIString()});
        try {
            URI baseURI = uriInfo.getBaseUri();
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, baseURI, version, null);
            PersistenceUnit pu = new PersistenceUnit();
            pu.setPersistenceUnitName(persistenceUnit);
            Map descriptors = context.getServerSession().getDescriptors();
            String mediaType = StreamingOutputMarshaller.mediaType(headers.getAcceptableMediaTypes()).toString();
            Iterator contextIterator = descriptors.keySet().iterator();
            while (contextIterator.hasNext()) {
                ClassDescriptor descriptor = (ClassDescriptor)descriptors.get(contextIterator.next());
                String alias = descriptor.getAlias();
                if (descriptor.isAggregateDescriptor()) continue;
                if (version != null) {
                    pu.getTypes().add(new Link(alias, mediaType, baseURI + version + "/" + persistenceUnit + "/metadata/entity/" + alias));
                    continue;
                }
                pu.getTypes().add(new Link(alias, mediaType, baseURI + persistenceUnit + "/metadata/entity/" + alias));
            }
            String result = this.marshallMetadata(pu, mediaType);
            return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    private void addMapping(Descriptor descriptor, DatabaseMapping mapping) {
        Object target = null;
        String collectionName = null;
        if (mapping.isCollectionMapping()) {
            if (mapping.isEISMapping()) {
                EISCompositeCollectionMapping collectionMapping = (EISCompositeCollectionMapping)mapping;
                Class collectionClass = collectionMapping.getContainerPolicy().getContainerClass();
                String collectionType = this.getSimplePublicCollectionTypeName(collectionClass);
                if (collectionType == null) {
                    collectionType = collectionClass.getSimpleName();
                }
                if (collectionMapping.getReferenceClass() != null) {
                    collectionName = collectionMapping.getReferenceClass().getSimpleName();
                }
                if (collectionName == null && collectionMapping.getAttributeClassification() != null) {
                    collectionName = collectionMapping.getAttributeClassification().getSimpleName();
                }
                if (collectionMapping.getContainerPolicy().isMapPolicy()) {
                    String mapKeyType = ((MapContainerPolicy)collectionMapping.getContainerPolicy()).getKeyType().getClass().getSimpleName();
                    target = collectionType + "<" + mapKeyType + ", " + collectionName + ">";
                } else {
                    target = collectionType + "<" + collectionName + ">";
                }
            } else {
                CollectionMapping collectionMapping = (CollectionMapping)mapping;
                Class collectionClass = collectionMapping.getContainerPolicy().getContainerClass();
                String collectionType = this.getSimplePublicCollectionTypeName(collectionClass);
                if (collectionType == null) {
                    collectionType = collectionClass.getSimpleName();
                }
                if (collectionMapping.getReferenceClass() != null) {
                    collectionName = collectionMapping.getReferenceClass().getSimpleName();
                }
                if (collectionName == null && collectionMapping.getAttributeClassification() != null) {
                    collectionName = collectionMapping.getAttributeClassification().getSimpleName();
                }
                if (collectionMapping.getContainerPolicy().isMapPolicy()) {
                    String mapKeyType = ((MapContainerPolicy)collectionMapping.getContainerPolicy()).getKeyType().getClass().getSimpleName();
                    target = collectionType + "<" + mapKeyType + ", " + collectionName + ">";
                } else {
                    target = collectionType + "<" + collectionName + ">";
                }
            }
        } else {
            target = mapping.isForeignReferenceMapping() ? ((ForeignReferenceMapping)mapping).getReferenceClass().getSimpleName() : mapping.getAttributeClassification().getSimpleName();
        }
        descriptor.getAttributes().add(new Attribute(mapping.getAttributeName(), (String)target));
    }

    private void addQueries(List<Query> queryList, PersistenceContext context, String javaClassName) {
        Map queries = context.getServerSession().getQueries();
        ArrayList<DatabaseQuery> returnQueries = new ArrayList<DatabaseQuery>();
        for (List keyQueries : queries.values()) {
            for (DatabaseQuery query : keyQueries) {
                if (javaClassName != null && (query.getReferenceClassName() == null || !query.getReferenceClassName().equals(javaClassName))) continue;
                returnQueries.add(query);
            }
        }
        Iterator queryIterator = returnQueries.iterator();
        while (queryIterator.hasNext()) {
            queryList.add(this.getQuery((DatabaseQuery)queryIterator.next(), context));
        }
    }

    private Descriptor buildDescriptor(PersistenceContext context, String persistenceUnit, ClassDescriptor descriptor, String baseUri) {
        Descriptor returnDescriptor = new Descriptor();
        String name = descriptor.getAlias();
        returnDescriptor.setName(name);
        Object version = context.getVersion();
        if (version != null) {
            version = (String)version + "/";
            returnDescriptor.getLinkTemplates().add(new LinkTemplate("find", "get", baseUri + (String)version + persistenceUnit + "/entity/" + descriptor.getAlias() + "/{primaryKey}"));
            returnDescriptor.getLinkTemplates().add(new LinkTemplate("persist", "put", baseUri + (String)version + persistenceUnit + "/entity/" + descriptor.getAlias()));
            returnDescriptor.getLinkTemplates().add(new LinkTemplate("update", "post", baseUri + (String)version + persistenceUnit + "/entity/" + descriptor.getAlias()));
            returnDescriptor.getLinkTemplates().add(new LinkTemplate("delete", "delete", baseUri + (String)version + persistenceUnit + "/entity/" + descriptor.getAlias() + "/{primaryKey}"));
        } else {
            returnDescriptor.getLinkTemplates().add(new LinkTemplate("find", "get", baseUri + persistenceUnit + "/entity/" + descriptor.getAlias() + "/{primaryKey}"));
            returnDescriptor.getLinkTemplates().add(new LinkTemplate("persist", "put", baseUri + persistenceUnit + "/entity/" + descriptor.getAlias()));
            returnDescriptor.getLinkTemplates().add(new LinkTemplate("update", "post", baseUri + persistenceUnit + "/entity/" + descriptor.getAlias()));
            returnDescriptor.getLinkTemplates().add(new LinkTemplate("delete", "delete", baseUri + persistenceUnit + "/entity/" + descriptor.getAlias() + "/{primaryKey}"));
        }
        if (!descriptor.getMappings().isEmpty()) {
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                this.addMapping(returnDescriptor, mapping);
            }
        }
        this.addQueries(returnDescriptor.getQueries(), context, descriptor.getJavaClassName());
        return returnDescriptor;
    }

    private Query getQuery(DatabaseQuery query, PersistenceContext context) {
        String method = query.isReadQuery() ? "get" : "post";
        String jpql = query.getJPQLString() == null ? "" : query.getJPQLString();
        StringBuilder parameterString = new StringBuilder();
        for (String argument : query.getArguments()) {
            parameterString.append(";");
            parameterString.append(argument).append("={").append(argument).append("}");
        }
        String version = context.getVersion();
        Query returnQuery = null;
        returnQuery = version != null ? new Query(query.getName(), jpql, new LinkTemplate("execute", method, context.getBaseURI() + version + "/" + context.getName() + "/query/" + query.getName() + parameterString)) : new Query(query.getName(), jpql, new LinkTemplate("execute", method, context.getBaseURI() + context.getName() + "/query/" + query.getName() + parameterString));
        if (query.isReportQuery()) {
            query.checkPrepare((AbstractSession)context.getServerSession(), (AbstractRecord)new DatabaseRecord());
            for (ReportItem item : ((ReportQuery)query).getItems()) {
                if (item.getMapping() != null) {
                    if (item.getAttributeExpression() != null && item.getAttributeExpression().isMapEntryExpression()) {
                        if (((MapEntryExpression)item.getAttributeExpression()).shouldReturnMapEntry()) {
                            returnQuery.getReturnTypes().add(Map.Entry.class.getSimpleName());
                            continue;
                        }
                        returnQuery.getReturnTypes().add(((Class)((CollectionMapping)item.getMapping()).getContainerPolicy().getKeyType()).getSimpleName());
                        continue;
                    }
                    returnQuery.getReturnTypes().add(item.getMapping().getAttributeClassification().getSimpleName());
                    continue;
                }
                if (item.getResultType() != null) {
                    returnQuery.getReturnTypes().add(item.getResultType().getSimpleName());
                    continue;
                }
                if (item.getDescriptor() != null) {
                    returnQuery.getReturnTypes().add(item.getDescriptor().getJavaClass().getSimpleName());
                    continue;
                }
                if (item.getAttributeExpression() != null && item.getAttributeExpression().isConstantExpression()) {
                    returnQuery.getReturnTypes().add(((ConstantExpression)item.getAttributeExpression()).getValue().getClass().getSimpleName());
                    continue;
                }
                returnQuery.getReturnTypes().add(ClassConstants.OBJECT.getSimpleName());
            }
        } else {
            returnQuery.getReturnTypes().add(query.getReferenceClassName() == null ? "" : query.getReferenceClass().getSimpleName());
        }
        return returnQuery;
    }

    private String getSimplePublicCollectionTypeName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        LinkedHashSet all = new LinkedHashSet();
        this.getInterfaces(clazz, all);
        ArrayList list = new ArrayList(all);
        for (int i = 0; i < all.size(); ++i) {
            Class<?> clas = list.get(i);
            if (clas.getName().equals(List.class.getName())) {
                return List.class.getSimpleName();
            }
            if (clas.getName().equals(Map.class.getName())) {
                return Map.class.getSimpleName();
            }
            if (!clas.getName().equals(Set.class.getName())) continue;
            return Set.class.getSimpleName();
        }
        return null;
    }

    private void getInterfaces(Class<?> clazz, HashSet<Class<?>> interfaceList) {
        while (clazz != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = clazz.getInterfaces()) {
                if (!interfaceList.add(i)) continue;
                this.getInterfaces(i, interfaceList);
            }
            clazz = clazz.getSuperclass();
        }
    }
}

