/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.ProjectHelper;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.XRDynamicClassLoader;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.internal.xr.XRSessionConfigLoader;
import org.eclipse.persistence.internal.xr.XmlBindingsModel;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContext;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContextFactory;
import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.server.ServerSession;

public class XRServiceFactory {
    public XRServiceAdapter xrService;
    public ClassLoader parentClassLoader;
    public InputStream xrSchemaStream;
    static final String XMLNS_STR = "xmlns";
    static final String XML_BINDINGS_STR = "xml-bindings";
    static final String ORM_MAPPINGS_STR = "orm-mappings";
    static final String DOM_PLATFORM_CLASSNAME = "org.eclipse.persistence.oxm.platform.DOMPlatform";
    static final String OXM_PROCESSING_EX = "An exception occurred processing OXM metadata";
    static final String ORM_PROCESSING_EX = "An exception occurred processing ORM metadata";
    static final String OX_PRJ_SUFFIX = "-dbws-ox";
    static final String OR_PRJ_SUFFIX = "-dbws-or";
    static final String DEFAULT_PROJECT_NAME = "org.eclipse.persistence.sessions.Project";
    static final String COLLECTION_WRAPPER_STR = "_CollectionWrapper";
    static final String SIMPLE_XML_FORMAT_STR = "simple-xml-format";

    public XRServiceAdapter buildService() {
        this.initializeService(this.parentClassLoader, this.xrSchemaStream);
        return this.xrService;
    }

    public XRServiceAdapter buildService(XRServiceModel xrServiceModel) {
        this.xrService = new XRServiceAdapter();
        this.xrService.setName(xrServiceModel.getName());
        this.xrService.setSessionsFile(xrServiceModel.getSessionsFile());
        this.xrService.setOperations(xrServiceModel.getOperations());
        this.initializeService(this.parentClassLoader, this.xrSchemaStream);
        return this.xrService;
    }

    public void initializeService(ClassLoader parentClassLoader, InputStream xrSchemaStream) {
        this.parentClassLoader = parentClassLoader;
        this.xrSchemaStream = xrSchemaStream;
        this.loadXMLSchema(xrSchemaStream);
        this.logoutSessions();
        this.buildSessions();
        this.customizeSession(this.xrService.orSession, this.xrService.oxSession);
        this.buildDescriptorIndex();
        this.validateOperations();
        this.initializeOperations();
        this.loginSessions();
    }

    public void customizeSession(Session orSession, Session oxSession) {
    }

    public void loadXMLSchema(InputStream xrSchemaStream) {
        SchemaModelProject schemaProject = new SchemaModelProject();
        XMLContext xmlContext = new XMLContext((Project)schemaProject);
        XMLUnmarshaller unmarshaller = xmlContext.createUnmarshaller();
        Schema schema = (Schema)unmarshaller.unmarshal(xrSchemaStream);
        NamespaceResolver nr = schema.getNamespaceResolver();
        String targetNamespace = schema.getTargetNamespace();
        nr.put("ns1", targetNamespace);
        this.xrService.schema = schema;
        this.xrService.schemaNamespace = targetNamespace;
    }

    protected Project loadORMetadata(XRDynamicClassLoader xrdecl, ServerSession session) {
        Project orProject = null;
        String searchPath = null;
        InputStream inStream = null;
        String[] stringArray = Util.META_INF_PATHS;
        int n = Util.META_INF_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            searchPath = String.valueOf(prefix) + "eclipselink-dbws-or.xml";
            inStream = xrdecl.getResourceAsStream(searchPath);
            if (inStream != null) break;
            ++n2;
        }
        try {
            if (inStream != null) {
                MetadataProcessor processor = new MetadataProcessor((PersistenceUnitInfo)new XRPersistenceUnitInfo(xrdecl), (AbstractSession)session, (ClassLoader)((Object)xrdecl), false, true, false, false, false, null, null);
                processor.setMetadataSource((org.eclipse.persistence.jpa.metadata.MetadataSource)new JPAMetadataSource(xrdecl, new InputStreamReader(inStream)));
                PersistenceUnitProcessor.processORMetadata((MetadataProcessor)processor, (boolean)true, (PersistenceUnitProcessor.Mode)PersistenceUnitProcessor.Mode.ALL);
                processor.addNamedQueries();
                orProject = processor.getProject().getProject();
                orProject.setName(this.xrService.getName().concat(OR_PRJ_SUFFIX));
            }
        }
        catch (Exception exception) {}
        return orProject;
    }

    protected Project loadOXMetadata(ClassLoader xrdecl) {
        Project oxProject = null;
        InputStream inStream = null;
        String searchPath = null;
        String[] stringArray = Util.META_INF_PATHS;
        int n = Util.META_INF_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            searchPath = String.valueOf(prefix) + "eclipselink-dbws-ox.xml";
            inStream = xrdecl.getResourceAsStream(searchPath);
            if (inStream != null) break;
            ++n2;
        }
        if (inStream != null) {
            HashMap<String, OXMMetadataSource> metadataMap = null;
            StreamSource xml = new StreamSource(inStream);
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlBindingsModel.class});
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                JAXBElement jaxbElt = unmarshaller.unmarshal((Source)xml, XmlBindingsModel.class);
                XmlBindingsModel model = (XmlBindingsModel)jaxbElt.getValue();
                if (model.getBindingsList() != null) {
                    metadataMap = new HashMap<String, OXMMetadataSource>();
                    for (XmlBindings xmlBindings : model.getBindingsList()) {
                        metadataMap.put(xmlBindings.getPackageName(), new OXMMetadataSource(xmlBindings));
                    }
                }
            }
            catch (JAXBException jAXBException) {
                return null;
            }
            if (metadataMap != null) {
                HashMap<String, HashMap<String, OXMMetadataSource>> properties = new HashMap<String, HashMap<String, OXMMetadataSource>>();
                properties.put("eclipselink.oxm.metadata-source", metadataMap);
                try {
                    DynamicJAXBContext jCtx = DynamicJAXBContextFactory.createContextFromOXM((ClassLoader)xrdecl, properties);
                    oxProject = jCtx.getXMLContext().getSession(0).getProject();
                    oxProject.setName(this.xrService.getName().concat(OX_PRJ_SUFFIX));
                }
                catch (JAXBException e) {
                    throw new DBWSException(OXM_PROCESSING_EX, (Throwable)e);
                }
            }
        }
        return oxProject;
    }

    protected static void prepareDescriptors(Project oxProject, Project orProject, XRDynamicClassLoader xrdcl) {
        if (oxProject.getAliasDescriptors() != null) {
            for (Object alias : oxProject.getAliasDescriptors().keySet()) {
                if (alias.equals(SIMPLE_XML_FORMAT_STR)) continue;
                XMLDescriptor xdesc = (XMLDescriptor)oxProject.getAliasDescriptors().get(alias);
                for (DatabaseMapping mapping : xdesc.getMappings()) {
                    if (!(mapping instanceof XMLBinaryDataMapping)) continue;
                    ((XMLBinaryDataMapping)mapping).setAttributeClassification(ClassConstants.APBYTE);
                    ((XMLBinaryDataMapping)mapping).setAttributeClassificationName(ClassConstants.APBYTE.getName());
                }
                ClassDescriptor odesc = (ClassDescriptor)orProject.getAliasDescriptors().get(alias);
                if (odesc == null) continue;
                odesc.convertClassNamesToClasses((ClassLoader)((Object)xrdcl));
            }
        }
    }

    public void buildSessions() {
        String orSessionKey;
        XRDynamicClassLoader projectLoader = new XRDynamicClassLoader(this.parentClassLoader);
        SessionManager sessionManager = SessionManager.getManager();
        boolean found = false;
        String sessionsFile = this.xrService.sessionsFile == null ? "eclipselink-dbws-sessions.xml" : this.xrService.sessionsFile;
        String[] stringArray = Util.META_INF_PATHS;
        int n = Util.META_INF_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String searchPath = String.valueOf(prefix) + sessionsFile;
            XRSessionConfigLoader loader = new XRSessionConfigLoader(searchPath);
            loader.setShouldLogin(false);
            try {
                found = loader.load(sessionManager, (ClassLoader)((Object)projectLoader));
            }
            catch (RuntimeException runtimeException) {}
            if (found) break;
            ++n2;
        }
        if (!found) {
            throw DBWSException.couldNotLocateFile((String)"eclipselink-dbws-sessions.xml");
        }
        ConcurrentMap sessions = sessionManager.getSessions();
        if (!sessions.containsKey(orSessionKey = String.valueOf(this.xrService.name) + "-" + "dbws-or-session")) {
            throw DBWSException.couldNotLocateORSessionForService((String)this.xrService.name);
        }
        String oxSessionKey = String.valueOf(this.xrService.name) + "-" + "dbws-ox-session";
        if (!sessions.containsKey(oxSessionKey)) {
            throw DBWSException.couldNotLocateOXSessionForService((String)this.xrService.name);
        }
        this.xrService.orSession = (Session)sessions.get(orSessionKey);
        this.xrService.oxSession = (Session)sessions.get(oxSessionKey);
        Project oxProject = null;
        oxProject = this.loadOXMetadata((ClassLoader)((Object)projectLoader));
        if (oxProject == null && (oxProject = this.xrService.oxSession.getProject()).getName().length() == 0) {
            oxProject = new SimpleXMLFormatProject();
        }
        ((XMLLogin)oxProject.getDatasourceLogin()).setPlatformClassName(DOM_PLATFORM_CLASSNAME);
        ((XMLLogin)oxProject.getDatasourceLogin()).setEqualNamespaceResolvers(false);
        Project orProject = null;
        orProject = this.loadORMetadata(projectLoader, (ServerSession)this.xrService.orSession);
        if (orProject == null) {
            orProject = this.xrService.orSession.getProject();
            XRServiceFactory.updateFindQueryNames(orProject);
        }
        XRServiceFactory.prepareDescriptors(oxProject, orProject, projectLoader);
        ProjectHelper.fixOROXAccessors(orProject, oxProject);
        this.xrService.xmlContext = new XMLContext(oxProject);
        this.xrService.oxSession = this.xrService.xmlContext.getSession(0);
    }

    public void loginSessions() {
        ((DatabaseSession)this.xrService.orSession).login();
    }

    public void buildDescriptorIndex() {
        for (XMLDescriptor xd : this.xrService.oxSession.getProject().getOrderedDescriptors()) {
            String elementNameNS;
            QName elementName;
            String context;
            XMLSchemaReference schemaReference = xd.getSchemaReference();
            if (schemaReference == null || schemaReference.getType() != 1 || (context = schemaReference.getSchemaContext()) == null || context.lastIndexOf(47) != 0 || (elementName = this.resolveName(elementNameNS = context.substring(1), xd.getNamespaceResolver())) == null) continue;
            this.xrService.descriptorsByQName.put(elementName, xd);
        }
    }

    public void validateOperations() {
        for (Operation operation : this.xrService.getOperationsList()) {
            operation.validate(this.xrService);
        }
    }

    public void initializeOperations() {
        for (Operation operation : this.xrService.getOperationsList()) {
            operation.initialize(this.xrService);
        }
    }

    protected void logoutSessions() {
        String orSessionName;
        SessionManager manager = SessionManager.getManager();
        ConcurrentMap sessions = manager.getSessions();
        Session orSession = (Session)sessions.remove(orSessionName = String.valueOf(this.xrService.name) + "-" + "dbws-or-session");
        if (orSession != null && orSession.isConnected()) {
            ((DatabaseSession)orSession).logout();
        }
        String oxSessionName = String.valueOf(this.xrService.name) + "-" + "dbws-ox-session";
        sessions.remove(oxSessionName);
        this.xrService.orSession = null;
        this.xrService.oxSession = null;
    }

    protected QName resolveName(String name, NamespaceResolver ns) {
        if (ns == null) {
            return null;
        }
        if ("any".equals(name)) {
            return Constants.ANY_QNAME;
        }
        int index = name.indexOf(58);
        if (index != -1) {
            String uri = ns.resolveNamespacePrefix(name.substring(0, index));
            return new QName(uri, name.substring(index + 1));
        }
        if (ns.getDefaultNamespaceURI() != null) {
            return new QName(ns.getDefaultNamespaceURI(), name);
        }
        String uri = ns.resolveNamespacePrefix(XMLNS_STR);
        return new QName(uri, name);
    }

    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder db = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return db;
    }

    public static Transformer getTransformer() {
        Transformer transformer = null;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {}
        return transformer;
    }

    protected static void updateFindQueryNames(Project orProject) {
        for (ClassDescriptor orDesc : orProject.getDescriptors().values()) {
            Vector queries = orDesc.getQueryManager().getAllQueries();
            int i = 0;
            while (i < queries.size()) {
                DatabaseQuery query = (DatabaseQuery)queries.get(i);
                String qName = query.getName();
                String END_PART = "_" + query.getDescriptor().getAlias() + "Type";
                if (("findByPrimaryKey".equals(qName) || "findAll".equals(qName)) && !qName.endsWith(END_PART)) {
                    orDesc.getQueryManager().addQuery(String.valueOf(qName) + END_PART, query);
                }
                ++i;
            }
        }
    }

    public class JPAMetadataSource
    implements org.eclipse.persistence.jpa.metadata.MetadataSource {
        XRDynamicClassLoader xrdecl;
        Reader reader;

        public JPAMetadataSource(XRDynamicClassLoader loader, Reader reader) {
            this.xrdecl = loader;
            this.reader = reader;
        }

        public Map<String, Object> getPropertyOverrides(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
            return null;
        }

        public XMLEntityMappings getEntityMappings(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
            return XMLEntityMappingsReader.read((String)XRServiceFactory.ORM_MAPPINGS_STR, (Reader)this.reader, (ClassLoader)((Object)this.xrdecl), null);
        }
    }

    public class OXMMetadataSource
    implements MetadataSource {
        XmlBindings xmlbindings;

        public OXMMetadataSource(XmlBindings bindings) {
            this.xmlbindings = bindings;
        }

        public XmlBindings getXmlBindings(Map<String, ?> properties, ClassLoader classLoader) {
            return this.xmlbindings;
        }
    }

    public class XRPersistenceUnitInfo
    implements PersistenceUnitInfo {
        XRDynamicClassLoader xrdecl;

        public XRPersistenceUnitInfo(XRDynamicClassLoader loader) {
            this.xrdecl = loader;
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return null;
        }

        public Properties getProperties() {
            return new Properties();
        }

        public URL getPersistenceUnitRootUrl() {
            return null;
        }

        public String getPersistenceUnitName() {
            return null;
        }

        public String getPersistenceProviderClassName() {
            return null;
        }

        public DataSource getNonJtaDataSource() {
            return null;
        }

        public ClassLoader getNewTempClassLoader() {
            return this.xrdecl;
        }

        public List<String> getMappingFileNames() {
            return new ArrayList<String>();
        }

        public List<String> getManagedClassNames() {
            return new ArrayList<String>();
        }

        public DataSource getJtaDataSource() {
            return null;
        }

        public List<URL> getJarFileUrls() {
            return new ArrayList<URL>();
        }

        public ClassLoader getClassLoader() {
            return this.xrdecl;
        }

        public boolean excludeUnlistedClasses() {
            return false;
        }

        public void addTransformer(ClassTransformer arg0) {
        }

        public SharedCacheMode getSharedCacheMode() {
            return null;
        }

        public ValidationMode getValidationMode() {
            return null;
        }

        public String getPersistenceXMLSchemaVersion() {
            return null;
        }
    }
}

