/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.reflect;

import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class TypeResolver {
    private final Class<?> clazz;
    private Map<TypeVariable<?>, Type> cache;

    public TypeResolver(Class<?> contextClass) {
        this.clazz = contextClass;
    }

    public Type resolveParameterType(Parameter parameter) {
        return this.resolveType(parameter.getParameterizedType());
    }

    public Type resolveType(Type type) {
        if (type instanceof TypeVariable) {
            return this.resolve((TypeVariable)type);
        }
        return type;
    }

    private Type resolve(TypeVariable<?> typeVariable) {
        if (this.cache == null) {
            this.cache = TypeResolver.buildTypeVariableMap(this.clazz);
        }
        return this.cache.get(typeVariable);
    }

    private static Map<TypeVariable<?>, Type> buildTypeVariableMap(Class<?> clazz) {
        HashMap result = new HashMap();
        TypeResolver.fillFrom(clazz, result);
        return result;
    }

    private static void fillFrom(Class<?> clazz, Map<TypeVariable<?>, Type> result) {
        TypeResolver.fill(result, clazz.getGenericSuperclass());
        for (Type genericClass : clazz.getGenericInterfaces()) {
            TypeResolver.fill(result, genericClass);
        }
    }

    private static void fill(Map<TypeVariable<?>, Type> result, Type genericClass) {
        ParameterizedType pt;
        Type rt;
        if (genericClass instanceof Class) {
            TypeResolver.fillFrom((Class)genericClass, result);
        } else if (genericClass instanceof ParameterizedType && (rt = (pt = (ParameterizedType)genericClass).getRawType()) instanceof Class) {
            Class rtc = (Class)rt;
            TypeVariable<Class<T>>[] tp = rtc.getTypeParameters();
            Type[] atp = pt.getActualTypeArguments();
            for (int i = 0; i < tp.length; ++i) {
                Type at = atp[i];
                if (at instanceof TypeVariable) {
                    at = result.get(at);
                }
                result.put(tp[i], at);
            }
            TypeResolver.fillFrom(rtc, result);
        }
    }
}

