/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session.states;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.session.Fsm;
import org.eclipse.milo.opcua.sdk.client.session.events.ActivateSessionFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.ActivateSessionSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CloseSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CloseSessionSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.Event;
import org.eclipse.milo.opcua.sdk.client.session.events.InitializeFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.InitializeSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.ReactivateFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.ReactivateSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.TransferFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.TransferSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.states.AbstractSessionState;
import org.eclipse.milo.opcua.sdk.client.session.states.Inactive;
import org.eclipse.milo.opcua.sdk.client.session.states.SessionState;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class Closing
extends AbstractSessionState
implements SessionState {
    private CompletableFuture<Unit> closeFuture = new CompletableFuture();
    private CompletableFuture<OpcUaSession> sessionFuture;

    public CompletableFuture<Unit> getCloseFuture() {
        return this.closeFuture;
    }

    @Override
    public CompletableFuture<OpcUaSession> getSessionFuture() {
        return this.sessionFuture;
    }

    @Override
    public void onExternalTransition(Fsm fsm, SessionState prev, Event event) {
        this.sessionFuture = prev.getSessionFuture();
        if (event instanceof CloseSessionEvent) {
            CloseSessionEvent e = (CloseSessionEvent)event;
            this.closeFuture = e.getCloseFuture();
        }
    }

    @Override
    public void onInternalTransition(Fsm fsm, Event event) {
        if (event instanceof CreateSessionEvent) {
            CreateSessionEvent e = (CreateSessionEvent)event;
            this.closeFuture.whenComplete((u, ex) -> e.getSessionFuture().completeExceptionally(new UaException(2149974016L)));
        } else if (event instanceof CloseSessionEvent) {
            CloseSessionEvent e = (CloseSessionEvent)event;
            FutureUtils.complete(e.getCloseFuture()).with(this.closeFuture);
        } else if (event instanceof CreateSessionSuccessEvent) {
            CreateSessionSuccessEvent e = (CreateSessionSuccessEvent)event;
            NodeId authToken = e.getResponse().getAuthenticationToken();
            NodeId sessionId = e.getResponse().getSessionId();
            Closing.closeSessionAsync(fsm, authToken, sessionId, this.closeFuture, e.getSessionFuture());
        } else if (event instanceof CreateSessionFailureEvent) {
            CreateSessionFailureEvent e = (CreateSessionFailureEvent)event;
            fsm.getClient().getConfig().getExecutor().execute(() -> fsm.fireEvent(new CloseSessionSuccessEvent(this.closeFuture, e.getSessionFuture())));
        } else if (event instanceof ActivateSessionSuccessEvent) {
            ActivateSessionSuccessEvent e = (ActivateSessionSuccessEvent)event;
            Closing.closeSessionAsync(fsm, e.getSession(), this.closeFuture, e.getSessionFuture());
        } else if (event instanceof ActivateSessionFailureEvent) {
            ActivateSessionFailureEvent e = (ActivateSessionFailureEvent)event;
            fsm.getClient().getConfig().getExecutor().execute(() -> fsm.fireEvent(new CloseSessionSuccessEvent(this.closeFuture, e.getSessionFuture())));
        } else if (event instanceof TransferSuccessEvent) {
            TransferSuccessEvent e = (TransferSuccessEvent)event;
            Closing.closeSessionAsync(fsm, e.getSession(), this.closeFuture, e.getSessionFuture());
        } else if (event instanceof TransferFailureEvent) {
            TransferFailureEvent e = (TransferFailureEvent)event;
            Closing.closeSessionAsync(fsm, e.getSession(), this.closeFuture, e.getSessionFuture());
        } else if (event instanceof ReactivateSuccessEvent) {
            ReactivateSuccessEvent e = (ReactivateSuccessEvent)event;
            Closing.closeSessionAsync(fsm, e.getSession(), this.closeFuture, e.getSessionFuture());
        } else if (event instanceof ReactivateFailureEvent) {
            ReactivateFailureEvent e = (ReactivateFailureEvent)event;
            fsm.getClient().getConfig().getExecutor().execute(() -> fsm.fireEvent(new CloseSessionSuccessEvent(this.closeFuture, e.getSessionFuture())));
        } else if (event instanceof InitializeSuccessEvent) {
            InitializeSuccessEvent e = (InitializeSuccessEvent)event;
            Closing.closeSessionAsync(fsm, e.getSession(), this.closeFuture, e.getSessionFuture());
        } else if (event instanceof InitializeFailureEvent) {
            InitializeFailureEvent e = (InitializeFailureEvent)event;
            Closing.closeSessionAsync(fsm, e.getSession(), this.closeFuture, e.getSessionFuture());
        }
    }

    @Override
    public SessionState execute(Fsm fsm, Event event) {
        if (event instanceof CloseSessionSuccessEvent) {
            this.closeFuture.complete(Unit.VALUE);
            this.sessionFuture.completeExceptionally(new UaException(2149974016L));
            return new Inactive();
        }
        return this;
    }
}

