/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.SessionActivityListener;
import org.eclipse.milo.opcua.sdk.client.api.ServiceFaultListener;
import org.eclipse.milo.opcua.sdk.client.session.Fsm;
import org.eclipse.milo.opcua.sdk.client.session.events.CloseSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.Event;
import org.eclipse.milo.opcua.sdk.client.session.events.ServiceFaultEvent;
import org.eclipse.milo.opcua.sdk.client.session.states.Active;
import org.eclipse.milo.opcua.sdk.client.session.states.Inactive;
import org.eclipse.milo.opcua.sdk.client.session.states.SessionState;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFsm {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Fsm fsm = new Fsm(){

        @Override
        public OpcUaClient getClient() {
            return SessionFsm.this.client;
        }

        @Override
        public void fireEvent(Event event) {
            SessionFsm.this.fireEvent(event);
        }

        @Override
        public List<SessionInitializer> getInitializers() {
            return SessionFsm.this.initializers;
        }
    };
    private final List<SessionInitializer> initializers = Lists.newCopyOnWriteArrayList();
    private final List<SessionActivityListener> listeners = Lists.newCopyOnWriteArrayList();
    private final AtomicReference<SessionState> state = new AtomicReference<Inactive>(new Inactive());
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final ExecutionQueue notificationQueue;
    private final OpcUaClient client;

    public SessionFsm(OpcUaClient client) {
        this.client = client;
        this.notificationQueue = new ExecutionQueue(client.getConfig().getExecutor());
        client.addFaultListener(new FaultListener(this.fsm));
    }

    public CompletableFuture<OpcUaSession> openSession() {
        CompletableFuture<OpcUaSession> sessionFuture = new CompletableFuture<OpcUaSession>();
        this.fireEvent(new CreateSessionEvent(sessionFuture));
        return FutureUtils.completeAsync(new CompletableFuture(), (Executor)this.client.getConfig().getExecutor()).with(sessionFuture);
    }

    public CompletableFuture<Unit> closeSession() {
        CompletableFuture<Unit> closeFuture = new CompletableFuture<Unit>();
        this.fireEvent(new CloseSessionEvent(closeFuture));
        return FutureUtils.completeAsync(new CompletableFuture(), (Executor)this.client.getConfig().getExecutor()).with(closeFuture);
    }

    public CompletableFuture<OpcUaSession> getSession() {
        this.readWriteLock.readLock().lock();
        try {
            CompletableFuture<OpcUaSession> sessionFuture = this.state.get().getSessionFuture();
            if (sessionFuture.isDone()) {
                CompletableFuture<OpcUaSession> completableFuture = sessionFuture;
                return completableFuture;
            }
            CompletableFuture completableFuture = FutureUtils.completeAsync(new CompletableFuture(), (Executor)this.client.getConfig().getExecutor()).with(sessionFuture);
            return completableFuture;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void addInitializer(SessionInitializer initializer) {
        this.initializers.add(initializer);
    }

    public void removeInitializer(SessionInitializer initializer) {
        this.initializers.remove(initializer);
    }

    public void addListener(SessionActivityListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SessionActivityListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(Event event) {
        if (this.readWriteLock.writeLock().isHeldByCurrentThread()) {
            this.client.getConfig().getExecutor().execute(() -> this.fireEvent(event));
        } else {
            this.readWriteLock.writeLock().lock();
            try {
                SessionState prevState = this.state.get();
                SessionState nextState = this.state.updateAndGet(state -> state.execute(this.fsm, event));
                this.logger.debug("S({}) x E({}) = S'({})", new Object[]{prevState.getClass().getSimpleName(), event.getClass().getSimpleName(), nextState.getClass().getSimpleName()});
                if (prevState.getClass() == nextState.getClass()) {
                    nextState.onInternalTransition(this.fsm, event);
                } else {
                    nextState.onExternalTransition(this.fsm, prevState, event);
                    if (nextState instanceof Active) {
                        this.notifySessionActive(((Active)nextState).getSession());
                    } else if (prevState instanceof Active) {
                        this.notifySessionInactive(((Active)prevState).getSession());
                    }
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    private void notifySessionActive(OpcUaSession session) {
        this.logger.debug("notifySessionActive()");
        this.notificationQueue.submit(() -> {
            this.logger.debug("notifying {} listeners...", (Object)this.listeners.size());
            this.listeners.forEach(listener -> {
                try {
                    listener.onSessionActive(session);
                }
                catch (Throwable t) {
                    this.logger.warn("Uncaught Throwable notifying listener: {}", listener, (Object)t);
                }
            });
        });
    }

    private void notifySessionInactive(OpcUaSession session) {
        this.logger.debug("notifySessionInactive()");
        this.notificationQueue.submit(() -> {
            this.logger.debug("notifying {} listeners...", (Object)this.listeners.size());
            this.listeners.forEach(listener -> {
                try {
                    listener.onSessionInactive(session);
                }
                catch (Throwable t) {
                    this.logger.warn("Uncaught Throwable notifying listener: {}", listener, (Object)t);
                }
            });
        });
    }

    public static interface SessionInitializer {
        public CompletableFuture<Unit> initialize(UaTcpStackClient var1, OpcUaSession var2);
    }

    private static class FaultListener
    implements ServiceFaultListener {
        private static final Predicate<StatusCode> SESSION_ERROR = statusCode -> {
            long status = statusCode.getValue();
            return status == 2149974016L || status == 2149908480L || status == 2150039552L;
        };
        private static final Predicate<StatusCode> SECURE_CHANNEL_ERROR = statusCode -> {
            long status = statusCode.getValue();
            return status == 0x80220000L || status == 2148728832L || status == 2155806720L || status == 2152923136L;
        };
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final Fsm fsm;

        FaultListener(Fsm fsm) {
            this.fsm = fsm;
        }

        @Override
        public void onServiceFault(ServiceFault serviceFault) {
            StatusCode serviceResult = serviceFault.getResponseHeader().getServiceResult();
            if (SESSION_ERROR.or(SECURE_CHANNEL_ERROR).test(serviceResult)) {
                this.logger.debug("ServiceFault: {}", (Object)serviceResult);
                this.fsm.fireEvent(new ServiceFaultEvent(serviceResult));
            }
        }
    }
}

