/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class UaVariableNode
extends UaNode
implements VariableNode {
    public UaVariableNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<? extends VariableNode> getVariableComponent(String namespaceUri, String name) {
        UShort namespaceIndex = this.client.getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getVariableComponent(new QualifiedName(namespaceIndex, name));
        }
        return FutureUtils.failedUaFuture((long)2151546880L);
    }

    public CompletableFuture<? extends VariableNode> getVariableComponent(QualifiedName browseName) {
        UInteger nodeClassMask = Unsigned.uint((int)NodeClass.Variable.getValue());
        UInteger resultMask = Unsigned.uint((int)BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.nodeId, BrowseDirection.Forward, Identifiers.HasComponent, Boolean.valueOf(false), nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List references = ConversionUtil.l((Object[])result.getReferences());
            Optional node = references.stream().filter(r -> browseName.equals((Object)r.getBrowseName())).flatMap(r -> {
                Optional<CompletableFuture> opt = r.getNodeId().local().map(id -> this.client.getAddressSpace().getVariableNode((NodeId)id));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.orElse(FutureUtils.failedUaFuture((long)2151546880L));
        });
    }

    public CompletableFuture<? extends VariableTypeNode> getTypeDefinition() {
        UInteger nodeClassMask = Unsigned.uint((int)NodeClass.VariableType.getValue());
        UInteger resultMask = Unsigned.uint((int)BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.nodeId, BrowseDirection.Forward, Identifiers.HasTypeDefinition, Boolean.valueOf(false), nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List references = ConversionUtil.l((Object[])result.getReferences());
            Optional node = references.stream().flatMap(r -> {
                Optional<VariableTypeNode> opt = r.getNodeId().local().map(id -> this.client.getAddressSpace().createVariableTypeNode((NodeId)id));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.map(CompletableFuture::completedFuture).orElse(FutureUtils.failedUaFuture((long)2151546880L));
        });
    }

    @Override
    public CompletableFuture<Object> getValue() {
        return this.getAttributeOrFail(this.readValue());
    }

    @Override
    public CompletableFuture<NodeId> getDataType() {
        return this.getAttributeOrFail(this.readDataType());
    }

    @Override
    public CompletableFuture<Integer> getValueRank() {
        return this.getAttributeOrFail(this.readValueRank());
    }

    @Override
    public CompletableFuture<UInteger[]> getArrayDimensions() {
        return this.getAttributeOrFail(this.readArrayDimensions());
    }

    @Override
    public CompletableFuture<UByte> getAccessLevel() {
        return this.getAttributeOrFail(this.readAccessLevel());
    }

    @Override
    public CompletableFuture<UByte> getUserAccessLevel() {
        return this.getAttributeOrFail(this.readUserAccessLevel());
    }

    @Override
    public CompletableFuture<Double> getMinimumSamplingInterval() {
        return this.getAttributeOrFail(this.readMinimumSamplingInterval());
    }

    @Override
    public CompletableFuture<Boolean> getHistorizing() {
        return this.getAttributeOrFail(this.readHistorizing());
    }

    @Override
    public CompletableFuture<StatusCode> setValue(Object value) {
        return this.writeValue(DataValue.valueOnly((Variant)new Variant(value)));
    }

    @Override
    public CompletableFuture<StatusCode> setDataType(NodeId dataType) {
        return this.writeDataType(DataValue.valueOnly((Variant)new Variant((Object)dataType)));
    }

    @Override
    public CompletableFuture<StatusCode> setValueRank(int valueRank) {
        return this.writeValueRank(DataValue.valueOnly((Variant)new Variant((Object)valueRank)));
    }

    @Override
    public CompletableFuture<StatusCode> setArrayDimensions(UInteger[] arrayDimensions) {
        return this.writeArrayDimensions(DataValue.valueOnly((Variant)new Variant((Object)arrayDimensions)));
    }

    @Override
    public CompletableFuture<StatusCode> setAccessLevel(UByte accessLevel) {
        return this.writeAccessLevel(DataValue.valueOnly((Variant)new Variant((Object)accessLevel)));
    }

    @Override
    public CompletableFuture<StatusCode> setUserAccessLevel(UByte userAccessLevel) {
        return this.writeUserAccessLevel(DataValue.valueOnly((Variant)new Variant((Object)userAccessLevel)));
    }

    @Override
    public CompletableFuture<StatusCode> setMinimumSamplingInterval(double minimumSamplingInterval) {
        return this.writeMinimumSamplingInterval(DataValue.valueOnly((Variant)new Variant((Object)minimumSamplingInterval)));
    }

    @Override
    public CompletableFuture<StatusCode> setHistorizing(boolean historizing) {
        return this.writeHistorizing(DataValue.valueOnly((Variant)new Variant((Object)historizing)));
    }

    @Override
    public CompletableFuture<DataValue> readValue() {
        return this.readAttribute(AttributeId.Value);
    }

    @Override
    public CompletableFuture<DataValue> readDataType() {
        return this.readAttribute(AttributeId.DataType);
    }

    @Override
    public CompletableFuture<DataValue> readValueRank() {
        return this.readAttribute(AttributeId.ValueRank);
    }

    @Override
    public CompletableFuture<DataValue> readArrayDimensions() {
        return this.readAttribute(AttributeId.ArrayDimensions);
    }

    @Override
    public CompletableFuture<DataValue> readAccessLevel() {
        return this.readAttribute(AttributeId.AccessLevel);
    }

    @Override
    public CompletableFuture<DataValue> readUserAccessLevel() {
        return this.readAttribute(AttributeId.UserAccessLevel);
    }

    @Override
    public CompletableFuture<DataValue> readMinimumSamplingInterval() {
        return this.readAttribute(AttributeId.MinimumSamplingInterval);
    }

    @Override
    public CompletableFuture<DataValue> readHistorizing() {
        return this.readAttribute(AttributeId.Historizing);
    }

    @Override
    public CompletableFuture<StatusCode> writeValue(DataValue value) {
        return this.writeAttribute(AttributeId.Value, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeDataType(DataValue value) {
        return this.writeAttribute(AttributeId.DataType, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeValueRank(DataValue value) {
        return this.writeAttribute(AttributeId.ValueRank, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeArrayDimensions(DataValue value) {
        return this.writeAttribute(AttributeId.ArrayDimensions, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeAccessLevel(DataValue value) {
        return this.writeAttribute(AttributeId.AccessLevel, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeUserAccessLevel(DataValue value) {
        return this.writeAttribute(AttributeId.UserAccessLevel, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeMinimumSamplingInterval(DataValue value) {
        return this.writeAttribute(AttributeId.MinimumSamplingInterval, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeHistorizing(DataValue value) {
        return this.writeAttribute(AttributeId.Historizing, value);
    }
}

