/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FiniteStateMachineNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.StateNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.TransitionNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.FiniteStateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.FiniteTransitionVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ProgramDiagnosticNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ProgramStateMachineType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ProgramDiagnosticDataType;

public class ProgramStateMachineNode
extends FiniteStateMachineNode
implements ProgramStateMachineType {
    public ProgramStateMachineNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> getCreatableNode() {
        return this.getPropertyNode(ProgramStateMachineType.CREATABLE);
    }

    @Override
    public CompletableFuture<Boolean> getCreatable() {
        return this.getProperty(ProgramStateMachineType.CREATABLE);
    }

    @Override
    public CompletableFuture<StatusCode> setCreatable(Boolean value) {
        return this.setProperty(ProgramStateMachineType.CREATABLE, value);
    }

    public CompletableFuture<PropertyNode> getDeletableNode() {
        return this.getPropertyNode(ProgramStateMachineType.DELETABLE);
    }

    @Override
    public CompletableFuture<Boolean> getDeletable() {
        return this.getProperty(ProgramStateMachineType.DELETABLE);
    }

    @Override
    public CompletableFuture<StatusCode> setDeletable(Boolean value) {
        return this.setProperty(ProgramStateMachineType.DELETABLE, value);
    }

    public CompletableFuture<PropertyNode> getAutoDeleteNode() {
        return this.getPropertyNode(ProgramStateMachineType.AUTO_DELETE);
    }

    @Override
    public CompletableFuture<Boolean> getAutoDelete() {
        return this.getProperty(ProgramStateMachineType.AUTO_DELETE);
    }

    @Override
    public CompletableFuture<StatusCode> setAutoDelete(Boolean value) {
        return this.setProperty(ProgramStateMachineType.AUTO_DELETE, value);
    }

    public CompletableFuture<PropertyNode> getRecycleCountNode() {
        return this.getPropertyNode(ProgramStateMachineType.RECYCLE_COUNT);
    }

    @Override
    public CompletableFuture<Integer> getRecycleCount() {
        return this.getProperty(ProgramStateMachineType.RECYCLE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setRecycleCount(Integer value) {
        return this.setProperty(ProgramStateMachineType.RECYCLE_COUNT, value);
    }

    public CompletableFuture<PropertyNode> getInstanceCountNode() {
        return this.getPropertyNode(ProgramStateMachineType.INSTANCE_COUNT);
    }

    @Override
    public CompletableFuture<UInteger> getInstanceCount() {
        return this.getProperty(ProgramStateMachineType.INSTANCE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setInstanceCount(UInteger value) {
        return this.setProperty(ProgramStateMachineType.INSTANCE_COUNT, value);
    }

    public CompletableFuture<PropertyNode> getMaxInstanceCountNode() {
        return this.getPropertyNode(ProgramStateMachineType.MAX_INSTANCE_COUNT);
    }

    @Override
    public CompletableFuture<UInteger> getMaxInstanceCount() {
        return this.getProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxInstanceCount(UInteger value) {
        return this.setProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT, value);
    }

    public CompletableFuture<PropertyNode> getMaxRecycleCountNode() {
        return this.getPropertyNode(ProgramStateMachineType.MAX_RECYCLE_COUNT);
    }

    @Override
    public CompletableFuture<UInteger> getMaxRecycleCount() {
        return this.getProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxRecycleCount(UInteger value) {
        return this.setProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT, value);
    }

    @Override
    public CompletableFuture<FiniteStateVariableNode> getCurrentStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentState").thenApply(FiniteStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getCurrentState() {
        return ((CompletableFuture)this.getCurrentStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setCurrentState(LocalizedText value) {
        return this.getCurrentStateNode().thenCompose(node -> node.setValue(value));
    }

    @Override
    public CompletableFuture<FiniteTransitionVariableNode> getLastTransitionNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "LastTransition").thenApply(FiniteTransitionVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getLastTransition() {
        return ((CompletableFuture)this.getLastTransitionNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setLastTransition(LocalizedText value) {
        return this.getLastTransitionNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ProgramDiagnosticNode> getProgramDiagnosticsNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "ProgramDiagnostics").thenApply(ProgramDiagnosticNode.class::cast);
    }

    @Override
    public CompletableFuture<ProgramDiagnosticDataType> getProgramDiagnostics() {
        return ((CompletableFuture)this.getProgramDiagnosticsNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, ProgramDiagnosticDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> setProgramDiagnostics(ProgramDiagnosticDataType value) {
        return this.getProgramDiagnosticsNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<BaseObjectNode> getFinalResultDataNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "FinalResultData").thenApply(BaseObjectNode.class::cast);
    }

    public CompletableFuture<StateNode> getReadyNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Ready").thenApply(StateNode.class::cast);
    }

    public CompletableFuture<StateNode> getRunningNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Running").thenApply(StateNode.class::cast);
    }

    public CompletableFuture<StateNode> getSuspendedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Suspended").thenApply(StateNode.class::cast);
    }

    public CompletableFuture<StateNode> getHaltedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Halted").thenApply(StateNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getHaltedToReadyNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "HaltedToReady").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getReadyToRunningNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "ReadyToRunning").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getRunningToHaltedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToHalted").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getRunningToReadyNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToReady").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getRunningToSuspendedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToSuspended").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getSuspendedToRunningNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToRunning").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getSuspendedToHaltedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToHalted").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getSuspendedToReadyNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToReady").thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> getReadyToHaltedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "ReadyToHalted").thenApply(TransitionNode.class::cast);
    }
}

