/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import javax.ws.rs.WebApplicationException;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.eclipse.microprofile.rest.client.tck.providers.TestResponseExceptionMapper;
import org.eclipse.microprofile.rest.client.tck.providers.TestResponseExceptionMapperHandles;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CallMultipleMappersTest
extends WiremockArquillianTest {
    @Deployment
    public static Archive<?> createDeployment() {
        String simpleName = CallMultipleMappersTest.class.getSimpleName();
        return ((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addClasses(new Class[]{WiremockArquillianTest.class, SimpleGetApi.class, TestResponseExceptionMapper.class, TestResponseExceptionMapperHandles.class});
    }

    @Test
    public void testCallsTwoProvidersWithTwoRegisteredProvider() throws Exception {
        TestResponseExceptionMapper.reset();
        TestResponseExceptionMapperHandles.reset();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withBody("body is ignored in this test")));
        SimpleGetApi simpleGetApi = (SimpleGetApi)((RestClientBuilder)((RestClientBuilder)RestClientBuilder.newBuilder().baseUri(CallMultipleMappersTest.getServerURI()).register(TestResponseExceptionMapper.class)).register(TestResponseExceptionMapperHandles.class)).build(SimpleGetApi.class);
        try {
            simpleGetApi.executeGet();
            Assert.fail((String)("A " + WebApplicationException.class + " should have been thrown via the registered " + TestResponseExceptionMapper.class));
        }
        catch (WebApplicationException w) {
            Assert.assertEquals((String)w.getMessage(), (String)"A 200 OK was received, but I'm throwing an exception", (String)("The message should be sourced from " + TestResponseExceptionMapper.class));
            Assert.assertTrue((boolean)TestResponseExceptionMapper.isHandlesCalled(), (String)("The handles method should have been called on " + TestResponseExceptionMapper.class));
            Assert.assertTrue((boolean)TestResponseExceptionMapper.isThrowableCalled(), (String)("The toThrowable method should have been called on " + TestResponseExceptionMapper.class));
            Assert.assertTrue((boolean)TestResponseExceptionMapperHandles.isHandlesCalled(), (String)("The handles method should have been called on " + TestResponseExceptionMapperHandles.class));
            Assert.assertTrue((boolean)TestResponseExceptionMapperHandles.isThrowableCalled(), (String)("The toThrowable method should have been called on " + TestResponseExceptionMapperHandles.class));
        }
    }
}

