/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.ssl;

import java.security.KeyStore;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.interfaces.JsonPClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.ssl.ClientWithKeystoreAndTruststore;
import org.eclipse.microprofile.rest.client.tck.interfaces.ssl.ClientWithKeystoreFromClasspathAndTruststore;
import org.eclipse.microprofile.rest.client.tck.interfaces.ssl.ClientWithNonMatchingStore;
import org.eclipse.microprofile.rest.client.tck.interfaces.ssl.ClientWithTruststore;
import org.eclipse.microprofile.rest.client.tck.ssl.AbstractSslTest;
import org.eclipse.microprofile.rest.client.tck.ssl.HttpsServer;
import org.eclipse.microprofile.rest.client.tck.utils.ConfigUtil;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.testng.annotations.Test;

public class SslMutualTest
extends AbstractSslTest {
    @Inject
    private JsonPClient clientWithNoSslStores;
    @Inject
    private ClientWithTruststore clientWithTruststore;
    @Inject
    private ClientWithKeystoreAndTruststore clientWithMutualSsl;
    @Inject
    private ClientWithNonMatchingStore clientWithNonMatchingKeyStore;
    @Inject
    private ClientWithKeystoreFromClasspathAndTruststore clientWithKeystoreFromClasspathAndTruststore;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(SslMutualTest.class.getSimpleName() + ".war"));
        SslMutualTest.initializeTest(webArchive, server -> server.keyStore(serverKeystore.getAbsolutePath(), "password").trustStore(serverTruststore.getAbsolutePath(), "password"));
        String config = ConfigUtil.configLine(JsonPClient.class, "uri", BASE_URI_STRING) + ConfigUtil.configLine(ClientWithTruststore.class, "trustStore", SslMutualTest.filePath(clientTruststore)) + ConfigUtil.configLine(ClientWithTruststore.class, "trustStoreType", "pkcs12") + ConfigUtil.configLine(ClientWithTruststore.class, "trustStorePassword", "password") + ConfigUtil.configLine(ClientWithTruststore.class, "uri", BASE_URI_STRING) + ConfigUtil.configLine(ClientWithKeystoreAndTruststore.class, "trustStore", SslMutualTest.filePath(clientTruststore)) + ConfigUtil.configLine(ClientWithKeystoreAndTruststore.class, "trustStoreType", "pkcs12") + ConfigUtil.configLine(ClientWithKeystoreAndTruststore.class, "trustStorePassword", "password") + ConfigUtil.configLine(ClientWithKeystoreAndTruststore.class, "keyStore", SslMutualTest.filePath(clientKeystore)) + ConfigUtil.configLine(ClientWithKeystoreAndTruststore.class, "keyStoreType", "pkcs12") + ConfigUtil.configLine(ClientWithKeystoreAndTruststore.class, "keyStorePassword", "password") + ConfigUtil.configLine(ClientWithKeystoreAndTruststore.class, "uri", BASE_URI_STRING) + ConfigUtil.configLine(ClientWithKeystoreFromClasspathAndTruststore.class, "trustStore", SslMutualTest.filePath(clientTruststore)) + ConfigUtil.configLine(ClientWithKeystoreFromClasspathAndTruststore.class, "trustStorePassword", "password") + ConfigUtil.configLine(ClientWithKeystoreFromClasspathAndTruststore.class, "trustStoreType", "pkcs12") + ConfigUtil.configLine(ClientWithKeystoreFromClasspathAndTruststore.class, "keyStore", "classpath:/META-INF/" + clientKeystoreFromClasspath) + ConfigUtil.configLine(ClientWithKeystoreFromClasspathAndTruststore.class, "keyStoreType", "pkcs12") + ConfigUtil.configLine(ClientWithKeystoreFromClasspathAndTruststore.class, "keyStorePassword", "password") + ConfigUtil.configLine(ClientWithKeystoreFromClasspathAndTruststore.class, "uri", BASE_URI_STRING) + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "trustStore", SslMutualTest.filePath(clientTruststore)) + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "trustStoreType", "pkcs12") + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "trustStorePassword", "password") + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "keyStore", SslMutualTest.filePath(serverKeystore)) + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "keyStoreType", "pkcs12") + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "keyStorePassword", "password") + ConfigUtil.configLine(ClientWithNonMatchingStore.class, "uri", BASE_URI_STRING);
        ((WebArchive)((WebArchive)((WebArchive)webArchive.addClasses(new Class[]{JsonPClient.class, ClientWithTruststore.class, ClientWithNonMatchingStore.class, ClientWithKeystoreAndTruststore.class, ClientWithKeystoreFromClasspathAndTruststore.class, HttpsServer.class, AbstractSslTest.class})).addAsWebInfResource((Asset)new StringAsset(config), "classes/META-INF/microprofile-config.properties")).addAsWebInfResource((Asset)new ClassLoaderAsset("ssl/" + clientKeystoreFromClasspath), "classes/META-INF/" + clientKeystoreFromClasspath)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return webArchive;
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithNoClientSignature() throws Exception {
        KeyStore trustStore = SslMutualTest.getKeyStore(clientTruststore);
        ((JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).trustStore(trustStore).build(JsonPClient.class)).get("1");
    }

    @Test
    public void shouldWorkWithClientSignature() throws Exception {
        KeyStore trustStore = SslMutualTest.getKeyStore(clientTruststore);
        KeyStore keyStore = SslMutualTest.getKeyStore(clientKeystore);
        JsonPClient client = (JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).trustStore(trustStore).keyStore(keyStore, "password").build(JsonPClient.class);
        Assert.assertEquals((Object)"bar", (Object)client.get("1").getString("foo"));
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithInvalidClientSignature() throws Exception {
        KeyStore trustStore = SslMutualTest.getKeyStore(clientTruststore);
        KeyStore wrongKeyStore = SslMutualTest.getKeyStore(serverKeystore);
        ((JsonPClient)RestClientBuilder.newBuilder().baseUri(BASE_URI).trustStore(trustStore).keyStore(wrongKeyStore, "password").build(JsonPClient.class)).get("1");
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithNoClientSignatureCDI() {
        this.clientWithNoSslStores.get("1");
    }

    @Test
    public void shouldWorkWithClientSignatureCDI() {
        Assert.assertEquals((Object)"bar", (Object)this.clientWithMutualSsl.get("1").getString("foo"));
    }

    @Test
    public void shouldWorkWithClientSignatureFromClasspathCDI() {
        Assert.assertEquals((Object)"bar", (Object)this.clientWithKeystoreFromClasspathAndTruststore.get("1").getString("foo"));
    }

    @Test(expectedExceptions={ProcessingException.class})
    public void shouldFailWithInvalidClientSignatureCDI() {
        this.clientWithNonMatchingKeyStore.get("1");
    }
}

