/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.net.MalformedURLException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.InterfaceBase;
import org.eclipse.microprofile.rest.client.tck.interfaces.InterfaceWithoutProvidersDefined;
import org.eclipse.microprofile.rest.client.tck.providers.TestClientRequestFilter;
import org.eclipse.microprofile.rest.client.tck.providers.TestClientResponseFilter;
import org.eclipse.microprofile.rest.client.tck.providers.TestMessageBodyReader;
import org.eclipse.microprofile.rest.client.tck.providers.TestMessageBodyWriter;
import org.eclipse.microprofile.rest.client.tck.providers.TestParamConverterProvider;
import org.eclipse.microprofile.rest.client.tck.providers.TestReaderInterceptor;
import org.eclipse.microprofile.rest.client.tck.providers.TestWriterInterceptor;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InvokeWithBuiltProvidersTest
extends WiremockArquillianTest {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(InvokeWithBuiltProvidersTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{InterfaceWithoutProvidersDefined.class, WiremockArquillianTest.class, InterfaceBase.class})).addPackage(TestClientResponseFilter.class.getPackage());
    }

    @Test
    public void testInvokesPostOperationWithRegisteredProviders() throws Exception {
        String inputBody = "input body will be removed";
        String outputBody = "output body will be removed";
        String expectedReceivedBody = "this is the replaced writer " + inputBody;
        String expectedResponseBody = "this is the replaced body";
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withBody(outputBody)));
        InterfaceWithoutProvidersDefined api = this.createClient();
        Response response = api.executePost(inputBody);
        String body = (String)response.readEntity(String.class);
        response.close();
        Assert.assertEquals((String)body, (String)expectedResponseBody);
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)WireMock.equalTo((String)expectedReceivedBody)));
        Assert.assertEquals((int)TestClientResponseFilter.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestClientRequestFilter.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestReaderInterceptor.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestWriterInterceptor.getAndResetValue(), (int)1);
    }

    @Test
    public void testInvokesPutOperationWithRegisteredProviders() throws Exception {
        String inputBody = "input body will be removed";
        String outputBody = "output body will be removed";
        String expectedReceivedBody = "this is the replaced writer " + inputBody;
        String expectedResponseBody = "this is the replaced body";
        String id = "id";
        String expectedId = "toStringid";
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlPattern)WireMock.urlEqualTo((String)("/" + expectedId))).willReturn(WireMock.aResponse().withBody(outputBody)));
        InterfaceWithoutProvidersDefined api = this.createClient();
        Response response = api.executePut(id, inputBody);
        String body = (String)response.readEntity(String.class);
        response.close();
        Assert.assertEquals((String)body, (String)expectedResponseBody);
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)("/" + expectedId))).withRequestBody((ContentPattern)WireMock.equalTo((String)expectedReceivedBody)));
        Assert.assertEquals((int)TestClientResponseFilter.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestClientRequestFilter.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestReaderInterceptor.getAndResetValue(), (int)1);
        Assert.assertEquals((int)TestWriterInterceptor.getAndResetValue(), (int)1);
    }

    private InterfaceWithoutProvidersDefined createClient() throws MalformedURLException {
        return (InterfaceWithoutProvidersDefined)((RestClientBuilder)((RestClientBuilder)((RestClientBuilder)((RestClientBuilder)((RestClientBuilder)((RestClientBuilder)((RestClientBuilder)RestClientBuilder.newBuilder().register(TestClientRequestFilter.class)).register(TestClientResponseFilter.class)).register(TestMessageBodyReader.class)).register(TestMessageBodyWriter.class)).register(TestParamConverterProvider.class)).register(TestReaderInterceptor.class)).register(TestWriterInterceptor.class)).baseUri(InvokeWithBuiltProvidersTest.getServerURI()).build(InterfaceWithoutProvidersDefined.class);
    }
}

