/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

@WebServlet(value={"/"})
public class YamlToJsonConverterServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 9080;
    private static final String OPENAPI_PATH = "/openapi";
    public static final String TCK_HEADER_USERNAME = "x-tck-username";
    public static final String TCK_HEADER_PASSWORD = "x-tck-password";
    public static final String TCK_HEADER_SERVERURL = "x-tck-serverurl";
    private Set<String> ignoredHeaders = new HashSet<String>(Arrays.asList("x-tck-username", "x-tck-password", "x-tck-serverurl"));
    private String username = null;
    private String password = null;
    private String serverUrl = "http://localhost:9080";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.extractProperties(request);
        BufferedReader rd = null;
        PrintWriter writer = null;
        try {
            HttpClientBuilder builder = HttpClientBuilder.create();
            if (this.username != null && this.password != null) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
                provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            }
            CloseableHttpClient client = builder.build();
            HttpGet targetRequest = new HttpGet(this.serverUrl + OPENAPI_PATH);
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (this.ignoredHeaders.contains(headerName)) continue;
                Enumeration headers = request.getHeaders(headerName);
                while (headers.hasMoreElements()) {
                    targetRequest.addHeader(headerName, (String)headers.nextElement());
                }
            }
            HttpResponse targetResponse = client.execute((HttpUriRequest)targetRequest);
            response.setStatus(targetResponse.getStatusLine().getStatusCode());
            Arrays.stream(targetResponse.getAllHeaders()).forEach(h -> response.addHeader(h.getName(), h.getValue()));
            String yaml = EntityUtils.toString((HttpEntity)targetResponse.getEntity());
            ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
            Object obj = yamlReader.readValue(yaml, Object.class);
            ObjectMapper jsonWriter = new ObjectMapper();
            String json = jsonWriter.writeValueAsString(obj);
            writer = response.getWriter();
            writer.print(json);
            writer.close();
        }
        catch (Exception e) {
            response.sendError(500, "Failed to convert the request: " + ExceptionUtils.getMessage((Throwable)e));
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void extractProperties(HttpServletRequest request) {
        this.serverUrl = request.getHeader(TCK_HEADER_SERVERURL);
        this.username = request.getHeader(TCK_HEADER_USERNAME);
        this.password = request.getHeader(TCK_HEADER_PASSWORD);
    }
}

