/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.tags;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.tck.tags.MeteredTagMethodBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MeteredTagMethodBeanTest {
    private static final String METER_NAME = MetricRegistry.name(MeteredTagMethodBean.class, (String[])new String[]{"meteredMethod"});
    private static final Tag NUMBER_ONE_TAG = new Tag("number", "one");
    private static final Tag NUMBER_TWO_TAG = new Tag("number", "two");
    private static MetricID meterOneMID;
    private static MetricID meterTwoMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private MeteredTagMethodBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MeteredTagMethodBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        meterOneMID = new MetricID(METER_NAME, new Tag[]{NUMBER_ONE_TAG});
        meterTwoMID = new MetricID(METER_NAME, new Tag[]{NUMBER_TWO_TAG});
    }

    @Test
    @InSequence(value=1)
    public void meteredTagMethodRegistered() {
        Assert.assertThat((String)"Meter is not registered correctly", (Object)this.registry.getMeters(), (Matcher)Matchers.hasKey((Object)meterOneMID));
        Assert.assertThat((String)"Meter is not registered correctly", (Object)this.registry.getMeters(), (Matcher)Matchers.hasKey((Object)meterTwoMID));
    }
}

