/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.tck.metrics.SimplyTimedMethodBean2;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SimplyTimedMethodBeanTest {
    private static final String TIMER_NAME = MetricRegistry.name(SimplyTimedMethodBean2.class, (String[])new String[]{"simplyTimedMethod"});
    private static MetricID simpleTimerMID;
    private static final AtomicLong TIMER_COUNT;
    @Inject
    private MetricRegistry registry;
    @Inject
    private SimplyTimedMethodBean2 bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(SimplyTimedMethodBean2.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        simpleTimerMID = new MetricID(TIMER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void simplyTimedMethodNotCalledYet() {
        Assert.assertThat((String)"SimpleTimer is not registered correctly", (Object)this.registry.getSimpleTimers(), (Matcher)Matchers.hasKey((Object)simpleTimerMID));
        SimpleTimer simpleTimer = (SimpleTimer)this.registry.getSimpleTimers().get(simpleTimerMID);
        Assert.assertThat((String)"SimpleTimer count is incorrect", (Object)simpleTimer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TIMER_COUNT.get())));
    }

    @Test
    @InSequence(value=2)
    public void callSimplyTimedMethodOnce() {
        Assert.assertThat((String)"SimpleTimer is not registered correctly", (Object)this.registry.getSimpleTimers(), (Matcher)Matchers.hasKey((Object)simpleTimerMID));
        SimpleTimer simpleTimer = (SimpleTimer)this.registry.getSimpleTimers().get(simpleTimerMID);
        this.bean.simplyTimedMethod();
        Assert.assertThat((String)"SimpleTimer count is incorrect", (Object)simpleTimer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TIMER_COUNT.incrementAndGet())));
    }

    @Test
    @InSequence(value=3)
    public void removeSimpleTimerFromRegistry() {
        Assert.assertThat((String)"SimpleTimer is not registered correctly", (Object)this.registry.getSimpleTimers(), (Matcher)Matchers.hasKey((Object)simpleTimerMID));
        SimpleTimer simpleTimer = (SimpleTimer)this.registry.getSimpleTimers().get(simpleTimerMID);
        this.registry.remove(simpleTimerMID);
        try {
            this.bean.simplyTimedMethod();
        }
        catch (RuntimeException cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
            Assert.assertThat((String)"SimpleTimer count is incorrect", (Object)simpleTimer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TIMER_COUNT.get())));
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }

    static {
        TIMER_COUNT = new AtomicLong();
    }
}

