/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.trs.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.lyo.core.trs.Base;
import org.eclipse.lyo.core.trs.ChangeEvent;
import org.eclipse.lyo.core.trs.Creation;
import org.eclipse.lyo.core.trs.Deletion;
import org.eclipse.lyo.core.trs.Modification;
import org.eclipse.lyo.core.trs.Page;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.oslc4j.trs.server.HistoryData;

public class TRSUtil {
    public static final SimpleDateFormat XSD_DATETIME_FORMAT;
    public static final URI NIL_URI;
    public static QName dateModifiedQname;
    static Comparator<ChangeEvent> changeEventComparator;

    public static List<Resource> getResourcesWithTypeFromModel(Model model, String fullQualifiedRDFTypeName) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ResIterator listSubjects = null;
        ResIterator resIterator = listSubjects = model.listSubjectsWithProperty(RDF.type, (RDFNode)model.getResource(fullQualifiedRDFTypeName));
        while (resIterator.hasNext()) {
            Resource resource = (Resource)resIterator.next();
            resources.add(resource);
        }
        return resources;
    }

    public static List<ChangeEvent> getChangeEventsFromChangeLogJenaModel(Model changeLogJenaModel) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, SecurityException, NoSuchMethodException, DatatypeConfigurationException, OslcCoreApplicationException, URISyntaxException {
        Modification changeEvent;
        ArrayList<ChangeEvent> changeEvents = new ArrayList<ChangeEvent>();
        List<Resource> modificationResources = TRSUtil.getResourcesWithTypeFromModel(changeLogJenaModel, "http://open-services.net/ns/core/trs#Modification");
        List<Resource> creationResources = TRSUtil.getResourcesWithTypeFromModel(changeLogJenaModel, "http://open-services.net/ns/core/trs#Creation");
        List<Resource> deletionResources = TRSUtil.getResourcesWithTypeFromModel(changeLogJenaModel, "http://open-services.net/ns/core/trs#Deletion");
        for (Resource jenaRes : modificationResources) {
            changeEvent = (Modification)JenaModelHelper.fromJenaResource((Resource)jenaRes, Modification.class);
            changeEvents.add((ChangeEvent)changeEvent);
        }
        for (Resource jenaRes : creationResources) {
            changeEvent = (Creation)JenaModelHelper.fromJenaResource((Resource)jenaRes, Creation.class);
            changeEvents.add((ChangeEvent)changeEvent);
        }
        for (Resource jenaRes : deletionResources) {
            changeEvent = (Deletion)JenaModelHelper.fromJenaResource((Resource)jenaRes, Deletion.class);
            changeEvents.add((ChangeEvent)changeEvent);
        }
        return changeEvents;
    }

    public static Model readJenaModelFromFile(String filePath) throws IOException {
        Model rdFModel = ModelFactory.createDefaultModel();
        FileInputStream is = new FileInputStream(filePath);
        rdFModel.read((InputStream)is, null);
        ((InputStream)is).close();
        return rdFModel;
    }

    public static void writeModelToFile(Model jenaModel, String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream os = new FileOutputStream(file);
        RDFWriter rdfWriter = jenaModel.getWriter("RDF/XML");
        rdfWriter.setProperty("showXmlDeclaration", (Object)true);
        rdfWriter.setProperty("allowBadURIs", (Object)"true");
        rdfWriter.setProperty("relativeURIs", (Object)"");
        rdfWriter.write(jenaModel, (OutputStream)os, null);
        os.flush();
        ((OutputStream)os).close();
    }

    @Deprecated
    public static Object historyDataToChangeEvent(Object objToConvert) {
        if (objToConvert instanceof ChangeEvent) {
            ChangeEvent changeEvent = (ChangeEvent)objToConvert;
            URI changed = changeEvent.getChanged();
            Date modificationDate = (Date)changeEvent.getExtendedProperties().get(dateModifiedQname);
            HistoryData hd = null;
            hd = changeEvent instanceof Deletion ? HistoryData.getInstance(modificationDate, changed, "Deleted") : (changeEvent instanceof Modification ? HistoryData.getInstance(modificationDate, changed, "Modified") : HistoryData.getInstance(modificationDate, changed, "Created"));
            return hd;
        }
        if (objToConvert instanceof HistoryData) {
            HistoryData hd = (HistoryData)objToConvert;
            Object changeEvent = null;
            String hdType = hd.getType();
            Date timeStamp = hd.getTimestamp();
            URI changed = hd.getUri();
            int changeOrderInt = RandomUtils.nextInt();
            String changeOrder = String.valueOf(changeOrderInt);
            String changedUriString = "urn:urn-3:cm1.example.com:" + XSD_DATETIME_FORMAT.format(hd.getTimestamp()) + ":" + changeOrder;
            URI changedUri = URI.create(changedUriString);
            changeEvent = hdType.equals("Created") ? new Creation(changedUri, changed, changeOrderInt) : (hdType.equals("Modified") ? new Modification(changedUri, changed, changeOrderInt) : new Deletion(changedUri, changed, changeOrderInt));
            changeEvent.getExtendedProperties().put(dateModifiedQname, timeStamp);
            return changeEvent;
        }
        return null;
    }

    public static String linkHeaderValue(Base base) {
        Page nextPage = base.getNextPage();
        URI pageOf = nextPage.getPageOf().getAbout();
        StringBuilder sb = new StringBuilder();
        String newline = "\n";
        String headerValue = TRSUtil.urize(pageOf.toString()) + "; rel=\"first\"," + "\n" + TRSUtil.urize(nextPage.getNextPage().toString()) + "; rel=\"next\"," + "\n" + "<http://www.w3.org/ns/ldp#Page>; rel=\"type\"" + "\n";
        return headerValue;
    }

    public static String urize(String uri) {
        return "<" + uri + ">";
    }

    static {
        NIL_URI = URI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        dateModifiedQname = new QName("http://purl.org/dc/terms/", "modified");
        changeEventComparator = Comparator.comparingInt(ChangeEvent::getOrder).reversed();
        XSD_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        XSD_DATETIME_FORMAT.setTimeZone(TimeZone.getDefault());
    }
}

