/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JsonRpcRequestFuture<T>
extends CompletableFuture<T> {
    private static final Logger LOG = Logger.getLogger(JsonRpcRequestFuture.class.getName());
    private final Runnable cancelAction;
    private final AtomicBoolean cancelSent;
    private final JsonRpcRequestFuture<?> root;

    public JsonRpcRequestFuture(Runnable cancelAction) {
        this.root = this;
        this.cancelAction = cancelAction;
        this.cancelSent = new AtomicBoolean(false);
    }

    private JsonRpcRequestFuture(JsonRpcRequestFuture<?> root) {
        this.root = root;
        this.cancelAction = null;
        this.cancelSent = null;
    }

    public JsonRpcRequestFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return (JsonRpcRequestFuture)super.acceptEither((CompletionStage)other, (Consumer)action);
    }

    public JsonRpcRequestFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return (JsonRpcRequestFuture)super.acceptEitherAsync((CompletionStage)other, (Consumer)action);
    }

    public JsonRpcRequestFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return (JsonRpcRequestFuture)super.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return (JsonRpcRequestFuture)super.applyToEither((CompletionStage)other, (Function)fn);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return (JsonRpcRequestFuture)super.applyToEitherAsync((CompletionStage)other, (Function)fn);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return (JsonRpcRequestFuture)super.applyToEitherAsync((CompletionStage)other, (Function)fn, executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.root == this) {
            try {
                this.cancelRequest();
            }
            catch (RuntimeException ex) {
                LOG.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return super.cancel(mayInterruptIfRunning);
    }

    public JsonRpcRequestFuture<?> getRoot() {
        return this.root;
    }

    public boolean cancelRequest() {
        JsonRpcRequestFuture<?> root = this.getRoot();
        if (root.isDone()) {
            return false;
        }
        if (root.cancelSent.compareAndSet(false, true)) {
            root.cancelAction.run();
            return true;
        }
        return false;
    }

    @Override
    public JsonRpcRequestFuture<T> completeAsync(Supplier<? extends T> supplier) {
        return (JsonRpcRequestFuture)super.completeAsync(supplier);
    }

    @Override
    public JsonRpcRequestFuture<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        return (JsonRpcRequestFuture)super.completeAsync(supplier, executor);
    }

    @Override
    public JsonRpcRequestFuture<T> completeOnTimeout(T value, long timeout, TimeUnit unit) {
        return (JsonRpcRequestFuture)super.completeOnTimeout(value, timeout, unit);
    }

    @Override
    public JsonRpcRequestFuture<T> copy() {
        return (JsonRpcRequestFuture)super.copy();
    }

    @Override
    public JsonRpcRequestFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return (JsonRpcRequestFuture)super.exceptionally((Function)fn);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return (JsonRpcRequestFuture)super.handle((BiFunction)fn);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return (JsonRpcRequestFuture)super.handleAsync((BiFunction)fn);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return (JsonRpcRequestFuture)super.handleAsync((BiFunction)fn, executor);
    }

    @Override
    public JsonRpcRequestFuture<T> newIncompleteFuture() {
        return new JsonRpcRequestFuture<T>(this.root);
    }

    @Override
    public JsonRpcRequestFuture<T> orTimeout(long timeout, TimeUnit unit) {
        return (JsonRpcRequestFuture)super.orTimeout(timeout, unit);
    }

    public JsonRpcRequestFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return (JsonRpcRequestFuture)super.runAfterBoth((CompletionStage)other, action);
    }

    public JsonRpcRequestFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return (JsonRpcRequestFuture)super.runAfterBothAsync((CompletionStage)other, action);
    }

    public JsonRpcRequestFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return (JsonRpcRequestFuture)super.runAfterBothAsync((CompletionStage)other, action, executor);
    }

    public JsonRpcRequestFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return (JsonRpcRequestFuture)super.runAfterEither((CompletionStage)other, action);
    }

    public JsonRpcRequestFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return (JsonRpcRequestFuture)super.runAfterEitherAsync((CompletionStage)other, action);
    }

    public JsonRpcRequestFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return (JsonRpcRequestFuture)super.runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    public JsonRpcRequestFuture<Void> thenAccept(Consumer<? super T> action) {
        return (JsonRpcRequestFuture)super.thenAccept((Consumer)action);
    }

    public JsonRpcRequestFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return (JsonRpcRequestFuture)super.thenAcceptAsync((Consumer)action);
    }

    public JsonRpcRequestFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return (JsonRpcRequestFuture)super.thenAcceptAsync((Consumer)action, executor);
    }

    public <U> JsonRpcRequestFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return (JsonRpcRequestFuture)super.thenAcceptBoth((CompletionStage)other, (BiConsumer)action);
    }

    public <U> JsonRpcRequestFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return (JsonRpcRequestFuture)super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action);
    }

    public <U> JsonRpcRequestFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return (JsonRpcRequestFuture)super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, executor);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return (JsonRpcRequestFuture)super.thenApply((Function)fn);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return (JsonRpcRequestFuture)super.thenApplyAsync((Function)fn);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return (JsonRpcRequestFuture)super.thenApplyAsync((Function)fn, executor);
    }

    @Override
    public <U, V> JsonRpcRequestFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return (JsonRpcRequestFuture)super.thenCombine((CompletionStage)other, (BiFunction)fn);
    }

    @Override
    public <U, V> JsonRpcRequestFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return (JsonRpcRequestFuture)super.thenCombineAsync((CompletionStage)other, (BiFunction)fn);
    }

    @Override
    public <U, V> JsonRpcRequestFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return (JsonRpcRequestFuture)super.thenCombineAsync((CompletionStage)other, (BiFunction)fn, executor);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return (JsonRpcRequestFuture)super.thenCompose((Function)fn);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return (JsonRpcRequestFuture)super.thenComposeAsync((Function)fn);
    }

    @Override
    public <U> JsonRpcRequestFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return (JsonRpcRequestFuture)super.thenComposeAsync((Function)fn, executor);
    }

    @Override
    public JsonRpcRequestFuture<Void> thenRun(Runnable action) {
        return (JsonRpcRequestFuture)super.thenRun(action);
    }

    @Override
    public JsonRpcRequestFuture<Void> thenRunAsync(Runnable action) {
        return (JsonRpcRequestFuture)super.thenRunAsync(action);
    }

    @Override
    public JsonRpcRequestFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return (JsonRpcRequestFuture)super.thenRunAsync(action, executor);
    }

    @Override
    public JsonRpcRequestFuture<T> toCompletableFuture() {
        return (JsonRpcRequestFuture)super.toCompletableFuture();
    }

    @Override
    public JsonRpcRequestFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return (JsonRpcRequestFuture)super.whenComplete((BiConsumer)action);
    }

    @Override
    public JsonRpcRequestFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return (JsonRpcRequestFuture)super.whenCompleteAsync((BiConsumer)action);
    }

    @Override
    public JsonRpcRequestFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return (JsonRpcRequestFuture)super.whenCompleteAsync((BiConsumer)action, executor);
    }
}

