/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;

public class MessageTypeAdapter
extends TypeAdapter<Message> {
    private static Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private final MessageJsonHandler handler;
    private final Gson gson;

    public MessageTypeAdapter(MessageJsonHandler handler, Gson gson) {
        this.handler = handler;
        this.gson = gson;
    }

    public Message read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        in.beginObject();
        String jsonrpc = null;
        String id = null;
        String method = null;
        Object rawParams = null;
        Object result = null;
        ResponseError error = null;
        block16: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "jsonrpc": {
                    jsonrpc = in.nextString();
                    continue block16;
                }
                case "id": {
                    id = in.nextString();
                    continue block16;
                }
                case "method": {
                    method = in.nextString();
                    continue block16;
                }
                case "params": {
                    rawParams = this.parseParams(in, method);
                    continue block16;
                }
                case "result": {
                    JsonRpcMethod jsonRpcMethod;
                    String resolvedMethod;
                    Type type = null;
                    MethodProvider methodProvider = this.handler.getMethodProvider();
                    if (methodProvider != null && id != null && (resolvedMethod = methodProvider.resolveMethod(id)) != null && (jsonRpcMethod = this.handler.getJsonRpcMethod(resolvedMethod)) != null) {
                        type = jsonRpcMethod.getReturnType();
                    }
                    if (type == null) {
                        result = new JsonParser().parse(in);
                        continue block16;
                    }
                    result = this.gson.fromJson(in, type);
                    continue block16;
                }
                case "error": {
                    error = (ResponseError)this.gson.fromJson(in, ResponseError.class);
                    continue block16;
                }
            }
            in.skipValue();
        }
        in.endObject();
        Object params = this.parseParams(rawParams, method);
        return this.createMessage(jsonrpc, id, method, params, result, error);
    }

    protected Object parseParams(JsonReader in, String method) throws IOException {
        JsonToken next = in.peek();
        if (next == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Type[] parameterTypes = this.getParameterTypes(method);
        if (parameterTypes.length == 1) {
            return this.fromJson(in, parameterTypes[0]);
        }
        if (parameterTypes.length > 1 && next == JsonToken.BEGIN_ARRAY) {
            ArrayList<Object> parameters = new ArrayList<Object>(parameterTypes.length);
            int index = 0;
            in.beginArray();
            while (in.hasNext()) {
                Type parameterType = index < parameterTypes.length ? parameterTypes[index] : null;
                Object parameter = this.fromJson(in, parameterType);
                parameters.add(parameter);
                ++index;
            }
            in.endArray();
            while (index < parameterTypes.length) {
                parameters.add(null);
                ++index;
            }
            return parameters;
        }
        return new JsonParser().parse(in);
    }

    protected Object parseParams(Object params, String method) {
        if (this.isNull(params)) {
            return null;
        }
        if (!(params instanceof JsonElement)) {
            return params;
        }
        JsonElement rawParams = (JsonElement)params;
        Type[] parameterTypes = this.getParameterTypes(method);
        if (parameterTypes.length == 1) {
            return this.fromJson(rawParams, parameterTypes[0]);
        }
        if (parameterTypes.length > 1 && rawParams instanceof JsonArray) {
            JsonArray array = (JsonArray)rawParams;
            ArrayList<Object> parameters = new ArrayList<Object>(Math.max(array.size(), parameterTypes.length));
            int index = 0;
            Iterator iterator = array.iterator();
            while (iterator.hasNext()) {
                Type parameterType = index < parameterTypes.length ? parameterTypes[index] : null;
                Object parameter = this.fromJson((JsonElement)iterator.next(), parameterType);
                parameters.add(parameter);
                ++index;
            }
            while (index < parameterTypes.length) {
                parameters.add(null);
                ++index;
            }
            return parameters;
        }
        return rawParams;
    }

    protected Object fromJson(JsonReader in, Type type) {
        if (this.isNullOrVoidType(type)) {
            return new JsonParser().parse(in);
        }
        return this.gson.fromJson(in, type);
    }

    protected Object fromJson(JsonElement element, Type type) {
        if (this.isNull(element)) {
            return null;
        }
        if (this.isNullOrVoidType(type)) {
            return element;
        }
        Object value = this.gson.fromJson(element, type);
        if (this.isNull(value)) {
            return null;
        }
        return value;
    }

    protected boolean isNull(Object value) {
        return value == null || value instanceof JsonNull;
    }

    protected boolean isNullOrVoidType(Type type) {
        return type == null || Void.class == type;
    }

    protected Type[] getParameterTypes(String method) {
        JsonRpcMethod jsonRpcMethod;
        if (method != null && (jsonRpcMethod = this.handler.getJsonRpcMethod(method)) != null) {
            return jsonRpcMethod.getParameterTypes();
        }
        return EMPTY_TYPE_ARRAY;
    }

    protected Message createMessage(String jsonrpc, String id, String method, Object params, Object result, ResponseError error) {
        if (id != null && method != null) {
            RequestMessage message = new RequestMessage();
            message.setJsonrpc(jsonrpc);
            message.setId(id);
            message.setMethod(method);
            message.setParams(params);
            return message;
        }
        if (id != null) {
            ResponseMessage message = new ResponseMessage();
            message.setJsonrpc(jsonrpc);
            message.setId(id);
            if (error != null) {
                message.setError(error);
            } else {
                JsonRpcMethod jsonRpcMethod;
                String resolvedMethod;
                MethodProvider methodProvider;
                if (result instanceof JsonElement && (methodProvider = this.handler.getMethodProvider()) != null && (resolvedMethod = methodProvider.resolveMethod(id)) != null && (jsonRpcMethod = this.handler.getJsonRpcMethod(resolvedMethod)) != null) {
                    result = this.gson.fromJson((JsonElement)result, jsonRpcMethod.getReturnType());
                }
                message.setResult(result);
            }
            return message;
        }
        if (method != null) {
            NotificationMessage message = new NotificationMessage();
            message.setJsonrpc(jsonrpc);
            message.setMethod(method);
            message.setParams(params);
            return message;
        }
        throw new JsonParseException("Unable to identify the input message.");
    }

    public void write(JsonWriter out, Message message) throws IOException {
        out.beginObject();
        out.name("jsonrpc");
        out.value(message.getJsonrpc() == null ? "2.0" : message.getJsonrpc());
        if (message instanceof RequestMessage) {
            RequestMessage requestMessage = (RequestMessage)message;
            out.name("id");
            out.value(requestMessage.getId());
            out.name("method");
            out.value(requestMessage.getMethod());
            out.name("params");
            Object params = requestMessage.getParams();
            if (params == null) {
                this.writeNullValue(out);
            } else {
                this.gson.toJson(params, params.getClass(), out);
            }
        } else if (message instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            out.name("id");
            out.value(responseMessage.getId());
            if (responseMessage.getError() != null) {
                out.name("error");
                this.gson.toJson((Object)responseMessage.getError(), ResponseError.class, out);
            } else {
                out.name("result");
                Object result = responseMessage.getResult();
                if (result == null) {
                    this.writeNullValue(out);
                } else {
                    this.gson.toJson(result, result.getClass(), out);
                }
            }
        } else if (message instanceof NotificationMessage) {
            NotificationMessage notificationMessage = (NotificationMessage)message;
            out.name("method");
            out.value(notificationMessage.getMethod());
            out.name("params");
            Object params = notificationMessage.getParams();
            if (params == null) {
                this.writeNullValue(out);
            } else {
                this.gson.toJson(params, params.getClass(), out);
            }
        }
        out.endObject();
    }

    protected void writeNullValue(JsonWriter out) throws IOException {
        boolean previousSerializeNulls = out.getSerializeNulls();
        out.setSerializeNulls(true);
        out.nullValue();
        out.setSerializeNulls(previousSerializeNulls);
    }

    public static class Factory
    implements TypeAdapterFactory {
        private final MessageJsonHandler handler;

        public Factory(MessageJsonHandler handler) {
            this.handler = handler;
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Message.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new MessageTypeAdapter(this.handler, gson);
        }
    }
}

