/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapterFactory;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EitherTypeAdapterFactory;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapterFactory;
import org.eclipse.lsp4j.jsonrpc.json.adapters.MessageTypeAdapterFactory;
import org.eclipse.lsp4j.jsonrpc.messages.CancelParams;
import org.eclipse.lsp4j.jsonrpc.messages.Message;

public class MessageJsonHandler {
    public static final JsonRpcMethod CANCEL_METHOD = JsonRpcMethod.notification("$/cancelRequest", CancelParams.class);
    private final Gson gson;
    private final Map<String, JsonRpcMethod> supportedMethods;
    private MethodProvider methodProvider;
    private static MessageJsonHandler toStringInstance;

    public MessageJsonHandler(Map<String, JsonRpcMethod> supportedMethods) {
        this.supportedMethods = supportedMethods;
        this.gson = this.getDefaultGsonBuilder().create();
    }

    public GsonBuilder getDefaultGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new EitherTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new MessageTypeAdapterFactory(this));
    }

    public JsonRpcMethod getJsonRpcMethod(String name) {
        JsonRpcMethod result = this.supportedMethods.get(name);
        if (result != null) {
            return result;
        }
        if (CANCEL_METHOD.getMethodName().equals(name)) {
            return CANCEL_METHOD;
        }
        return null;
    }

    public MethodProvider getMethodProvider() {
        return this.methodProvider;
    }

    public void setMethodProvider(MethodProvider methodProvider) {
        this.methodProvider = methodProvider;
    }

    public Message parseMessage(CharSequence input) {
        return (Message)this.gson.fromJson(input.toString(), Message.class);
    }

    public Message parseMessage(Reader input) {
        return (Message)this.gson.fromJson(input, Message.class);
    }

    public String serialize(Message message) {
        return this.gson.toJson((Object)message, Message.class);
    }

    public void serialize(Message message, Writer output) {
        this.gson.toJson((Object)message, Message.class, (Appendable)output);
    }

    public static String toString(Object object) {
        if (toStringInstance == null) {
            toStringInstance = new MessageJsonHandler(Collections.emptyMap()){

                @Override
                public GsonBuilder getDefaultGsonBuilder() {
                    return super.getDefaultGsonBuilder().setPrettyPrinting();
                }
            };
        }
        return MessageJsonHandler.toStringInstance.gson.toJson(object);
    }
}

