/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;

public class RemoteEndpoint
implements Endpoint,
MessageConsumer,
MethodProvider {
    private static final String CANCEL_METHOD = "$/cancelRequest";
    private static final String CANCEL_METHOD_PARAM_ID = "id";
    private static final Logger LOG = Logger.getLogger(RemoteEndpoint.class.getName());
    private static final Function<Throwable, ResponseError> DEFAULT_EXCEPTION_HANDLER = throwable -> {
        if (throwable instanceof ResponseErrorException) {
            return ((ResponseErrorException)throwable).getResponseError();
        }
        if ((throwable instanceof CompletionException || throwable instanceof InvocationTargetException) && throwable.getCause() instanceof ResponseErrorException) {
            return ((ResponseErrorException)throwable.getCause()).getResponseError();
        }
        ResponseError error = new ResponseError();
        error.setMessage(throwable.getMessage());
        error.setCode(ResponseErrorCode.InternalError);
        return error;
    };
    private final MessageConsumer out;
    private final Endpoint localEndpoint;
    private final Function<Throwable, ResponseError> exceptionHandler;
    private final AtomicInteger nextRequestId = new AtomicInteger();
    private final Map<String, PendingRequestInfo> sentRequestMap = new LinkedHashMap<String, PendingRequestInfo>();
    private final Map<String, CompletableFuture<?>> receivedRequestMap = new LinkedHashMap();

    public RemoteEndpoint(MessageConsumer out, Endpoint localEndpoint, Function<Throwable, ResponseError> exceptionHandler) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (localEndpoint == null) {
            throw new NullPointerException("localEndpoint");
        }
        if (exceptionHandler == null) {
            throw new NullPointerException("exceptionHandler");
        }
        this.out = out;
        this.localEndpoint = localEndpoint;
        this.exceptionHandler = exceptionHandler;
    }

    public RemoteEndpoint(MessageConsumer out, Endpoint localEndpoint) {
        this(out, localEndpoint, DEFAULT_EXCEPTION_HANDLER);
    }

    @Override
    public void notify(String method, Object parameter) {
        NotificationMessage notificationMessage = new NotificationMessage();
        notificationMessage.setJsonrpc("2.0");
        notificationMessage.setMethod(method);
        notificationMessage.setParams(parameter);
        this.out.consume(notificationMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Object> request(String method, Object parameter) {
        RequestMessage requestMessage = new RequestMessage();
        final String id = String.valueOf(this.nextRequestId.incrementAndGet());
        requestMessage.setId(id);
        requestMessage.setMethod(method);
        requestMessage.setParams(parameter);
        CompletableFuture<Object> result = new CompletableFuture<Object>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                RemoteEndpoint.this.sendCancelNotification(id);
                return super.cancel(mayInterruptIfRunning);
            }
        };
        Consumer<ResponseMessage> responseHandler = responseMessage -> {
            if (responseMessage.getError() != null) {
                result.completeExceptionally(new ResponseErrorException(responseMessage.getError()));
            } else {
                result.complete(responseMessage.getResult());
            }
        };
        Map<String, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            this.sentRequestMap.put(id, new PendingRequestInfo(requestMessage, responseHandler));
        }
        this.out.consume(requestMessage);
        return result;
    }

    protected void sendCancelNotification(String id) {
        HashMap<String, String> cancelParams = new HashMap<String, String>();
        cancelParams.put(CANCEL_METHOD_PARAM_ID, id);
        this.notify(CANCEL_METHOD, cancelParams);
    }

    @Override
    public void consume(Message message) {
        if (message instanceof NotificationMessage) {
            NotificationMessage notificationMessage = (NotificationMessage)message;
            this.handleNotification(notificationMessage);
        } else if (message instanceof RequestMessage) {
            RequestMessage requestMessage = (RequestMessage)message;
            this.handleRequest(requestMessage);
        } else if (message instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            this.handleResponse(responseMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResponse(ResponseMessage responseMessage) {
        PendingRequestInfo pendingRequestInfo;
        Map<String, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            pendingRequestInfo = this.sentRequestMap.remove(responseMessage.getId());
        }
        if (pendingRequestInfo == null) {
            LOG.log(Level.WARNING, "Unmatched response message " + responseMessage);
        } else {
            try {
                pendingRequestInfo.responseHandler.accept(responseMessage);
            }
            catch (RuntimeException e) {
                LOG.log(Level.WARNING, "Handling repsonse " + responseMessage + " threw an exception.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNotification(NotificationMessage notificationMessage) {
        if (CANCEL_METHOD.equals(notificationMessage.getMethod())) {
            Object cancelParams = notificationMessage.getParams();
            if (cancelParams instanceof Map) {
                Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
                synchronized (map) {
                    Object idParam = ((Map)cancelParams).get(CANCEL_METHOD_PARAM_ID);
                    if (idParam == null) {
                        LOG.warning("Invalid cancel notification. No id. " + notificationMessage);
                    } else {
                        String id = idParam.toString();
                        CompletableFuture<?> future = this.receivedRequestMap.get(id);
                        if (future == null) {
                            LOG.log(Level.WARNING, "Unmatched cancel notification: " + notificationMessage);
                        } else {
                            future.cancel(true);
                        }
                    }
                }
                return;
            }
            LOG.warning("Cancellation support disabled, since the '$/cancelRequest' method has explicitly been registered.");
        }
        try {
            this.localEndpoint.notify(notificationMessage.getMethod(), notificationMessage.getParams());
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Notification " + notificationMessage + " threw an exception.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(RequestMessage requestMessage) {
        CompletableFuture<?> future;
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setId(requestMessage.getId());
        responseMessage.setJsonrpc("2.0");
        try {
            future = this.localEndpoint.request(requestMessage.getMethod(), requestMessage.getParams());
        }
        catch (RuntimeException e) {
            ResponseError errorObject = this.exceptionHandler.apply(e);
            if (errorObject != null) {
                responseMessage.setError(errorObject);
                this.out.consume(responseMessage);
            }
            return;
        }
        Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
        synchronized (map) {
            this.receivedRequestMap.put(requestMessage.getId(), future);
        }
        ((CompletableFuture)((CompletableFuture)future.thenAccept(result -> {
            responseMessage.setResult(result);
            this.out.consume(responseMessage);
        })).exceptionally(t -> {
            ResponseError errorObject;
            if (!(t instanceof CancellationException) && (errorObject = this.exceptionHandler.apply((Throwable)t)) != null) {
                responseMessage.setError(errorObject);
                this.out.consume(responseMessage);
            }
            return null;
        })).thenApply(obj -> {
            Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
            synchronized (map) {
                this.receivedRequestMap.remove(requestMessage.getId());
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolveMethod(String requestId) {
        Map<String, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            PendingRequestInfo requestInfo = this.sentRequestMap.get(requestId);
            if (requestInfo != null) {
                return requestInfo.requestMessage.getMethod();
            }
        }
        return null;
    }

    private static class PendingRequestInfo {
        RequestMessage requestMessage;
        Consumer<ResponseMessage> responseHandler;

        PendingRequestInfo(RequestMessage requestMessage2, Consumer<ResponseMessage> responseHandler2) {
            this.requestMessage = requestMessage2;
            this.responseHandler = responseHandler2;
        }
    }
}

