/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Arguments for 'next' request.
 */
@SuppressWarnings("all")
public class NextArguments {
  /**
   * Specifies the thread for which to resume execution for one step (of the given granularity).
   */
  private int threadId;

  /**
   * If this flag is true, all other suspended threads are not resumed.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.51
   */
  private Boolean singleThread;

  /**
   * Stepping granularity. If no granularity is specified, a granularity of 'statement' is assumed.
   * <p>
   * This is an optional property.
   */
  private SteppingGranularity granularity;

  /**
   * Specifies the thread for which to resume execution for one step (of the given granularity).
   */
  @Pure
  public int getThreadId() {
    return this.threadId;
  }

  /**
   * Specifies the thread for which to resume execution for one step (of the given granularity).
   */
  public void setThreadId(final int threadId) {
    this.threadId = threadId;
  }

  /**
   * If this flag is true, all other suspended threads are not resumed.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.51
   */
  @Pure
  public Boolean getSingleThread() {
    return this.singleThread;
  }

  /**
   * If this flag is true, all other suspended threads are not resumed.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.51
   */
  public void setSingleThread(final Boolean singleThread) {
    this.singleThread = singleThread;
  }

  /**
   * Stepping granularity. If no granularity is specified, a granularity of 'statement' is assumed.
   * <p>
   * This is an optional property.
   */
  @Pure
  public SteppingGranularity getGranularity() {
    return this.granularity;
  }

  /**
   * Stepping granularity. If no granularity is specified, a granularity of 'statement' is assumed.
   * <p>
   * This is an optional property.
   */
  public void setGranularity(final SteppingGranularity granularity) {
    this.granularity = granularity;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("threadId", this.threadId);
    b.add("singleThread", this.singleThread);
    b.add("granularity", this.granularity);
    return b.toString();
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    NextArguments other = (NextArguments) obj;
    if (other.threadId != this.threadId)
      return false;
    if (this.singleThread == null) {
      if (other.singleThread != null)
        return false;
    } else if (!this.singleThread.equals(other.singleThread))
      return false;
    if (this.granularity == null) {
      if (other.granularity != null)
        return false;
    } else if (!this.granularity.equals(other.granularity))
      return false;
    return true;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + this.threadId;
    result = prime * result + ((this.singleThread== null) ? 0 : this.singleThread.hashCode());
    return prime * result + ((this.granularity== null) ? 0 : this.granularity.hashCode());
  }
}
