/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeResult {
    private ObjectId[] mergedCommits;
    private ObjectId base;
    private ObjectId newHead;
    private Map<String, int[][]> conflicts;
    private MergeStatus mergeStatus;
    private String description;
    private MergeStrategy mergeStrategy;
    private Map<String, ResolveMerger.MergeFailureReason> failingPaths;
    private List<String> checkoutConflicts;

    public MergeResult(ObjectId newHead, ObjectId base, ObjectId[] mergedCommits, MergeStatus mergeStatus, MergeStrategy mergeStrategy, Map<String, org.eclipse.jgit.merge.MergeResult<?>> lowLevelResults) {
        this(newHead, base, mergedCommits, mergeStatus, mergeStrategy, lowLevelResults, null);
    }

    public MergeResult(ObjectId newHead, ObjectId base, ObjectId[] mergedCommits, MergeStatus mergeStatus, MergeStrategy mergeStrategy, Map<String, org.eclipse.jgit.merge.MergeResult<?>> lowLevelResults, String description) {
        this(newHead, base, mergedCommits, mergeStatus, mergeStrategy, lowLevelResults, null, description);
    }

    public MergeResult(ObjectId newHead, ObjectId base, ObjectId[] mergedCommits, MergeStatus mergeStatus, MergeStrategy mergeStrategy, Map<String, org.eclipse.jgit.merge.MergeResult<?>> lowLevelResults, Map<String, ResolveMerger.MergeFailureReason> failingPaths, String description) {
        this.newHead = newHead;
        this.mergedCommits = mergedCommits;
        this.base = base;
        this.mergeStatus = mergeStatus;
        this.mergeStrategy = mergeStrategy;
        this.description = description;
        this.failingPaths = failingPaths;
        if (lowLevelResults != null) {
            for (Map.Entry<String, org.eclipse.jgit.merge.MergeResult<?>> result : lowLevelResults.entrySet()) {
                this.addConflict(result.getKey(), result.getValue());
            }
        }
    }

    public MergeResult(List<String> checkoutConflicts) {
        this.checkoutConflicts = checkoutConflicts;
        this.mergeStatus = MergeStatus.CHECKOUT_CONFLICT;
    }

    public ObjectId getNewHead() {
        return this.newHead;
    }

    public MergeStatus getMergeStatus() {
        return this.mergeStatus;
    }

    public ObjectId[] getMergedCommits() {
        return this.mergedCommits;
    }

    public ObjectId getBase() {
        return this.base;
    }

    public String toString() {
        boolean first = true;
        StringBuilder commits = new StringBuilder();
        for (ObjectId commit : this.mergedCommits) {
            if (!first) {
                commits.append(", ");
            } else {
                first = false;
            }
            commits.append(ObjectId.toString(commit));
        }
        return MessageFormat.format(JGitText.get().mergeUsingStrategyResultedInDescription, new Object[]{commits, ObjectId.toString(this.base), this.mergeStrategy.getName(), this.mergeStatus, this.description == null ? "" : ", " + this.description});
    }

    public void setConflicts(Map<String, int[][]> conflicts) {
        this.conflicts = conflicts;
    }

    public void addConflict(String path, int[][] conflictingRanges) {
        if (this.conflicts == null) {
            this.conflicts = new HashMap<String, int[][]>();
        }
        this.conflicts.put(path, conflictingRanges);
    }

    public void addConflict(String path, org.eclipse.jgit.merge.MergeResult<?> lowLevelResult) {
        if (!lowLevelResult.containsConflicts()) {
            return;
        }
        if (this.conflicts == null) {
            this.conflicts = new HashMap<String, int[][]>();
        }
        int nrOfConflicts = 0;
        for (MergeChunk mergeChunk : lowLevelResult) {
            if (!mergeChunk.getConflictState().equals((Object)MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE)) continue;
            ++nrOfConflicts;
        }
        int currentConflict = -1;
        int[][] ret = new int[nrOfConflicts][this.mergedCommits.length + 1];
        for (MergeChunk mergeChunk : lowLevelResult) {
            int endOfChunk = 0;
            if (mergeChunk.getConflictState().equals((Object)MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE)) {
                if (currentConflict > -1) {
                    ret[currentConflict][this.mergedCommits.length] = endOfChunk;
                }
                endOfChunk = mergeChunk.getEnd();
                ret[++currentConflict][mergeChunk.getSequenceIndex()] = mergeChunk.getBegin();
            }
            if (!mergeChunk.getConflictState().equals((Object)MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE)) continue;
            if (mergeChunk.getEnd() > endOfChunk) {
                endOfChunk = mergeChunk.getEnd();
            }
            ret[currentConflict][mergeChunk.getSequenceIndex()] = mergeChunk.getBegin();
        }
        this.conflicts.put(path, ret);
    }

    public Map<String, int[][]> getConflicts() {
        return this.conflicts;
    }

    public Map<String, ResolveMerger.MergeFailureReason> getFailingPaths() {
        return this.failingPaths;
    }

    public List<String> getCheckoutConflicts() {
        return this.checkoutConflicts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MergeStatus {
        FAST_FORWARD{

            public String toString() {
                return "Fast-forward";
            }

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        FAST_FORWARD_SQUASHED{

            public String toString() {
                return "Fast-forward-squashed";
            }

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        ALREADY_UP_TO_DATE{

            public String toString() {
                return "Already-up-to-date";
            }

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        FAILED{

            public String toString() {
                return "Failed";
            }

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        MERGED{

            public String toString() {
                return "Merged";
            }

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        MERGED_SQUASHED{

            public String toString() {
                return "Merged-squashed";
            }

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        MERGED_SQUASHED_NOT_COMMITTED{

            public String toString() {
                return "Merged-squashed-not-committed";
            }

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        CONFLICTING{

            public String toString() {
                return "Conflicting";
            }

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        ABORTED{

            public String toString() {
                return "Aborted";
            }

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        MERGED_NOT_COMMITTED{

            public String toString() {
                return "Merged-not-committed";
            }

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        NOT_SUPPORTED{

            public String toString() {
                return "Not-yet-supported";
            }

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        CHECKOUT_CONFLICT{

            public String toString() {
                return "Checkout Conflict";
            }

            public boolean isSuccessful() {
                return false;
            }
        };


        public abstract boolean isSuccessful();
    }
}

