/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.awtui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.eclipse.jgit.awtui.UIText;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.ChainingCredentialsProvider;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.NetRCCredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class AwtCredentialsProvider
extends CredentialsProvider {
    public static void install() {
        AwtCredentialsProvider c = new AwtCredentialsProvider();
        ChainingCredentialsProvider cp = new ChainingCredentialsProvider(new CredentialsProvider[]{new NetRCCredentialsProvider(), c});
        CredentialsProvider.setDefault((CredentialsProvider)cp);
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.StringType || i instanceof CredentialItem.CharArrayType || i instanceof CredentialItem.YesNoType || i instanceof CredentialItem.InformationalMessage) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        if (items.length == 0) {
            return true;
        }
        if (items.length == 1) {
            CredentialItem item = items[0];
            if (item instanceof CredentialItem.InformationalMessage) {
                JOptionPane.showMessageDialog(null, item.getPromptText(), UIText.get().warning, 1);
                return true;
            }
            if (item instanceof CredentialItem.YesNoType) {
                CredentialItem.YesNoType v = (CredentialItem.YesNoType)item;
                int r = JOptionPane.showConfirmDialog(null, v.getPromptText(), UIText.get().warning, 0);
                switch (r) {
                    case 0: {
                        v.setValue(true);
                        return true;
                    }
                    case 1: {
                        v.setValue(false);
                        return true;
                    }
                }
                return false;
            }
            return AwtCredentialsProvider.interactive(uri, items);
        }
        return AwtCredentialsProvider.interactive(uri, items);
    }

    private static boolean interactive(URIish uri, CredentialItem[] items) {
        CredentialItem item;
        int i;
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JTextField[] texts = new JTextField[items.length];
        for (i = 0; i < items.length; ++i) {
            item = items[i];
            if (item instanceof CredentialItem.StringType || item instanceof CredentialItem.CharArrayType) {
                gbc.fill = 0;
                gbc.gridwidth = -1;
                gbc.gridx = 0;
                panel.add((Component)new JLabel(item.getPromptText()), gbc);
                gbc.fill = 2;
                gbc.gridwidth = -1;
                gbc.gridx = 1;
                texts[i] = item.isValueSecure() ? new JPasswordField(20) : new JTextField(20);
                panel.add((Component)texts[i], gbc);
                ++gbc.gridy;
                continue;
            }
            if (item instanceof CredentialItem.InformationalMessage) {
                gbc.fill = 0;
                gbc.gridwidth = 0;
                gbc.gridx = 0;
                panel.add((Component)new JLabel(item.getPromptText()), gbc);
                ++gbc.gridy;
                continue;
            }
            throw new UnsupportedCredentialItem(uri, item.getPromptText());
        }
        if (JOptionPane.showConfirmDialog(null, panel, UIText.get().authenticationRequired, 2, 3) != 0) {
            return false;
        }
        for (i = 0; i < items.length; ++i) {
            CredentialItem.StringType v;
            item = items[i];
            JTextField f = texts[i];
            if (item instanceof CredentialItem.StringType) {
                v = (CredentialItem.StringType)item;
                if (f instanceof JPasswordField) {
                    v.setValue(new String(((JPasswordField)f).getPassword()));
                    continue;
                }
                v.setValue(f.getText());
                continue;
            }
            if (!(item instanceof CredentialItem.CharArrayType)) continue;
            v = (CredentialItem.CharArrayType)item;
            if (f instanceof JPasswordField) {
                v.setValueNoCopy(((JPasswordField)f).getPassword());
                continue;
            }
            v.setValueNoCopy(f.getText().toCharArray());
        }
        return true;
    }
}

