/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

public class FakeIndexFactory {
    public static PackIndex indexOf(List<IndexObject> objs) {
        return new FakePackIndex(objs);
    }

    public static PackReverseIndex reverseIndexOf(List<IndexObject> objs) {
        return new FakeReverseIndex(objs);
    }

    private FakeIndexFactory() {
    }

    private static class FakeEntriesIterator
    extends PackIndex.EntriesIterator {
        private static final byte[] buffer = new byte[20];
        private final Iterator<IndexObject> it;

        FakeEntriesIterator(List<IndexObject> objs) {
            super((long)objs.size());
            this.it = objs.iterator();
        }

        protected void readNext() {
            IndexObject next = this.it.next();
            next.getObjectId().copyRawTo(buffer, 0);
            this.setIdBuffer(buffer, 0);
            this.setOffset(next.offset());
        }
    }

    private static class FakePackIndex
    implements PackIndex {
        private static final Comparator<IndexObject> SHA1_COMPARATOR = (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.name(), o2.name());
        private final Map<String, IndexObject> idx;
        private final List<IndexObject> sha1Ordered;
        private final long offset64count;

        FakePackIndex(List<IndexObject> objs) {
            this.sha1Ordered = objs.stream().sorted(SHA1_COMPARATOR).collect(Collectors.toUnmodifiableList());
            this.idx = objs.stream().collect(Collectors.toMap(IndexObject::name, Function.identity()));
            this.offset64count = objs.stream().filter(o -> o.offset > Integer.MAX_VALUE).count();
        }

        public Iterator<PackIndex.MutableEntry> iterator() {
            return new FakeEntriesIterator(this.sha1Ordered);
        }

        public long getObjectCount() {
            return this.sha1Ordered.size();
        }

        public long getOffset64Count() {
            return this.offset64count;
        }

        public ObjectId getObjectId(long nthPosition) {
            return ObjectId.fromString((String)this.sha1Ordered.get((int)nthPosition).name());
        }

        public long getOffset(long nthPosition) {
            return this.sha1Ordered.get((int)nthPosition).offset();
        }

        public long findOffset(AnyObjectId objId) {
            IndexObject o = this.idx.get(objId.name());
            if (o == null) {
                return -1L;
            }
            return o.offset();
        }

        public int findPosition(AnyObjectId objId) {
            IndexObject o = this.idx.get(objId.name());
            if (o == null) {
                return -1;
            }
            return this.sha1Ordered.indexOf(o);
        }

        public long findCRC32(AnyObjectId objId) throws MissingObjectException {
            throw new UnsupportedOperationException();
        }

        public boolean hasCRC32Support() {
            return false;
        }

        public void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
            throw new UnsupportedOperationException();
        }

        public byte[] getChecksum() {
            return new byte[0];
        }
    }

    private static class FakeReverseIndex
    implements PackReverseIndex {
        private static final Comparator<IndexObject> OFFSET_COMPARATOR = Comparator.comparingLong(IndexObject::offset);
        private final List<IndexObject> byOffset;
        private final Map<Long, IndexObject> ridx;

        FakeReverseIndex(List<IndexObject> objs) {
            this.byOffset = objs.stream().sorted(OFFSET_COMPARATOR).collect(Collectors.toUnmodifiableList());
            this.ridx = this.byOffset.stream().collect(Collectors.toMap(IndexObject::offset, Function.identity()));
        }

        public void verifyPackChecksum(String packFilePath) {
        }

        public ObjectId findObject(long offset) {
            IndexObject indexObject = this.ridx.get(offset);
            if (indexObject == null) {
                return null;
            }
            return ObjectId.fromString((String)indexObject.name());
        }

        public long findNextOffset(long offset, long maxOffset) throws CorruptObjectException {
            IndexObject o = this.ridx.get(offset);
            if (o == null) {
                throw new CorruptObjectException("Invalid offset");
            }
            int pos = this.byOffset.indexOf(o);
            if (pos == this.byOffset.size() - 1) {
                return maxOffset;
            }
            return this.byOffset.get(pos + 1).offset();
        }

        public int findPosition(long offset) {
            IndexObject indexObject = this.ridx.get(offset);
            return this.byOffset.indexOf(indexObject);
        }

        public ObjectId findObjectByPosition(int nthPosition) {
            return this.byOffset.get(nthPosition).getObjectId();
        }
    }

    public record IndexObject(String name, long offset) {
        public ObjectId getObjectId() {
            return ObjectId.fromString((String)this.name);
        }
    }
}

