/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.junit.Repeat;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatRule
implements TestRule {
    private static final Logger LOG = Logger.getLogger(RepeatRule.class.getName());

    public Statement apply(Statement statement, Description description) {
        Statement result = statement;
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        if (repeat != null) {
            int n = repeat.n();
            boolean abortOnFailure = repeat.abortOnFailure();
            result = new RepeatStatement(n, abortOnFailure, statement);
        }
        return result;
    }

    private static class RepeatStatement
    extends Statement {
        private final int repetitions;
        private boolean abortOnFailure;
        private final Statement statement;

        private RepeatStatement(int repetitions, boolean abortOnFailure, Statement statement) {
            this.repetitions = repetitions;
            this.abortOnFailure = abortOnFailure;
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            int failures = 0;
            int i = 0;
            while (i < this.repetitions) {
                block4: {
                    try {
                        this.statement.evaluate();
                    }
                    catch (Throwable e) {
                        ++failures;
                        RepeatedTestException ex = new RepeatedTestException(MessageFormat.format("Repeated test failed when run for the {0}. time", i + 1), e);
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        if (!this.abortOnFailure) break block4;
                        throw ex;
                    }
                }
                ++i;
            }
            if (failures > 0) {
                RepeatedTestException e = new RepeatedTestException(MessageFormat.format("Test failed {0} times out of {1} repeated executions", failures, this.repetitions));
                LOG.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
        }
    }

    public static class RepeatedTestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public RepeatedTestException(String message) {
            super(message);
        }

        public RepeatedTestException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

