/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.time;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import org.eclipse.jgit.util.FS;

public class TimeUtil {
    public static Instant setLastModifiedWithOffset(Path path, long offsetMillis) {
        Instant mTime = FS.DETECTED.lastModifiedInstant(path).plusMillis(offsetMillis);
        try {
            Files.setLastModifiedTime(path, FileTime.from(mTime));
            return mTime;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void setLastModifiedOf(Path a, Path b) {
        Instant mTime = FS.DETECTED.lastModifiedInstant(b);
        try {
            Files.setLastModifiedTime(a, FileTime.from(mTime));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

