/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.junit.JGitTestUtil;
import org.eclipse.jgit.junit.LocalDiskRepositoryTestCase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class RepositoryTestCase
extends LocalDiskRepositoryTestCase {
    protected FileRepository db;
    protected File trash;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void copyFile(File src, File dst) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fis = new FileInputStream(src);
            try {
                try (FileOutputStream fos = new FileOutputStream(dst);){
                    int r;
                    byte[] buf = new byte[4096];
                    while ((r = fis.read(buf)) > 0) {
                        fos.write(buf, 0, r);
                    }
                }
                if (fis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected File writeTrashFile(String name, String data) throws IOException {
        return JGitTestUtil.writeTrashFile((Repository)this.db, name, data);
    }

    protected Path writeLink(String link, String target) throws Exception {
        return JGitTestUtil.writeLink((Repository)this.db, link, target);
    }

    protected File writeTrashFile(String subdir, String name, String data) throws IOException {
        return JGitTestUtil.writeTrashFile((Repository)this.db, subdir, name, data);
    }

    protected String read(String name) throws IOException {
        return JGitTestUtil.read((Repository)this.db, name);
    }

    protected boolean check(String name) {
        return JGitTestUtil.check((Repository)this.db, name);
    }

    protected void deleteTrashFile(String name) throws IOException {
        JGitTestUtil.deleteTrashFile((Repository)this.db, name);
    }

    protected static void checkFile(File f, String checkData) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);){
            if (checkData.length() > 0) {
                char[] data = new char[checkData.length()];
                Assert.assertEquals((long)data.length, (long)r.read(data));
                Assert.assertEquals((Object)checkData, (Object)new String(data));
            }
            Assert.assertEquals((long)-1L, (long)((Reader)r).read());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.db = this.createWorkRepository();
        this.trash = this.db.getWorkTree();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.db.close();
        super.tearDown();
    }

    public String indexState(int includedOptions) throws IllegalStateException, IOException {
        return RepositoryTestCase.indexState((Repository)this.db, includedOptions);
    }

    protected void resetIndex(FileTreeIterator treeItr) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectInserter inserter = this.db.newObjectInserter();){
            DirCacheBuilder builder = this.db.lockDirCache().builder();
            while (!treeItr.eof()) {
                long len = treeItr.getEntryLength();
                DirCacheEntry dce = new DirCacheEntry(treeItr.getEntryPathString());
                dce.setFileMode(treeItr.getEntryFileMode());
                dce.setLastModified(treeItr.getEntryLastModifiedInstant());
                dce.setLength((int)len);
                Throwable throwable2 = null;
                Object var10_12 = null;
                try (FileInputStream in = new FileInputStream(treeItr.getEntryFile());){
                    dce.setObjectId((AnyObjectId)inserter.insert(3, len, (InputStream)in));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                builder.add(dce);
                treeItr.next(1);
            }
            builder.commit();
            inserter.flush();
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static String lookup(Object l, String nameTemplate, Map<Object, String> lookupTable) {
        String name = lookupTable.get(l);
        if (name == null) {
            name = nameTemplate.replaceAll("%n", Integer.toString(lookupTable.size()));
            lookupTable.put(l, name);
        }
        return name;
    }

    public static String slashify(String str) {
        str = str.replace('\\', '/');
        return str;
    }

    public static Instant fsTick(File lastFile) throws InterruptedException, IOException {
        File tmp;
        FS fs = FS.DETECTED;
        if (lastFile == null) {
            lastFile = tmp = File.createTempFile("fsTickTmpFile", null);
        } else {
            if (!fs.exists(lastFile)) {
                throw new FileNotFoundException(lastFile.getPath());
            }
            tmp = File.createTempFile("fsTickTmpFile", null, lastFile.getParentFile());
        }
        long res = FS.getFileStoreAttributes((Path)tmp.toPath()).getFsTimestampResolution().toNanos();
        long sleepTime = res / 10L;
        try {
            Instant startTime = fs.lastModifiedInstant(lastFile);
            Instant actTime = fs.lastModifiedInstant(tmp);
            while (actTime.compareTo(startTime) <= 0) {
                TimeUnit.NANOSECONDS.sleep(sleepTime);
                FileUtils.touch((Path)tmp.toPath());
                actTime = fs.lastModifiedInstant(tmp);
            }
            Instant instant = actTime;
            return instant;
        }
        finally {
            FileUtils.delete((File)tmp);
        }
    }

    protected void createBranch(ObjectId objectId, String branchName) throws IOException {
        RefUpdate updateRef = this.db.updateRef(branchName);
        updateRef.setNewObjectId((AnyObjectId)objectId);
        updateRef.update();
    }

    public List<Ref> getRefs() throws IOException {
        return this.db.getRefDatabase().getRefs();
    }

    protected void checkoutBranch(String branchName) throws IllegalStateException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk walk = new RevWalk((Repository)this.db);){
            RevCommit head = walk.parseCommit((AnyObjectId)this.db.resolve("HEAD"));
            RevCommit branch = walk.parseCommit((AnyObjectId)this.db.resolve(branchName));
            DirCacheCheckout dco = new DirCacheCheckout((Repository)this.db, head.getTree().getId(), this.db.lockDirCache(), branch.getTree().getId());
            dco.setFailOnConflict(true);
            dco.checkout();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        RefUpdate refUpdate = this.db.updateRef("HEAD");
        refUpdate.setRefLogMessage("checkout: moving to " + branchName, false);
        refUpdate.link(branchName);
    }

    protected File writeTrashFiles(boolean ensureDistinctTimestamps, String ... contents) throws IOException, InterruptedException {
        File f = null;
        int i = 0;
        while (i < contents.length) {
            if (contents[i] != null) {
                if (ensureDistinctTimestamps && f != null) {
                    RepositoryTestCase.fsTick(f);
                }
                f = this.writeTrashFile(Integer.toString(i), contents[i]);
            }
            ++i;
        }
        return f;
    }

    protected RevCommit commitFile(String filename, String contents, String branch) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Git git = new Git((Repository)this.db);){
                boolean empty;
                Repository repo = git.getRepository();
                String originalBranch = repo.getFullBranch();
                boolean bl = empty = repo.resolve("HEAD") == null;
                if (!empty) {
                    if (repo.findRef(branch) == null) {
                        git.branchCreate().setName(branch).call();
                    }
                    git.checkout().setName(branch).call();
                }
                this.writeTrashFile(filename, contents);
                git.add().addFilepattern(filename).call();
                RevCommit commit = git.commit().setMessage(String.valueOf(branch) + ": " + filename).call();
                if (originalBranch != null) {
                    git.checkout().setName(originalBranch).call();
                } else if (empty) {
                    git.branchCreate().setName(branch).setStartPoint(commit).call();
                }
                return commit;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    protected DirCacheEntry createEntry(String path, FileMode mode) {
        return this.createEntry(path, mode, 0, path);
    }

    protected DirCacheEntry createEntry(String path, FileMode mode, String content) {
        return this.createEntry(path, mode, 0, content);
    }

    protected DirCacheEntry createEntry(String path, FileMode mode, int stage, String content) {
        DirCacheEntry entry = new DirCacheEntry(path, stage);
        entry.setFileMode(mode);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ObjectInserter.Formatter formatter = new ObjectInserter.Formatter();){
            entry.setObjectId((AnyObjectId)formatter.idFor(3, Constants.encode((String)content)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return entry;
    }

    protected DirCacheEntry createGitLink(String path, AnyObjectId objectId) {
        DirCacheEntry entry = new DirCacheEntry(path, 0);
        entry.setFileMode(FileMode.GITLINK);
        entry.setObjectId(objectId);
        return entry;
    }

    public static void assertEqualsFile(File expected, File actual) throws IOException {
        Assert.assertEquals((Object)expected.getCanonicalFile(), (Object)actual.getCanonicalFile());
    }
}

