/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.ssh;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerAuthenticationManager;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.UserAuthFactory;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.gss.UserAuthGSS;
import org.apache.sshd.server.auth.gss.UserAuthGSSFactory;
import org.apache.sshd.server.auth.keyboard.DefaultKeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.command.AbstractCommandSupport;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.shell.UnknownCommand;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;

public class SshTestGitServer {
    public static final String ECHO_COMMAND = "echo";
    @NonNull
    protected final String testUser;
    @NonNull
    protected final Repository repository;
    @NonNull
    protected final List<KeyPair> hostKeys = new ArrayList<KeyPair>();
    protected final SshServer server;
    @NonNull
    protected PublicKey testKey;
    private final CloseableExecutorService executorService = ThreadUtils.newFixedThreadPool((String)"SshTestGitServerPool", (int)2);

    public SshTestGitServer(@NonNull String testUser, @NonNull Path testKey, @NonNull Repository repository, @NonNull byte[] hostKey) throws IOException, GeneralSecurityException {
        this(testUser, SshTestGitServer.readPublicKey(testKey), repository, SshTestGitServer.readKeyPair(hostKey));
    }

    public SshTestGitServer(@NonNull String testUser, @NonNull Path testKey, @NonNull Repository repository, @NonNull KeyPair hostKey) throws IOException, GeneralSecurityException {
        this(testUser, SshTestGitServer.readPublicKey(testKey), repository, hostKey);
    }

    public SshTestGitServer(@NonNull String testUser, @NonNull PublicKey testKey, @NonNull Repository repository, @NonNull KeyPair hostKey) {
        this.testUser = testUser;
        this.setTestUserPublicKey(testKey);
        this.repository = repository;
        ServerBuilder builder = (ServerBuilder)ServerBuilder.builder().signatureFactories(SshTestGitServer.getSignatureFactories());
        this.server = (SshServer)builder.build();
        this.hostKeys.add(hostKey);
        this.server.setKeyPairProvider(session -> this.hostKeys);
        this.configureAuthentication();
        List<SubsystemFactory> subsystems = this.configureSubsystems();
        if (!subsystems.isEmpty()) {
            this.server.setSubsystemFactories(subsystems);
        }
        this.configureShell();
        this.server.setCommandFactory((channel, command) -> {
            if (command.startsWith("git-upload-pack")) {
                return new GitUploadPackCommand(command, this.executorService);
            }
            if (command.startsWith("git-receive-pack")) {
                return new GitReceivePackCommand(command, this.executorService);
            }
            if (command.startsWith(ECHO_COMMAND)) {
                return new EchoCommand(command, this.executorService);
            }
            return new UnknownCommand(command);
        });
    }

    private static List<NamedFactory<Signature>> getSignatureFactories() {
        return Arrays.asList(BuiltinSignatures.nistp256_cert, BuiltinSignatures.nistp384_cert, BuiltinSignatures.nistp521_cert, BuiltinSignatures.ed25519_cert, BuiltinSignatures.rsaSHA512_cert, BuiltinSignatures.rsaSHA256_cert, BuiltinSignatures.rsa_cert, BuiltinSignatures.nistp256, BuiltinSignatures.nistp384, BuiltinSignatures.nistp521, BuiltinSignatures.ed25519, BuiltinSignatures.sk_ecdsa_sha2_nistp256, BuiltinSignatures.sk_ssh_ed25519, BuiltinSignatures.rsaSHA512, BuiltinSignatures.rsaSHA256, BuiltinSignatures.rsa, BuiltinSignatures.dsa_cert, BuiltinSignatures.dsa);
    }

    private static PublicKey readPublicKey(Path key) throws IOException, GeneralSecurityException {
        return ((AuthorizedKeyEntry)AuthorizedKeyEntry.readAuthorizedKeys((Path)key, (OpenOption[])new OpenOption[0]).get(0)).resolvePublicKey(null, PublicKeyEntryResolver.IGNORING);
    }

    private static KeyPair readKeyPair(byte[] keyMaterial) throws IOException, GeneralSecurityException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(keyMaterial);){
            return (KeyPair)SecurityUtils.loadKeyPairIdentities(null, null, (InputStream)in, null).iterator().next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<UserAuthFactory> getAuthFactories() {
        ArrayList<UserAuthFactory> authentications = new ArrayList<UserAuthFactory>();
        authentications.add((UserAuthFactory)new UserAuthGSSFactory(){

            public UserAuth createUserAuth(ServerSession session) throws IOException {
                return new FakeUserAuthGSS();
            }
        });
        authentications.add((UserAuthFactory)ServerAuthenticationManager.DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY);
        authentications.add((UserAuthFactory)ServerAuthenticationManager.DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
        authentications.add((UserAuthFactory)ServerAuthenticationManager.DEFAULT_USER_AUTH_PASSWORD_FACTORY);
        return authentications;
    }

    protected void configureAuthentication() {
        this.server.setUserAuthFactories(this.getAuthFactories());
        this.server.setPasswordAuthenticator(null);
        this.server.setKeyboardInteractiveAuthenticator(null);
        this.server.setHostBasedAuthenticator(null);
        this.server.setGSSAuthenticator(new GSSAuthenticator(){

            public boolean validateInitialUser(ServerSession session, String user) {
                return false;
            }
        });
        this.server.setPublickeyAuthenticator((userName, publicKey, session) -> this.testUser.equals(userName) && KeyUtils.compareKeys((PublicKey)this.testKey, (PublicKey)publicKey));
    }

    @NonNull
    protected List<SubsystemFactory> configureSubsystems() {
        this.server.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(this.repository.getDirectory().getParentFile().getAbsoluteFile().toPath()));
        return Collections.singletonList(new SftpSubsystemFactory.Builder().build());
    }

    protected void configureShell() {
        this.server.setShellFactory(null);
    }

    public void addHostKey(@NonNull Path key, boolean inFront) throws IOException, GeneralSecurityException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = Files.newInputStream(key, new OpenOption[0]);){
            KeyPair pair = (KeyPair)SecurityUtils.loadKeyPairIdentities(null, (NamedResource)NamedResource.ofName((String)key.toString()), (InputStream)in, null).iterator().next();
            this.addHostKey(pair, inFront);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addHostKey(@NonNull KeyPair key, boolean inFront) {
        if (inFront) {
            this.hostKeys.add(0, key);
        } else {
            this.hostKeys.add(key);
        }
    }

    public void enablePasswordAuthentication() {
        this.server.setPasswordAuthenticator((user, pwd, session) -> this.testUser.equals(user) && this.testUser.toUpperCase(Locale.ROOT).equals(pwd));
    }

    public void enableKeyboardInteractiveAuthentication() {
        this.server.setPasswordAuthenticator((user, pwd, session) -> this.testUser.equals(user) && this.testUser.toUpperCase(Locale.ROOT).equals(pwd));
        this.server.setKeyboardInteractiveAuthenticator((KeyboardInteractiveAuthenticator)DefaultKeyboardInteractiveAuthenticator.INSTANCE);
    }

    public PropertyResolver getPropertyResolver() {
        return this.server;
    }

    public int start() throws IOException {
        this.server.start();
        return this.server.getPort();
    }

    public void stop() throws IOException {
        this.executorService.shutdownNow();
        this.server.stop(true);
    }

    public void setTestUserPublicKey(Path key) throws IOException, GeneralSecurityException {
        this.testKey = SshTestGitServer.readPublicKey(key);
    }

    public void setTestUserPublicKey(@NonNull PublicKey key) {
        this.testKey = key;
    }

    public void setPreamble(String ... lines) {
        if (lines != null && lines.length > 0) {
            CoreModuleProperties.SERVER_EXTRA_IDENTIFICATION_LINES.set((PropertyResolver)this.server, (Object)String.join((CharSequence)String.valueOf('|'), lines));
        }
    }

    private static class EchoCommand
    extends AbstractCommandSupport {
        protected EchoCommand(String command, CloseableExecutorService executorService) {
            super(command, ThreadUtils.noClose((CloseableExecutorService)executorService));
        }

        public void run() {
            String[] parts = this.getCommand().split(" ");
            int timeout = 0;
            if (parts.length >= 2) {
                try {
                    timeout = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (timeout > 0) {
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(timeout));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                this.doEcho(this.getCommand(), this.getOutputStream());
                this.onExit(0);
            }
            catch (IOException e) {
                this.log.warn(MessageFormat.format("Could not run {0}", this.getCommand()), (Throwable)e);
                this.onExit(-1, e.toString());
            }
        }

        private void doEcho(String text, OutputStream stream) throws IOException {
            stream.write(text.getBytes(StandardCharsets.UTF_8));
            stream.flush();
        }
    }

    private static class FakeUserAuthGSS
    extends UserAuthGSS {
        private FakeUserAuthGSS() {
        }

        @Nullable
        protected Boolean doAuth(Buffer buffer, boolean initial) throws Exception {
            if (initial) {
                ServerSession session = this.getServerSession();
                Buffer b = session.createBuffer((byte)60);
                b.putBytes(KRB5_MECH.getDER());
                session.writePacket(b);
                return null;
            }
            return Boolean.FALSE;
        }
    }

    private class GitReceivePackCommand
    extends AbstractCommandSupport {
        protected GitReceivePackCommand(String command, CloseableExecutorService executorService) {
            super(command, ThreadUtils.noClose((CloseableExecutorService)executorService));
        }

        public void run() {
            try {
                new ReceivePack(SshTestGitServer.this.repository).receive(this.getInputStream(), this.getOutputStream(), this.getErrorStream());
                this.onExit(0);
            }
            catch (IOException e) {
                this.log.warn(MessageFormat.format("Could not run {0}", this.getCommand()), (Throwable)e);
                this.onExit(-1, e.toString());
            }
        }
    }

    private class GitUploadPackCommand
    extends AbstractCommandSupport {
        protected GitUploadPackCommand(String command, CloseableExecutorService executorService) {
            super(command, ThreadUtils.noClose((CloseableExecutorService)executorService));
        }

        public void run() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (UploadPack uploadPack = new UploadPack(SshTestGitServer.this.repository);){
                    String gitProtocol = (String)this.getEnvironment().getEnv().get("GIT_PROTOCOL");
                    if (gitProtocol != null) {
                        uploadPack.setExtraParameters(Collections.singleton(gitProtocol));
                    }
                    uploadPack.upload(this.getInputStream(), this.getOutputStream(), this.getErrorStream());
                    this.onExit(0);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.log.warn(MessageFormat.format("Could not run {0}", this.getCommand()), (Throwable)e);
                this.onExit(-1, e.toString());
            }
        }
    }
}

